/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Application;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.mapper.IPageSource;
import org.apache.wicket.core.request.mapper.StalePageException;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class PageProvider
implements IPageProvider,
IClusterable {
    private static final long serialVersionUID = 1L;
    private final Integer renderCount;
    private final Integer pageId;
    private transient IPageSource pageSource;
    private Class<? extends IRequestablePage> pageClass;
    private PageParameters pageParameters;
    private transient Provision provision;

    public PageProvider(Integer pageId, Integer renderCount) {
        this.pageId = pageId;
        this.renderCount = renderCount;
    }

    public PageProvider(Integer pageId, Class<? extends IRequestablePage> pageClass, Integer renderCount) {
        this(pageId, pageClass, new PageParameters(), renderCount);
    }

    public PageProvider(Integer pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        this.pageId = pageId;
        this.setPageClass(pageClass);
        this.setPageParameters(pageParameters);
        this.renderCount = renderCount;
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        this.setPageClass(pageClass);
        if (pageParameters != null) {
            this.setPageParameters(pageParameters);
        }
        this.pageId = null;
        this.renderCount = null;
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass) {
        this(pageClass, null);
    }

    public PageProvider(IRequestablePage page) {
        Args.notNull(page, "page");
        this.provision = new Provision().resolveTo(page);
        this.pageId = page.getPageId();
        this.renderCount = page.getRenderCount();
    }

    private Provision getProvision() {
        if (this.provision == null) {
            this.provision = new Provision().resolve();
        }
        return this.provision;
    }

    @Override
    public IRequestablePage getPageInstance() throws PageExpiredException {
        IRequestablePage page = this.getProvision().getPage();
        if (page == null && this.wasExpired()) {
            throw new PageExpiredException("Page with id '" + this.pageId + "' has expired.");
        }
        return page;
    }

    @Override
    public PageParameters getPageParameters() throws PageExpiredException {
        if (this.pageParameters != null) {
            return this.pageParameters;
        }
        if (this.hasPageInstance()) {
            return this.getPageInstance().getPageParameters();
        }
        return null;
    }

    @Override
    public final boolean hasPageInstance() {
        if (this.provision != null || this.pageId != null) {
            return this.getProvision().didResolveToPage();
        }
        return false;
    }

    @Override
    public final boolean doesProvideNewPage() {
        return this.getProvision().doesProvideNewPage();
    }

    @Override
    public boolean wasExpired() {
        return this.pageId != null && this.getProvision().didFailToFindStoredPage();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() throws PageExpiredException {
        if (this.pageClass != null) {
            return this.pageClass;
        }
        return this.getPageInstance().getClass();
    }

    protected IPageSource getPageSource() {
        if (this.pageSource != null) {
            return this.pageSource;
        }
        if (Application.exists()) {
            return Application.get().getMapperContext();
        }
        throw new IllegalStateException("No application is bound to current thread. Call setPageSource() to manually assign pageSource to this provider.");
    }

    @Override
    public void detach() {
        if (this.provision != null) {
            this.provision.detach();
            this.provision = null;
        }
    }

    public void setPageSource(IPageSource pageSource) {
        if (this.provision != null) {
            throw new IllegalStateException("A page was already provided.");
        }
        this.pageSource = pageSource;
    }

    private void setPageClass(Class<? extends IRequestablePage> pageClass) {
        Args.notNull(pageClass, "pageClass");
        this.pageClass = pageClass;
    }

    protected void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    @Override
    public Integer getPageId() {
        return this.pageId;
    }

    @Override
    public Integer getRenderCount() {
        return this.renderCount;
    }

    public String toString() {
        return "PageProvider{renderCount=" + this.renderCount + ", pageId=" + this.pageId + ", pageClass=" + String.valueOf(this.pageClass) + ", pageParameters=" + String.valueOf(this.pageParameters) + "}";
    }

    private class Provision {
        transient IRequestablePage page;
        boolean failedToFindStoredPage;

        private Provision() {
        }

        IRequestablePage getPage() {
            if (this.page == null && this.doesProvideNewPage()) {
                this.page = PageProvider.this.getPageSource().newPageInstance(PageProvider.this.pageClass, PageProvider.this.pageParameters);
            }
            return this.page;
        }

        boolean didResolveToPage() {
            return this.page != null;
        }

        boolean doesProvideNewPage() {
            return (PageProvider.this.pageId == null || this.failedToFindStoredPage) && PageProvider.this.pageClass != null;
        }

        boolean didFailToFindStoredPage() {
            return this.failedToFindStoredPage;
        }

        Provision resolveTo(IRequestablePage page) {
            this.page = page;
            return this;
        }

        Provision resolve() {
            if (PageProvider.this.pageId != null) {
                IRequestablePage stored = PageProvider.this.getPageSource().getPageInstance(PageProvider.this.pageId);
                if (stored != null && (PageProvider.this.pageClass == null || PageProvider.this.pageClass.equals(stored.getClass()))) {
                    this.page = stored;
                    if (PageProvider.this.renderCount != null && this.page.getRenderCount() != PageProvider.this.renderCount.intValue()) {
                        throw new StalePageException(this.page);
                    }
                }
                this.failedToFindStoredPage = this.page == null;
            }
            return this;
        }

        void detach() {
            if (this.page != null) {
                this.page.detach();
            }
        }
    }
}

