/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.wicket.markup.html.panel;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;

/**
 * 
 */
public class Provider extends Panel
{
	private static final long serialVersionUID = 1L;

	private Label fragmentContent;

	/**
	 * Construct.
	 * 
	 * @param id
	 */
	public Provider(String id)
	{
		super(id);
		add(new AjaxLink<Void>("ajaxRefresh")
		{
			private static final long serialVersionUID = 1L;

			@Override
			public void onClick(AjaxRequestTarget target)
			{
				target.add(fragmentContent);
			}
		});
	}

	/**
	 * 
	 * @param container
	 * @param id
	 */
	public void addFragment(WebMarkupContainer container, String id)
	{
		Fragment fragment = new Fragment(id, "fragment", this);
		fragmentContent = new Label("fragmentContent", "foo");
		fragmentContent.setOutputMarkupId(true);
		fragment.add(fragmentContent);
		container.add(fragment);
	}
}
