/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SecretKeys;
import io.smallrye.config._private.ConfigLogging;
import jakarta.annotation.Priority;

@Priority(value=3250)
public class LoggingConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 367246512037404779L;
    private final boolean enabled;

    public LoggingConfigSourceInterceptor() {
        this(true);
    }

    public LoggingConfigSourceInterceptor(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (!this.enabled || !ConfigLogging.log.isDebugEnabled()) {
            return context.proceed(name);
        }
        try {
            ConfigValue configValue = SecretKeys.doLocked(() -> context.proceed(name));
            if (configValue != null) {
                ConfigLogging.log.lookup(configValue.getName(), configValue.getLocation(), configValue.getValue());
            } else {
                ConfigLogging.log.notFound(name);
            }
            return configValue;
        }
        catch (SecurityException configValue) {
            ConfigValue secret = context.proceed(name);
            if (secret != null) {
                ConfigLogging.log.lookup(secret.getName(), "secret", "secret");
            } else {
                ConfigLogging.log.notFound(name);
            }
            return secret;
        }
    }
}

