/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.jstl.tlv;

import jakarta.servlet.jsp.tagext.PageData;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

class PageParser {
    private final SAXParserFactory parserFactory = AccessController.doPrivileged(new PrivilegedAction<SAXParserFactory>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SAXParserFactory run() {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            ClassLoader ours = PageParser.class.getClassLoader();
            try {
                if (original != ours) {
                    Thread.currentThread().setContextClassLoader(ours);
                }
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                return sAXParserFactory;
            }
            finally {
                if (original != ours) {
                    Thread.currentThread().setContextClassLoader(original);
                }
            }
        }
    });

    PageParser(boolean namespaceAware) {
        try {
            this.parserFactory.setNamespaceAware(namespaceAware);
            this.parserFactory.setValidating(false);
            this.parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXNotRecognizedException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(PageData pageData, DefaultHandler handler) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = this.parserFactory.newSAXParser();
        InputStream is = pageData.getInputStream();
        try {
            parser.parse(is, handler);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

