/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.Encryptor;

public class EncryptorImpl
implements Encryptor {
    private static final String ALGORITHM = "AES";
    private static final String FULL_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final byte[] DEFAULT_KEY_BYTES = new byte[]{35, 101, -121, 34, 89, 120, 84, 67, 100, 5, 106, -67, 52, -94, 52, 87};
    private static final byte[] DEFAULT_IV_BYTES = new byte[]{81, 101, 34, 35, 100, 5, 106, -66, 81, 101, 34, 35, 100, 5, 106, -66};
    private static final int FALLBACK_KEY_SIZE = 128;
    private static final Log LOG = Log.getLog(EncryptorImpl.class);
    private Key key;
    private IvParameterSpec iv;
    private boolean defaultKey;

    public EncryptorImpl(boolean defaultKey) {
        this.defaultKey = defaultKey;
        if (defaultKey) {
            this.key = new SecretKeySpec(DEFAULT_KEY_BYTES, ALGORITHM);
            this.iv = new IvParameterSpec(DEFAULT_IV_BYTES);
        } else {
            try {
                this.key = KeyGenerator.getInstance(ALGORITHM).generateKey();
                this.iv = new IvParameterSpec(DEFAULT_IV_BYTES);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            try {
                Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
                cipher.init(1, this.key, this.iv);
                cipher.doFinal("A".getBytes(StandardCharsets.UTF_8));
            }
            catch (InvalidKeyException e) {
                KeyGenerator keyGenerator;
                LOG.warn("Error in self-test with default generated key (algorithm={0}, keySize(encoded)={1}), will fall back to default key size. Original error: {2}", new Object[]{ALGORITHM, this.key.getEncoded().length * 8, e.getMessage()});
                try {
                    keyGenerator = KeyGenerator.getInstance(ALGORITHM);
                }
                catch (NoSuchAlgorithmException e1) {
                    throw new RuntimeException(e1.getMessage() + " (algorithm=AES)", e1);
                }
                keyGenerator.init(128);
                this.key = keyGenerator.generateKey();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            LOG.ok("Using cipher algorithm={0}, keySize(encoded)={1}, defaultKey={2}", new Object[]{FULL_ALGORITHM, this.key.getEncoded().length * 8, defaultKey});
        }
    }

    public byte[] decrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(2, this.key, this.iv);
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage() + " (algorithm=AES/CBC/PKCS5Padding, keySize(encoded)=" + this.key.getEncoded().length * 8 + ", defaultKey=" + this.defaultKey + ")", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encrypt(byte[] bytes) {
        try {
            Cipher cipher = Cipher.getInstance(FULL_ALGORITHM);
            cipher.init(1, this.key, this.iv);
            return cipher.doFinal(bytes);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e.getMessage() + " (algorithm=AES/CBC/PKCS5Padding, keySize(encoded)=" + this.key.getEncoded().length * 8 + ", defaultKey=" + this.defaultKey + ")", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

