/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\u0007\u000f\u0001MA\u0001\u0002\n\u0001\u0003\u0006\u0004%I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005M!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u0005/\u0001\t\u0015\r\u0011\"\u00010\u0011!q\u0004A!A!\u0002\u0013\u0001\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b%\u0003A\u0011\u0001&\t\u000bA\u0003A\u0011B)\t\r%\u0004A\u0011\u0001\bk\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0002\u0013)>\u0004\u0018nY\"p]\u001aLw\rS1oI2,'O\u0003\u0002\u0010!\u000511/\u001a:wKJT\u0011!E\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001AC\u0007\u0010\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\r\u0005s\u0017PU3g!\tYB$D\u0001\u000f\u0013\tibBA\u0007D_:4\u0017n\u001a%b]\u0012dWM\u001d\t\u0003?\tj\u0011\u0001\t\u0006\u0003CA\tQ!\u001e;jYNL!a\t\u0011\u0003\u000f1{wmZ5oO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#\u0001\u0014\u0011\u0005m9\u0013B\u0001\u0015\u000f\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\fW\u000647.Y\"p]\u001aLw\r\u0005\u0002\u001cY%\u0011QF\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0004rk>$\u0018m]\u000b\u0002aA\u0011\u0011g\u000f\b\u0003eer!a\r\u001d\u000f\u0005Q:T\"A\u001b\u000b\u0005Y\u0012\u0012A\u0002\u001fs_>$h(C\u0001\u0012\u0013\ty\u0001#\u0003\u0002;\u001d\u0005a\u0011+^8uC\u001a\u000b7\r^8ss&\u0011A(\u0010\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0005ir\u0011aB9v_R\f7\u000fI\u0001\u0010W\u000647.Y\"p]R\u0014x\u000e\u001c7feB\u0019Q#Q\"\n\u0005\t3\"AB(qi&|g\u000e\u0005\u0002E\u000f6\tQI\u0003\u0002G!\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005!+%aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\rqJg.\u001b;?)\u0015YE*\u0014(P!\tY\u0002\u0001C\u0003%\u000f\u0001\u0007a\u0005C\u0003+\u000f\u0001\u00071\u0006C\u0003/\u000f\u0001\u0007\u0001\u0007C\u0003@\u000f\u0001\u0007\u0001)A\bva\u0012\fG/\u001a'pO\u000e{gNZ5h)\r\u0011Vk\u0018\t\u0003+MK!\u0001\u0016\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006-\"\u0001\raV\u0001\u0006i>\u0004\u0018n\u0019\t\u00031rs!!\u0017.\u0011\u0005Q2\u0012BA.\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m3\u0002\"\u00021\t\u0001\u0004\t\u0017a\u0003;pa&\u001c7i\u001c8gS\u001e\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011%\\1zE\u0016\u0014un\u001c;tiJ\f\u0007OU3n_R,Gj\\4D_6\u0004xN\\3oiN$BAU6mu\")a+\u0003a\u0001/\")Q.\u0003a\u0001]\u0006!An\\4t!\ry'\u000f^\u0007\u0002a*\u0011\u0011OF\u0001\u000bG>dG.Z2uS>t\u0017BA:q\u0005\r\u0019V-\u001d\t\u0003kbl\u0011A\u001e\u0006\u0003oB\t1\u0001\\8h\u0013\tIhO\u0001\u0006V]&4\u0017.\u001a3M_\u001eDQa_\u0005A\u0002q\fqd^1t%\u0016lw\u000e^3M_\u001e,e.\u00192mK\u0012\u0014UMZ8sKV\u0003H-\u0019;f!\t)R0\u0003\u0002\u007f-\t9!i\\8mK\u0006t\u0017\u0001\u00069s_\u000e,7o]\"p]\u001aLwm\u00115b]\u001e,7\u000fF\u0003S\u0003\u0007\t)\u0001C\u0003W\u0015\u0001\u0007q\u000bC\u0003a\u0015\u0001\u0007\u0011-\u0001\rqCJ\u001cX\r\u00165s_R$H.\u001a3QCJ$\u0018\u000e^5p]N$\u0002\"a\u0003\u0002\u0014\u0005U\u0011\u0011\u0004\t\u0005_J\fi\u0001E\u0002\u0016\u0003\u001fI1!!\u0005\u0017\u0005\rIe\u000e\u001e\u0005\u0006A.\u0001\r!\u0019\u0005\b\u0003/Y\u0001\u0019AA\u0007\u0003!\u0011'o\\6fe&#\u0007BBA\u000e\u0017\u0001\u0007q+\u0001\u0003qe>\u0004\u0018aD3yG2,H-\u001a3D_:4\u0017nZ:\u0015\r\u0005\u0005\u0012qEA\u0015!\u0011A\u00161E,\n\u0007\u0005\u0015bLA\u0002TKRDQA\u0016\u0007A\u0002]CQ\u0001\u0019\u0007A\u0002\u0005\u0004")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager replicaManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig) {
        LogManager logManager = this.replicaManager().logManager();
        scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Properties props = new Properties();
        CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfig).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
            if (!configNamesToExclude.contains(key)) {
                return props.put(key, value);
            }
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        Seq<UnifiedLog> logs = logManager.logsByTopic(topic);
        boolean wasRemoteLogEnabledBeforeUpdate = logs.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.remoteLogEnabled()));
        RemoteLogManagerConfig remoteLogManagerConfig = this.kafkaConfig.remoteLogManagerConfig();
        if (remoteLogManagerConfig == null) {
            throw null;
        }
        logManager.updateTopicConfig(topic, props, remoteLogManagerConfig.getBoolean("remote.log.storage.system.enable"));
        this.maybeBootstrapRemoteLogComponents(topic, logs, wasRemoteLogEnabledBeforeUpdate);
    }

    /*
     * WARNING - void declaration
     */
    public void maybeBootstrapRemoteLogComponents(String topic, Seq<UnifiedLog> logs, boolean wasRemoteLogEnabledBeforeUpdate) {
        boolean isRemoteLogEnabled = logs.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.remoteLogEnabled()));
        if (!wasRemoteLogEnabledBeforeUpdate && isRemoteLogEnabled) {
            void var7_7;
            void var6_6;
            Tuple2 tuple2 = ((IterableOps)logs.flatMap((Function1 & Serializable)log -> this.replicaManager().onlinePartition(log.topicPartition()))).partition((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isLeader()));
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Seq leaderPartitions = (Seq)tuple2._1();
            Seq followerPartitions = (Seq)tuple2._2();
            Map<String, Uuid> topicIds = Collections.singletonMap(topic, this.replicaManager().metadataCache().getTopicId(topic));
            this.replicaManager().remoteLogManager().foreach(arg_0 -> TopicConfigHandler.$anonfun$maybeBootstrapRemoteLogComponents$4$adapted((Seq)var6_6, (Seq)var7_7, topicIds, arg_0));
            return;
        }
        if (wasRemoteLogEnabledBeforeUpdate && !isRemoteLogEnabled) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Disabling remote log on the topic: ").append(topic).append(" is not supported.").toString());
            return;
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        this.updateLogConfig(topic, topicConfig);
        this.updateThrottledList$1("leader.replication.throttled.replicas", this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1("follower.replication.throttled.replicas", this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig.getProperty(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable)x$5 -> {
                x$5.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator.ensureValidString((String)prop, (String)configValue);
        switch (configValue == null ? 0 : configValue.hashCode()) {
            case 0: {
                if (!"".equals(configValue)) break;
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(configValue)) break;
                return Constants$.MODULE$.AllReplicas();
            }
        }
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$6 -> x$6.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$7)))), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$8[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
    }

    private scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty("message.format.version")).flatMap((Function1 & Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion(versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)"message.format.version");
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().isLessThan(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(142).append("Topic configuration ").append("message.format.version").append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString());
                return new Some((Object)"message.format.version");
            }
            return None$.MODULE$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$2) {
        if (topicConfig$1.containsKey(prop) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(topicConfig$1.getProperty(prop)))) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$2, partitions);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$2).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$2);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$2).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$7) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$7[1])) == brokerId$1;
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.replicaManager = replicaManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
    }

    public static final /* synthetic */ Object $anonfun$maybeBootstrapRemoteLogComponents$4$adapted(Seq leaderPartitions$1, Seq followerPartitions$1, Map topicIds$1, RemoteLogManager rlm) {
        rlm.onLeadershipChange(CollectionConverters$.MODULE$.SetHasAsJava((Set)leaderPartitions$1.toSet()).asJava(), CollectionConverters$.MODULE$.SetHasAsJava((Set)followerPartitions$1.toSet()).asJava(), topicIds$1);
        return BoxedUnit.UNIT;
    }
}

