/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerTestBuilder;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.common.utils.annotation.ApiKeyVersionsSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HeartbeatRequestManagerTest {
    private static final String DEFAULT_GROUP_ID = "groupId";
    private static final String CONSUMER_COORDINATOR_METRICS = "consumer-coordinator-metrics";
    private ConsumerTestBuilder testBuilder;
    private Time time;
    private Timer pollTimer;
    private CoordinatorRequestManager coordinatorRequestManager;
    private SubscriptionState subscriptions;
    private Metadata metadata;
    private HeartbeatRequestManager heartbeatRequestManager;
    private MembershipManager membershipManager;
    private HeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState;
    private HeartbeatRequestManager.HeartbeatState heartbeatState;
    private final String memberId = "member-id";
    private final int memberEpoch = 1;
    private BackgroundEventHandler backgroundEventHandler;
    private Metrics metrics;

    @BeforeEach
    public void setUp() {
        this.setUp(ConsumerTestBuilder.createDefaultGroupInformation());
    }

    private void setUp(Optional<ConsumerTestBuilder.GroupInformation> groupInfo) {
        this.testBuilder = new ConsumerTestBuilder(groupInfo, true, false);
        this.time = this.testBuilder.time;
        this.coordinatorRequestManager = this.testBuilder.coordinatorRequestManager.orElseThrow(IllegalStateException::new);
        this.heartbeatRequestManager = this.testBuilder.heartbeatRequestManager.orElseThrow(IllegalStateException::new);
        this.heartbeatRequestState = this.testBuilder.heartbeatRequestState.orElseThrow(IllegalStateException::new);
        this.heartbeatState = this.testBuilder.heartbeatState.orElseThrow(IllegalStateException::new);
        this.backgroundEventHandler = this.testBuilder.backgroundEventHandler;
        this.subscriptions = this.testBuilder.subscriptions;
        this.membershipManager = this.testBuilder.membershipManager.orElseThrow(IllegalStateException::new);
        this.metadata = this.testBuilder.metadata;
        this.metrics = new Metrics(this.time);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
    }

    private void resetWithZeroHeartbeatInterval(Optional<String> groupInstanceId) {
        this.cleanup();
        ConsumerTestBuilder.GroupInformation gi = new ConsumerTestBuilder.GroupInformation(DEFAULT_GROUP_ID, groupInstanceId, 0, 0.0, Optional.of("uniform"));
        this.setUp(Optional.of(gi));
    }

    @AfterEach
    public void cleanup() {
        if (this.testBuilder != null) {
            this.testBuilder.close();
        }
    }

    @Test
    public void testHeartbeatOnStartup() {
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.PollResult result2 = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result2.unsentRequests.size());
    }

    @Test
    public void testSuccessfulHeartbeatTiming() {
        this.mockStableMember();
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while interval has not expired");
        Assertions.assertEquals((long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (long)result.timeUntilNextPollMs);
        this.assertNextHeartbeatTiming(1000L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A heartbeat should be sent when interval expires");
        NetworkClientDelegate.UnsentRequest inflightReq = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (String)"Heartbeat timer was not reset to the interval when the heartbeat request was sent.");
        long partOfInterval = 333L;
        this.time.sleep(partOfInterval);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while only part of the interval has passed");
        Assertions.assertEquals((long)(1000L - partOfInterval), (long)this.heartbeatRequestState.timeToNextHeartbeatMs(this.time.milliseconds()), (String)"Time to next interval was not properly updated.");
        inflightReq.handler().onComplete(this.createHeartbeatResponse(inflightReq, Errors.NONE));
        this.assertNextHeartbeatTiming(1000L - partOfInterval);
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testFirstHeartbeatIncludesRequiredInfoToJoinGroupAndGetAssignments(short version) {
        this.resetWithZeroHeartbeatInterval(Optional.of("group-instance-id"));
        String topic = "topic1";
        this.subscriptions.subscribe(Collections.singleton(topic), Optional.empty());
        this.membershipManager.onSubscriptionUpdated();
        Assertions.assertEquals((long)0L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertInstanceOf(ConsumerGroupHeartbeatRequest.Builder.class, (Object)request.requestBuilder());
        ConsumerGroupHeartbeatRequest heartbeatRequest = (ConsumerGroupHeartbeatRequest)request.requestBuilder().build(version);
        Assertions.assertTrue((boolean)heartbeatRequest.data().memberId().isEmpty());
        Assertions.assertEquals((int)0, (int)heartbeatRequest.data().memberEpoch());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)heartbeatRequest.data().subscribedTopicNames());
        Assertions.assertEquals((int)10000, (int)heartbeatRequest.data().rebalanceTimeoutMs());
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)heartbeatRequest.data().groupId());
        Assertions.assertEquals((Object)"group-instance-id", (Object)heartbeatRequest.data().instanceId());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testSkippingHeartbeat(boolean shouldSkipHeartbeat) {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)shouldSkipHeartbeat);
        Mockito.when((Object)this.heartbeatRequestState.canSendRequest(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        if (!shouldSkipHeartbeat) {
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)0L, (long)result.timeUntilNextPollMs);
        } else {
            Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        }
    }

    @Test
    public void testTimerNotDue() {
        this.mockStableMember();
        this.time.sleep(100L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)900L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)900L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        this.membershipManager.transitionToFatal();
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
    }

    @Test
    public void testHeartbeatNotSentIfAnotherOneInFlight() {
        this.mockStableMember();
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest inflightReq = (NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while a previous one is in-flight");
        this.time.sleep(1000L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent when the interval expires if there is a previous HB request in-flight");
        inflightReq.handler().onComplete(this.createHeartbeatResponse(inflightReq, Errors.NONE));
        this.time.sleep(80L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A next heartbeat should be sent on the first poll after receiving a response that took longer than the interval, waiting only for the minimal backoff.");
    }

    @Test
    public void testHeartbeatOutsideInterval() {
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.shouldHeartbeatNow()).thenReturn((Object)true);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Assertions.assertEquals((long)1000L, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatRequestSent();
    }

    @Test
    public void testNetworkTimeout() {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)new TimeoutException("timeout"));
        this.time.sleep(79L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
        this.time.sleep(1L);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
    }

    @Test
    public void testFailureOnFatalException() {
        this.resetWithZeroHeartbeatInterval(Optional.empty());
        this.mockStableMember();
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onFailure(this.time.milliseconds(), (RuntimeException)((Object)new KafkaException("fatal")));
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)ArgumentMatchers.any());
    }

    @Test
    public void testNoCoordinator() {
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.empty());
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)result.timeUntilNextPollMs);
        Assertions.assertEquals((long)1000L, (long)this.heartbeatRequestManager.maximumTimeToWait(this.time.milliseconds()));
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testValidateConsumerGroupHeartbeatRequest(short version) {
        this.resetWithZeroHeartbeatInterval(Optional.of("group-instance-id"));
        this.mockStableMember();
        List<String> subscribedTopics = Collections.singletonList("topic");
        this.subscriptions.subscribe(new HashSet<String>(subscribedTopics), Optional.empty());
        ConsumerGroupHeartbeatResponse result = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setMemberId("member-id").setMemberEpoch(1));
        this.membershipManager.onHeartbeatSuccess(result.data());
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertInstanceOf(ConsumerGroupHeartbeatRequest.Builder.class, (Object)request.requestBuilder());
        ConsumerGroupHeartbeatRequest heartbeatRequest = (ConsumerGroupHeartbeatRequest)request.requestBuilder().build(version);
        Assertions.assertEquals((Object)DEFAULT_GROUP_ID, (Object)heartbeatRequest.data().groupId());
        Assertions.assertEquals((Object)"member-id", (Object)heartbeatRequest.data().memberId());
        Assertions.assertEquals((int)1, (int)heartbeatRequest.data().memberEpoch());
        Assertions.assertEquals((int)10000, (int)heartbeatRequest.data().rebalanceTimeoutMs());
        Assertions.assertEquals(subscribedTopics, (Object)heartbeatRequest.data().subscribedTopicNames());
        Assertions.assertEquals((Object)"group-instance-id", (Object)heartbeatRequest.data().instanceId());
        Assertions.assertEquals((Object)"uniform", (Object)heartbeatRequest.data().serverAssignor());
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testValidateConsumerGroupHeartbeatRequestAssignmentSentWhenLocalEpochChanges(short version) {
        CoordinatorRequestManager coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        MembershipManager membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        BackgroundEventHandler backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        SubscriptionState subscriptionState = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        HeartbeatRequestManager.HeartbeatRequestState requestState = (HeartbeatRequestManager.HeartbeatRequestState)Mockito.mock(HeartbeatRequestManager.HeartbeatRequestState.class);
        HeartbeatRequestManager.HeartbeatState heartbeatState = new HeartbeatRequestManager.HeartbeatState(subscriptionState, membershipManager, 10000);
        HeartbeatRequestManager heartbeatRequestManager = this.createHeartbeatRequestManager(coordinatorRequestManager, membershipManager, heartbeatState, requestState, backgroundEventHandler);
        Mockito.when((Object)membershipManager.shouldHeartbeatNow()).thenReturn((Object)true);
        Mockito.when((Object)coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        Uuid topicId = Uuid.randomUuid();
        ConsumerGroupHeartbeatRequestData.TopicPartitions expectedTopicPartitions = new ConsumerGroupHeartbeatRequestData.TopicPartitions();
        Map<Uuid, SortedSet> testAssignment = Collections.singletonMap(topicId, Utils.mkSortedSet((Comparable[])new Integer[]{0}));
        expectedTopicPartitions.setTopicId(topicId);
        expectedTopicPartitions.setPartitions(Collections.singletonList(0));
        Mockito.when((Object)membershipManager.currentAssignment()).thenReturn((Object)new MembershipManager.LocalAssignment(0L, testAssignment));
        ConsumerGroupHeartbeatRequest heartbeatRequest1 = this.getHeartbeatRequest(heartbeatRequestManager, version);
        Assertions.assertEquals(Collections.singletonList(expectedTopicPartitions), (Object)heartbeatRequest1.data().topicPartitions());
        ConsumerGroupHeartbeatRequest heartbeatRequest2 = this.getHeartbeatRequest(heartbeatRequestManager, version);
        Assertions.assertNull((Object)heartbeatRequest2.data().topicPartitions());
        Mockito.when((Object)membershipManager.currentAssignment()).thenReturn((Object)new MembershipManager.LocalAssignment(1L, testAssignment));
        ConsumerGroupHeartbeatRequest heartbeatRequest3 = this.getHeartbeatRequest(heartbeatRequestManager, version);
        Assertions.assertEquals(Collections.singletonList(expectedTopicPartitions), (Object)heartbeatRequest3.data().topicPartitions());
    }

    private ConsumerGroupHeartbeatRequest getHeartbeatRequest(HeartbeatRequestManager heartbeatRequestManager, short version) {
        NetworkClientDelegate.PollResult pollResult = heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        NetworkClientDelegate.UnsentRequest request = (NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0);
        Assertions.assertInstanceOf(ConsumerGroupHeartbeatRequest.Builder.class, (Object)request.requestBuilder());
        return (ConsumerGroupHeartbeatRequest)request.requestBuilder().build(version);
    }

    @ParameterizedTest
    @MethodSource(value={"errorProvider"})
    public void testHeartbeatResponseOnErrorHandling(Errors error, boolean isFatal) {
        this.mockStableMember();
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ClientResponse response = this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0), error);
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onComplete(response);
        ConsumerGroupHeartbeatResponse mockResponse = (ConsumerGroupHeartbeatResponse)response.responseBody();
        switch (error) {
            case NONE: {
                ((MembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatSuccess(mockResponse.data());
                this.assertNextHeartbeatTiming(1000L);
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(80L);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                ((CoordinatorRequestManager)Mockito.verify((Object)this.coordinatorRequestManager)).markCoordinatorUnknown((String)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
                this.assertNextHeartbeatTiming(0L);
                break;
            }
            case UNKNOWN_MEMBER_ID: 
            case FENCED_MEMBER_EPOCH: {
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(0L);
                break;
            }
            default: {
                if (isFatal) {
                    this.ensureFatalError(error);
                    break;
                }
                ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler, (VerificationMode)Mockito.never())).add((BackgroundEvent)ArgumentMatchers.any());
                this.assertNextHeartbeatTiming(0L);
            }
        }
        if (!isFatal) {
            this.time.sleep(1000L);
            result = this.heartbeatRequestManager.poll(this.time.milliseconds());
            Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        }
    }

    private void assertNextHeartbeatTiming(long expectedTimeToNextHeartbeatMs) {
        long currentTimeMs = this.time.milliseconds();
        Assertions.assertEquals((long)expectedTimeToNextHeartbeatMs, (long)this.heartbeatRequestState.timeToNextHeartbeatMs(currentTimeMs));
        if (expectedTimeToNextHeartbeatMs != 0L) {
            Assertions.assertFalse((boolean)this.heartbeatRequestState.canSendRequest(currentTimeMs));
            this.time.sleep(expectedTimeToNextHeartbeatMs);
        }
        Assertions.assertTrue((boolean)this.heartbeatRequestState.canSendRequest(this.time.milliseconds()));
    }

    @Test
    public void testHeartbeatState() {
        ConsumerGroupHeartbeatRequestData data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)10000, (int)data.rebalanceTimeoutMs());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.subscribedTopicNames());
        Assertions.assertEquals((Object)"uniform", (Object)data.serverAssignor());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.UNSUBSCRIBED, (Object)this.membershipManager.state());
        this.mockStableMember();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"member-id", (Object)data.memberId());
        Assertions.assertEquals((int)1, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)-1, (int)data.rebalanceTimeoutMs());
        Assertions.assertNull((Object)data.subscribedTopicNames());
        Assertions.assertNull((Object)data.serverAssignor());
        Assertions.assertEquals((Object)data.topicPartitions(), Collections.emptyList());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)this.membershipManager.state());
        String topic = "topic1";
        this.subscriptions.subscribe(Collections.singleton(topic), Optional.empty());
        this.membershipManager.onSubscriptionUpdated();
        this.membershipManager.transitionToFenced();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"member-id", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)10000, (int)data.rebalanceTimeoutMs());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)data.subscribedTopicNames());
        Assertions.assertEquals((Object)"uniform", (Object)data.serverAssignor());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)this.membershipManager.state());
        this.membershipManager.transitionToFenced();
        data = this.heartbeatState.buildRequestData();
        Assertions.assertEquals((Object)"group-id", (Object)data.groupId());
        Assertions.assertEquals((Object)"member-id", (Object)data.memberId());
        Assertions.assertEquals((int)0, (int)data.memberEpoch());
        Assertions.assertNull((Object)data.instanceId());
        Assertions.assertEquals((int)10000, (int)data.rebalanceTimeoutMs());
        Assertions.assertEquals(Collections.singletonList(topic), (Object)data.subscribedTopicNames());
        Assertions.assertEquals((Object)"uniform", (Object)data.serverAssignor());
        Assertions.assertEquals(Collections.emptyList(), (Object)data.topicPartitions());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.JOINING, (Object)this.membershipManager.state());
        ConsumerGroupHeartbeatResponseData.TopicPartitions tpTopic1 = new ConsumerGroupHeartbeatResponseData.TopicPartitions();
        Uuid topicId = Uuid.randomUuid();
        tpTopic1.setTopicId(topicId);
        tpTopic1.setPartitions(Collections.singletonList(0));
        ConsumerGroupHeartbeatResponseData.Assignment assignmentTopic1 = new ConsumerGroupHeartbeatResponseData.Assignment();
        assignmentTopic1.setTopicPartitions(Collections.singletonList(tpTopic1));
        ConsumerGroupHeartbeatResponse rs1 = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setHeartbeatIntervalMs(1000).setMemberId("member-id").setMemberEpoch(1).setAssignment(assignmentTopic1));
        Mockito.when((Object)this.metadata.topicNames()).thenReturn(Collections.singletonMap(topicId, "topic1"));
        this.membershipManager.onHeartbeatSuccess(rs1.data());
        Assertions.assertEquals((Object)MemberState.RECONCILING, (Object)this.membershipManager.state());
    }

    @Test
    public void testPollTimerExpiration() {
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        this.heartbeatState = (HeartbeatRequestManager.HeartbeatState)Mockito.mock(HeartbeatRequestManager.HeartbeatState.class);
        this.heartbeatRequestState = (HeartbeatRequestManager.HeartbeatRequestState)Mockito.spy((Object)new HeartbeatRequestManager.HeartbeatRequestState(new LogContext(), this.time, 1000L, 80L, 1000L, 0.0));
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        this.time.sleep(10000L);
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToSendingLeaveGroup(true);
        ((HeartbeatRequestManager.HeartbeatState)Mockito.verify((Object)this.heartbeatState)).reset();
        ((HeartbeatRequestManager.HeartbeatRequestState)Mockito.verify((Object)this.heartbeatRequestState)).reset();
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).onHeartbeatRequestSent();
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.STALE);
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)true);
        this.assertNoHeartbeat(this.heartbeatRequestManager);
        this.heartbeatRequestManager.resetPollTimer(this.time.milliseconds());
        Assertions.assertTrue((boolean)this.pollTimer.notExpired());
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).maybeRejoinStaleMember();
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
    }

    @Test
    public void testPollTimerExpirationShouldNotMarkMemberStaleIfMemberAlreadyLeaving() {
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        Mockito.when((Object)this.membershipManager.isLeavingGroup()).thenReturn((Object)true);
        this.time.sleep(10000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        ((MembershipManager)Mockito.verify((Object)this.membershipManager, (VerificationMode)Mockito.never())).transitionToSendingLeaveGroup(ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"A heartbeat request should be generated to complete the ongoing leaving operation that was triggered before the poll timer expired.");
    }

    @Test
    public void testisExpiredByUsedForLogging() {
        Timer pollTimer = (Timer)Mockito.spy((Object)this.time.timer(10000L));
        this.heartbeatRequestManager = new HeartbeatRequestManager(new LogContext(), pollTimer, this.config(), this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler, this.metrics);
        Mockito.when((Object)this.membershipManager.shouldSkipHeartbeat()).thenReturn((Object)false);
        int exceededTimeMs = 5;
        this.time.sleep((long)(10000 + exceededTimeMs));
        NetworkClientDelegate.PollResult pollResult = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToSendingLeaveGroup(true);
        ((Timer)Mockito.verify((Object)pollTimer, (VerificationMode)Mockito.never())).isExpiredBy();
        Assertions.assertEquals((long)exceededTimeMs, (long)pollTimer.isExpiredBy());
        Mockito.clearInvocations((Object[])new Timer[]{pollTimer});
        this.heartbeatRequestManager.resetPollTimer(this.time.milliseconds());
        ((Timer)Mockito.verify((Object)pollTimer)).isExpiredBy();
    }

    @Test
    public void testHeartbeatMetrics() {
        this.coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        this.heartbeatState = (HeartbeatRequestManager.HeartbeatState)Mockito.mock(HeartbeatRequestManager.HeartbeatState.class);
        this.time = new MockTime();
        this.metrics = new Metrics(this.time);
        this.heartbeatRequestState = new HeartbeatRequestManager.HeartbeatRequestState(new LogContext(), this.time, 0L, 80L, 1000L, 0.0);
        this.backgroundEventHandler = (BackgroundEventHandler)Mockito.mock(BackgroundEventHandler.class);
        this.heartbeatRequestManager = this.createHeartbeatRequestManager(this.coordinatorRequestManager, this.membershipManager, this.heartbeatState, this.heartbeatRequestState, this.backgroundEventHandler);
        Mockito.when((Object)this.coordinatorRequestManager.coordinator()).thenReturn(Optional.of(new Node(1, "localhost", 9999)));
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.STABLE);
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-response-time-max"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-rate"));
        Assertions.assertNotNull((Object)this.getMetric("heartbeat-total"));
        Assertions.assertNotNull((Object)this.getMetric("last-heartbeat-seconds-ago"));
        this.assertHeartbeat(this.heartbeatRequestManager, 0);
        this.time.sleep(1000L);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Assertions.assertEquals((Object)TimeUnit.MILLISECONDS.toSeconds(1000L), (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
        this.assertHeartbeat(this.heartbeatRequestManager, 1000);
        Assertions.assertEquals((double)0.06, (double)((Double)this.getMetric("heartbeat-rate").metricValue()), (double)0.005);
        Assertions.assertEquals((Object)2.0, (Object)this.getMetric("heartbeat-total").metricValue());
        Random rand = new Random();
        int randomSleepS = rand.nextInt(11);
        this.time.sleep((long)(randomSleepS * 1000));
        Assertions.assertEquals((Object)randomSleepS, (Object)this.getMetric("last-heartbeat-seconds-ago").metricValue());
    }

    @Test
    public void testFencedMemberStopHeartbeatUntilItReleasesAssignmentToRejoin() {
        this.mockStableMember();
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        ((MembershipManager)Mockito.doNothing().when((Object)this.membershipManager)).transitionToFenced();
        ClientResponse response = this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0), Errors.FENCED_MEMBER_EPOCH);
        ((NetworkClientDelegate.UnsentRequest)result.unsentRequests.get(0)).handler().onComplete(response);
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFenced();
        ((HeartbeatRequestManager.HeartbeatRequestState)Mockito.verify((Object)this.heartbeatRequestState)).onFailedAttempt(ArgumentMatchers.anyLong());
        ((HeartbeatRequestManager.HeartbeatRequestState)Mockito.verify((Object)this.heartbeatRequestState)).reset();
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.FENCED);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"Member should not send heartbeats while FENCED");
        Mockito.when((Object)this.membershipManager.state()).thenReturn((Object)MemberState.JOINING);
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size(), (String)"Fenced member should resume heartbeat after transitioning to JOINING");
    }

    @ParameterizedTest
    @ApiKeyVersionsSource(apiKey=ApiKeys.CONSUMER_GROUP_HEARTBEAT)
    public void testSendingLeaveGroupHeartbeatWhenPreviousOneInFlight(short version) {
        this.mockStableMember();
        this.time.sleep(1000L);
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)result.unsentRequests.size());
        result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size(), (String)"No heartbeat should be sent while a previous one is in-flight");
        this.membershipManager.leaveGroup();
        ConsumerGroupHeartbeatRequest heartbeatToLeave = this.getHeartbeatRequest(this.heartbeatRequestManager, version);
        Assertions.assertEquals((int)-1, (int)heartbeatToLeave.data().memberEpoch());
        NetworkClientDelegate.PollResult pollAgain = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)pollAgain.unsentRequests.size());
    }

    private void assertHeartbeat(HeartbeatRequestManager hrm, int nextPollMs) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)1, (int)pollResult.unsentRequests.size());
        Assertions.assertEquals((long)nextPollMs, (long)pollResult.timeUntilNextPollMs);
        ((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0)).handler().onComplete(this.createHeartbeatResponse((NetworkClientDelegate.UnsentRequest)pollResult.unsentRequests.get(0), Errors.NONE));
    }

    private void assertNoHeartbeat(HeartbeatRequestManager hrm) {
        NetworkClientDelegate.PollResult pollResult = hrm.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)pollResult.unsentRequests.size());
    }

    private void mockStableMember() {
        this.membershipManager.onSubscriptionUpdated();
        Mockito.when((Object)this.subscriptions.hasAutoAssignedPartitions()).thenReturn((Object)true);
        Mockito.when((Object)this.subscriptions.rebalanceListener()).thenReturn(Optional.empty());
        ConsumerGroupHeartbeatResponse rs1 = new ConsumerGroupHeartbeatResponse(new ConsumerGroupHeartbeatResponseData().setHeartbeatIntervalMs(1000).setMemberId("member-id").setMemberEpoch(1).setAssignment(new ConsumerGroupHeartbeatResponseData.Assignment()));
        this.membershipManager.onHeartbeatSuccess(rs1.data());
        this.membershipManager.poll(this.time.milliseconds());
        this.membershipManager.onHeartbeatRequestSent();
        Assertions.assertEquals((Object)MemberState.STABLE, (Object)this.membershipManager.state());
    }

    private void ensureFatalError(Errors expectedError) {
        ((MembershipManager)Mockito.verify((Object)this.membershipManager)).transitionToFatal();
        ArgumentCaptor errorEventArgumentCaptor = ArgumentCaptor.forClass(ErrorEvent.class);
        ((BackgroundEventHandler)Mockito.verify((Object)this.backgroundEventHandler)).add((BackgroundEvent)errorEventArgumentCaptor.capture());
        ErrorEvent errorEvent = (ErrorEvent)errorEventArgumentCaptor.getValue();
        Assertions.assertInstanceOf(expectedError.exception().getClass(), (Object)errorEvent.error(), (String)"The fatal error propagated to the app thread does not match the error received in the heartbeat response.");
        this.ensureHeartbeatStopped();
    }

    private void ensureHeartbeatStopped() {
        this.time.sleep(1000L);
        Assertions.assertEquals((Object)MemberState.FATAL, (Object)this.membershipManager.state());
        NetworkClientDelegate.PollResult result = this.heartbeatRequestManager.poll(this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)result.unsentRequests.size());
    }

    private static Collection<Arguments> errorProvider() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{Errors.NONE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_NOT_AVAILABLE, false}), Arguments.of((Object[])new Object[]{Errors.COORDINATOR_LOAD_IN_PROGRESS, false}), Arguments.of((Object[])new Object[]{Errors.NOT_COORDINATOR, false}), Arguments.of((Object[])new Object[]{Errors.GROUP_AUTHORIZATION_FAILED, true}), Arguments.of((Object[])new Object[]{Errors.INVALID_REQUEST, true}), Arguments.of((Object[])new Object[]{Errors.UNKNOWN_MEMBER_ID, false}), Arguments.of((Object[])new Object[]{Errors.FENCED_MEMBER_EPOCH, false}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_ASSIGNOR, true}), Arguments.of((Object[])new Object[]{Errors.UNSUPPORTED_VERSION, true}), Arguments.of((Object[])new Object[]{Errors.UNRELEASED_INSTANCE_ID, true}), Arguments.of((Object[])new Object[]{Errors.FENCED_INSTANCE_ID, true}), Arguments.of((Object[])new Object[]{Errors.GROUP_MAX_SIZE_REACHED, true}));
    }

    private ClientResponse createHeartbeatResponse(NetworkClientDelegate.UnsentRequest request, Errors error) {
        ConsumerGroupHeartbeatResponseData data = new ConsumerGroupHeartbeatResponseData().setErrorCode(error.code()).setHeartbeatIntervalMs(1000).setMemberId("member-id").setMemberEpoch(1);
        if (error != Errors.NONE) {
            data.setErrorMessage("stubbed error message");
        }
        ConsumerGroupHeartbeatResponse response = new ConsumerGroupHeartbeatResponse(data);
        return new ClientResponse(new RequestHeader(ApiKeys.CONSUMER_GROUP_HEARTBEAT, ApiKeys.CONSUMER_GROUP_HEARTBEAT.latestVersion(), "client-id", 1), (RequestCompletionHandler)request.handler(), "0", this.time.milliseconds(), this.time.milliseconds(), false, null, null, (AbstractResponse)response);
    }

    private ConsumerConfig config() {
        Properties prop = new Properties();
        prop.put("key.deserializer", StringDeserializer.class);
        prop.put("value.deserializer", StringDeserializer.class);
        prop.setProperty("bootstrap.servers", "localhost:9999");
        prop.setProperty("max.poll.interval.ms", String.valueOf(10000));
        prop.setProperty("retry.backoff.ms", String.valueOf(80L));
        prop.setProperty("retry.backoff.max.ms", String.valueOf(1000L));
        prop.setProperty("heartbeat.interval.ms", String.valueOf(1000));
        return new ConsumerConfig(prop);
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, CONSUMER_COORDINATOR_METRICS));
    }

    private HeartbeatRequestManager createHeartbeatRequestManager(CoordinatorRequestManager coordinatorRequestManager, MembershipManager membershipManager, HeartbeatRequestManager.HeartbeatState heartbeatState, HeartbeatRequestManager.HeartbeatRequestState heartbeatRequestState, BackgroundEventHandler backgroundEventHandler) {
        LogContext logContext = new LogContext();
        this.pollTimer = this.time.timer(10000L);
        return new HeartbeatRequestManager(logContext, this.pollTimer, this.config(), coordinatorRequestManager, membershipManager, heartbeatState, heartbeatRequestState, backgroundEventHandler, this.metrics);
    }
}

