/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service.wa;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Optional;
import org.apache.syncope.common.rest.api.service.wa.WASAML2SPService;
import org.apache.syncope.core.logic.AuthModuleLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;

public class WASAML2SPServiceImpl
extends AbstractService
implements WASAML2SPService {
    protected final AuthModuleLogic logic;

    public WASAML2SPServiceImpl(AuthModuleLogic logic) {
        this.logic = logic;
    }

    public Response getSAML2SPKeystore(String clientName) {
        return Optional.ofNullable(this.logic.readSAML2SPConf(clientName).getKeystore()).map(Response::ok).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    public void setSAML2SPKeystore(String clientName, InputStream keystore) {
        this.logic.setSAML2SPKeystore(clientName, keystore);
    }

    public Response getSAML2SPMetadata(String clientName) {
        return Optional.ofNullable(this.logic.readSAML2SPConf(clientName).getServiceProviderMetadata()).map(Response::ok).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    public void setSAML2SPMetadata(String clientName, InputStream metadata) {
        this.logic.setSAML2SPMetadata(clientName, metadata);
    }
}

