/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.component;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ColGroup;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.egrid.component.EditableDataGridView;
import org.wicketstuff.egrid.provider.IEditableDataProvider;
import org.wicketstuff.egrid.toolbar.AbstractEditableToolbar;

public class EditableDataTable<T, S>
extends Panel
implements IPageableItems {
    public static final MetaDataKey<Boolean> EDITING = new MetaDataKey<Boolean>(){};
    public static final MetaDataKey<String> TABLE_MARKUP_ID = new MetaDataKey<String>(){};
    private static final long serialVersionUID = 1L;
    private final EditableDataGridView<T, S> dataGrid;
    private final WebMarkupContainer body;
    private final List<? extends IColumn<T, S>> columns;
    private final ToolbarsContainer topToolbars;
    private final ToolbarsContainer bottomToolbars;
    private final Caption caption;
    private final ColGroup colGroup;
    private long toolbarIdCounter;
    private int currentlyEditingRowsCount = 0;

    public EditableDataTable(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage) {
        super(id);
        Args.notNull(columns, (String)"columns");
        this.columns = columns;
        this.caption = new Caption("caption", this.getCaptionModel());
        this.add(new Component[]{this.caption});
        this.colGroup = new ColGroup("colGroup");
        this.add(new Component[]{this.colGroup});
        this.body = this.newBodyContainer("body");
        this.dataGrid = this.newDataGridView("rows", columns, dataProvider);
        this.dataGrid.setItemsPerPage(rowsPerPage);
        this.body.add(new Component[]{this.dataGrid});
        this.add(new Component[]{this.body});
        this.topToolbars = new ToolbarsContainer("topToolbars");
        this.bottomToolbars = new ToolbarsContainer("bottomToolbars");
        this.add(new Component[]{this.topToolbars});
        this.add(new Component[]{this.bottomToolbars});
        this.setOutputMarkupId(true);
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.findParent(Form.class) == null) {
            throw new IllegalStateException("form cannot be found in the hierarchy of the editable data table %s".formatted(this.toString(false)));
        }
    }

    protected EditableDataGridView<T, S> newDataGridView(String id, List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider) {
        return new DefaultEditableDataGridView(id, columns, dataProvider);
    }

    protected IModel<String> getCaptionModel() {
        return null;
    }

    public final ColGroup getColGroup() {
        return this.colGroup;
    }

    protected WebMarkupContainer newBodyContainer(String id) {
        return new WebMarkupContainer(id);
    }

    public final void setTableBodyCss(String cssStyle) {
        this.body.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)cssStyle))});
    }

    public void addBottomToolbar(AbstractEditableToolbar toolbar) {
        this.addToolbar(toolbar, this.bottomToolbars);
    }

    public void addTopToolbar(AbstractEditableToolbar toolbar) {
        this.addToolbar(toolbar, this.topToolbars);
    }

    public final ToolbarsContainer getTopToolbars() {
        return this.topToolbars;
    }

    public final ToolbarsContainer getBottomToolbars() {
        return this.bottomToolbars;
    }

    public final WebMarkupContainer getBody() {
        return this.body;
    }

    public final Caption getCaption() {
        return this.caption;
    }

    public final IEditableDataProvider<T, S> getDataProvider() {
        return this.dataGrid.getDataProvider();
    }

    public final List<? extends IColumn<T, S>> getColumns() {
        return this.columns;
    }

    public final long getCurrentPage() {
        return this.dataGrid.getCurrentPage();
    }

    public final void setCurrentPage(long page) {
        this.dataGrid.setCurrentPage(page);
        this.onPageChanged();
    }

    public final long getPageCount() {
        return this.dataGrid.getPageCount();
    }

    public final long getRowCount() {
        return this.dataGrid.getRowCount();
    }

    public final long getItemsPerPage() {
        return this.dataGrid.getItemsPerPage();
    }

    public void setItemsPerPage(long items) {
        this.dataGrid.setItemsPerPage(items);
    }

    public final EditableDataTable<T, S> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.dataGrid.setItemReuseStrategy(strategy);
        return this;
    }

    public long getItemCount() {
        return this.dataGrid.getItemCount();
    }

    private void addToolbar(AbstractEditableToolbar toolbar, ToolbarsContainer container) {
        Args.notNull((Object)((Object)toolbar), (String)"toolbar");
        container.getRepeatingView().add(new Component[]{toolbar});
    }

    protected Item<IColumn<T, S>> newCellItem(String id, int index, IModel<IColumn<T, S>> model) {
        return new Item(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new RowItem<T>(id, index, model, this.getMarkupId());
    }

    protected void onDetach() {
        super.onDetach();
        for (IColumn<T, S> column : this.columns) {
            column.detach();
        }
    }

    protected void onPageChanged() {
    }

    public String newToolbarId() {
        ++this.toolbarIdCounter;
        return String.valueOf(this.toolbarIdCounter).intern();
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "table");
        super.onComponentTag(tag);
    }

    public void onEvent(IEvent<?> event) {
        Object object = event.getPayload();
        if (!(object instanceof Item)) {
            return;
        }
        Item rowItem = (Item)object;
        if (!((String)((Object)rowItem.getMetaData(TABLE_MARKUP_ID))).equals(this.getMarkupId())) {
            return;
        }
        Boolean isEditing = (Boolean)rowItem.getMetaData(EDITING);
        if (isEditing != null) {
            this.currentlyEditingRowsCount += isEditing != false ? 1 : -1;
        }
        this.dataGrid.refresh((RowItem)rowItem);
        event.stop();
    }

    public boolean isCurrentlyAnyEdit() {
        return this.currentlyEditingRowsCount > 0;
    }

    public static class Caption
    extends Label {
        private static final long serialVersionUID = 1L;

        public Caption(String id, IModel<String> model) {
            super(id, model);
        }

        protected void onConfigure() {
            this.setRenderBodyOnly(Strings.isEmpty((String)this.getDefaultModelObjectAsString()));
            super.onConfigure();
        }

        protected IModel<String> initModel() {
            return null;
        }
    }

    public static final class ToolbarsContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final RepeatingView toolbars = new RepeatingView("toolbars");

        private ToolbarsContainer(String id) {
            super(id);
            this.setOutputMarkupId(true);
            this.add(new Component[]{this.toolbars});
        }

        public RepeatingView getRepeatingView() {
            return this.toolbars;
        }

        public void onConfigure() {
            super.onConfigure();
            this.toolbars.configure();
            Boolean visible = (Boolean)this.toolbars.visitChildren((object, visit) -> {
                object.configure();
                if (object.isVisible()) {
                    visit.stop((Object)true);
                } else {
                    visit.dontGoDeeper();
                }
            });
            if (visible == null) {
                visible = false;
            }
            this.setVisible(visible);
        }
    }

    private final class DefaultEditableDataGridView
    extends EditableDataGridView<T, S> {
        private DefaultEditableDataGridView(String id, List<? extends ICellPopulator<T>> populators, IEditableDataProvider<T, S> dataProvider) {
            super(id, populators, dataProvider);
        }

        protected Item<ICellPopulator<T>> newCellItem(String id, int index, IModel model) {
            Item item = EditableDataTable.this.newCellItem(id, index, model);
            final IColumn column = EditableDataTable.this.columns.get(index);
            if (column instanceof IStyledColumn) {
                item.add(new Behavior[]{new CssAttributeBehavior(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected String getCssClass() {
                        return ((IStyledColumn)column).getCssClass();
                    }
                }});
            }
            return item;
        }

        protected Item<T> newRowItem(String id, int index, IModel<T> model) {
            return EditableDataTable.this.newRowItem(id, index, model);
        }
    }

    public static class RowItem<RI>
    extends Item<RI> {
        private static final long serialVersionUID = 1L;

        public RowItem(String id, int index, IModel<RI> model, String tableMarkupId) {
            super(id, index, model);
            this.setOutputMarkupId(true);
            this.setMetaData(EDITING, Boolean.valueOf(false));
            this.setMetaData(TABLE_MARKUP_ID, (Serializable)((Object)tableMarkupId));
        }
    }

    public static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((String)className)) {
                tag.append("class", (CharSequence)className, " ");
            }
        }
    }
}

