/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import java.net.http.HttpClient;
import java.util.Optional;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.OpenFGAClientFactory;
import org.apache.syncope.ext.openfga.client.OpenFGAHealthIndicator;
import org.apache.syncope.ext.openfga.client.OpenFGAProperties;
import org.apache.syncope.ext.openfga.client.OpenFGAStoreManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={OpenFGAProperties.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="openfga", name={"api-url"})
public class OpenFGAClientContext {
    @ConditionalOnMissingBean
    @Bean
    public ApiClient openFgaApiClient(OpenFGAProperties props) {
        HttpClient.Builder httpClientBuilder = ApiClient.createDefaultHttpClientBuilder();
        ApiClient apiClient = new ApiClient(httpClientBuilder, ApiClient.createDefaultObjectMapper(), props.getApiUrl());
        apiClient.setConnectTimeout(props.getConnectTimeout());
        apiClient.setReadTimeout(props.getReadTimeout());
        Optional.ofNullable(props.getApiToken()).ifPresent(apiToken -> apiClient.setRequestInterceptor(builder -> builder.header("Authorization", "Bearer " + apiToken)));
        return apiClient;
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenFGAClientFactory openFgaClientFactory(ApiClient openFgaApiClient, OpenFGAProperties props) {
        return new OpenFGAClientFactory(openFgaApiClient, props);
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenFGAStoreManager openFgaStoreManager(OpenFGAClientFactory clientFactory, RelationshipTypeDAO relationshipTypeDAO) {
        return new OpenFGAStoreManager(clientFactory, relationshipTypeDAO);
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenFGAHealthIndicator openFgaHealthIndicator(DomainHolder<?> domainHolder, OpenFGAClientFactory clientFactory) {
        return new OpenFGAHealthIndicator(domainHolder, clientFactory);
    }
}

