/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.dataviz.chart;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.JsonUtils;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.kendo.ui.KendoDataSource;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.dataviz.chart.ChartDataSource;
import org.wicketstuff.kendo.ui.dataviz.chart.IChartListener;
import org.wicketstuff.kendo.ui.dataviz.chart.series.Series;

public abstract class ChartBehavior
extends KendoUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "kendoChart";
    private final IChartListener listener;
    private KendoDataSource dataSource;
    private JQueryAjaxBehavior onSeriesClickAjaxBehavior = null;
    private final List<Series> series;

    public ChartBehavior(String selector, List<Series> series, IChartListener listener) {
        this(selector, new Options(), series, listener);
    }

    public ChartBehavior(String selector, Options options, List<Series> series, IChartListener listener) {
        super(selector, METHOD, options);
        this.series = series;
        this.listener = (IChartListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        this.dataSource = new ChartDataSource(component);
        this.add(this.dataSource);
        if (this.listener.isSeriesClickEventEnabled()) {
            this.onSeriesClickAjaxBehavior = this.newOnSeriesClickAjaxBehavior(this);
            component.add(new Behavior[]{this.onSeriesClickAjaxBehavior});
        }
    }

    protected abstract CharSequence getProviderUrl();

    @Override
    public void onConfigure(Component component) {
        if (this.onSeriesClickAjaxBehavior != null) {
            this.setOption("seriesClick", this.onSeriesClickAjaxBehavior.getCallbackFunction());
        }
        this.setOption("series", JsonUtils.toString(this.series));
        this.setOption("dataSource", this.dataSource.getName());
        this.dataSource.setTransportReadUrl(this.getProviderUrl());
        this.onConfigure(this.dataSource);
        super.onConfigure(component);
    }

    protected void onConfigure(KendoDataSource dataSource) {
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof SeriesClickEvent) {
            SeriesClickEvent e = (SeriesClickEvent)event;
            this.listener.onSeriesClick(target, e.getSeriesField(), e.getSeriesName(), e.getCategory(), e.getValue());
        }
    }

    protected JQueryAjaxBehavior newOnSeriesClickAjaxBehavior(IJQueryAjaxAware source) {
        return new OnSeriesClickAjaxBehavior(source);
    }

    protected static class SeriesClickEvent
    extends JQueryEvent {
        private final long value = RequestCycleUtils.getQueryParameterValue((String)"value").toOptionalLong();
        private final String category = RequestCycleUtils.getQueryParameterValue((String)"category").toString();
        private final String seriesName;
        private final String seriesField = RequestCycleUtils.getQueryParameterValue((String)"seriesField").toString();

        public SeriesClickEvent() {
            this.seriesName = RequestCycleUtils.getQueryParameterValue((String)"seriesName").toString();
        }

        public long getValue() {
            return this.value;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public String getSeriesField() {
            return this.seriesField;
        }
    }

    protected static class OnSeriesClickAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnSeriesClickAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"e"), CallbackParameter.resolved((String)"value", (String)"e.value"), CallbackParameter.resolved((String)"seriesName", (String)"e.series.name"), CallbackParameter.resolved((String)"seriesField", (String)"e.series.field"), CallbackParameter.resolved((String)"category", (String)"e.category")};
        }

        protected JQueryEvent newEvent() {
            return new SeriesClickEvent();
        }
    }
}

