/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.variable.service.impl.types.SerializableType;

public class LongStringType
extends SerializableType {
    public static final String TYPE_NAME = "longString";
    private final int minLength;

    public LongStringType(int minLength) {
        this.minLength = minLength;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return false;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() >= this.minLength;
        }
        return false;
    }
}

