/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.reflect;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ldaptive.beans.AbstractClassDescriptor;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.beans.DnValueMutator;
import org.ldaptive.beans.Entry;
import org.ldaptive.beans.reflect.DefaultDnValueMutator;
import org.ldaptive.beans.reflect.DefaultReflectionTranscoder;
import org.ldaptive.beans.reflect.FieldAttributeValueMutator;
import org.ldaptive.beans.reflect.TranscoderFactory;
import org.ldaptive.transcode.ValueTranscoder;

public class FieldClassDescriptor
extends AbstractClassDescriptor {
    @Override
    public void initialize(Class<?> type) {
        Entry entryAnnotation;
        Map<String, Field> fields = this.getDeclaredFields(type);
        if (fields.containsKey((entryAnnotation = type.getAnnotation(Entry.class)).dn())) {
            this.setDnValueMutator(this.createDnValueMutator(fields.get(entryAnnotation.dn())));
        }
        for (Attribute attr : entryAnnotation.attributes()) {
            String property;
            if (attr.values().length != 0) continue;
            String string = property = attr.property().length() > 0 ? attr.property() : attr.name();
            if (!fields.containsKey(property)) continue;
            this.addAttributeValueMutator(this.createAttributeValueMutator(fields.get(property), attr));
        }
    }

    protected Map<String, Field> getDeclaredFields(Class<?> type) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields;
    }

    protected DnValueMutator createDnValueMutator(Field field) {
        return new DefaultDnValueMutator(new FieldAttributeValueMutator(new DefaultReflectionTranscoder(field.getGenericType()), field));
    }

    protected AttributeValueMutator createAttributeValueMutator(Field field, Attribute attribute) {
        String name = "".equals(attribute.name()) ? field.getName() : attribute.name();
        ValueTranscoder<?> transcoder = TranscoderFactory.getInstance(attribute.transcoder());
        return new FieldAttributeValueMutator(name, attribute.binary(), new DefaultReflectionTranscoder(field.getGenericType(), transcoder), field);
    }
}

