/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.client.v2;

import com.yubico.client.v2.VerificationResponse;
import com.yubico.client.v2.Version;
import com.yubico.client.v2.exceptions.YubicoValidationFailure;
import com.yubico.client.v2.exceptions.YubicoVerificationException;
import com.yubico.client.v2.impl.YubicoClientImpl;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YubicoClient {
    private static final Logger log = LoggerFactory.getLogger(YubicoClient.class);
    protected Integer clientId;
    protected byte[] key;
    protected Integer sync;
    protected int maxRetries = 5;
    protected String[] wsapi_urls = new String[]{"https://api.yubico.com/wsapi/2.0/verify"};
    protected String userAgent = "yubico-java-client/" + Version.version + " (" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ")";
    private static final Integer OTP_MIN_LEN = 32;
    private static final Integer OTP_MAX_LEN = 48;

    public abstract VerificationResponse verify(String var1) throws YubicoVerificationException, YubicoValidationFailure;

    public Integer getClientId() {
        return this.clientId;
    }

    public void setClientId(Integer clientId) {
        this.clientId = clientId;
    }

    public void setKey(String key) {
        this.key = Base64.decodeBase64((byte[])key.getBytes());
    }

    public String getKey() {
        return new String(Base64.encodeBase64((byte[])this.key));
    }

    public void setSync(Integer sync) {
        this.sync = sync;
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("negative maxRetries is not valid.");
        }
        this.maxRetries = maxRetries;
    }

    public String[] getWsapiUrls() {
        return this.wsapi_urls;
    }

    public void setWsapiUrls(String[] wsapi) {
        for (String url : wsapi) {
            this.warnIfDeprecatedUrl(url);
        }
        this.wsapi_urls = wsapi;
    }

    protected void warnIfDeprecatedUrl(String url) {
        if (url != null && url.startsWith("http:")) {
            log.warn("Deprecated YubiCloud URL: {} - naked HTTP requests are deprecated and will not be supported from 2019-02-04. See: https://status.yubico.com/2018/11/26/deprecating-yubicloud-v1-protocol-plain-text-requests-and-old-tls-versions/", (Object)url);
        }
        if (url != null && (url.startsWith("https://api2.yubico.com/") || url.startsWith("https://api3.yubico.com/") || url.startsWith("https://api4.yubico.com/") || url.startsWith("https://api5.yubico.com/"))) {
            log.warn("Deprecated YubiCloud URL: {} - api2, api3, api4 and api5 are deprecated will not be supported from 2020-07-01. See: https://status.yubico.com/", (Object)url);
        }
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static YubicoClient getClient(Integer clientId, String key) {
        return new YubicoClientImpl(clientId, key);
    }

    public static String getPublicId(String otp) {
        if (otp == null || otp.length() < OTP_MIN_LEN) {
            throw new IllegalArgumentException("The OTP is too short to be valid");
        }
        Integer len = otp.length();
        return otp.substring(0, len - 32).toLowerCase();
    }

    public static boolean isValidOTPFormat(String otp) {
        if (otp == null) {
            return false;
        }
        int len = otp.length();
        for (char c : otp.toCharArray()) {
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return OTP_MIN_LEN <= len && len <= OTP_MAX_LEN;
    }
}

