/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.core.TCConnection;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.util.Assert;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerMessageTransport
extends MessageTransportBase {
    private static final Logger smtLogger = LoggerFactory.getLogger(ServerMessageTransport.class);

    public ServerMessageTransport(TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory) {
        super(MessageTransportState.STATE_RESTART, handshakeErrorHandler, messageFactory, smtLogger);
    }

    public ServerMessageTransport(TCConnection conn, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory) {
        super(MessageTransportState.STATE_START_OPEN, handshakeErrorHandler, messageFactory, smtLogger);
        Assert.assertNotNull(conn);
        this.wireNewConnection(conn);
    }

    @Override
    protected MessageTransportBase.ConnectionAttacher getConnectionAttacher() {
        if (this.status.isRestart()) {
            return new RestartConnectionAttacher();
        }
        return super.getConnectionAttacher();
    }

    @Override
    public NetworkStackID open(InetSocketAddress serverAddress) {
        throw new UnsupportedOperationException("Server transport doesn't support open()");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Server transport doesn't support reset()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveTransportMessageImpl(WireProtocolMessage message) {
        boolean notifyTransportConnected = false;
        boolean recycleAndReturn = false;
        if (!this.status.isEstablished()) {
            MessageTransportStatus messageTransportStatus = this.status;
            synchronized (messageTransportStatus) {
                if (this.status.isConnected()) {
                    recycleAndReturn = true;
                    notifyTransportConnected = this.verifyAndHandleAck(message);
                } else if (!this.status.isEstablished()) {
                    this.logger.debug("Ignoring the message received for an Un-Established Connection; " + message.getSource() + "; " + message);
                    recycleAndReturn = true;
                }
            }
        }
        if (recycleAndReturn) {
            if (notifyTransportConnected) {
                this.fireTransportConnectedEvent();
            }
            message.complete();
        } else {
            super.receiveToReceiveLayer(message);
        }
    }

    private boolean verifyAndHandleAck(WireProtocolMessage message) {
        if (!this.verifyAck(message)) {
            this.handleHandshakeError(new TransportHandshakeErrorContext("Expected an ACK message but received: " + message, TransportHandshakeError.ERROR_HANDSHAKE));
            return false;
        }
        this.handleAck((TransportHandshakeMessage)message);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAck(TransportHandshakeMessage ack) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            Assert.eval(this.status.isConnected());
            Assert.eval("Wrong connection ID: [" + this.getConnectionID() + "] != [" + ack.getConnectionId() + "]", !this.getConnectionID().isNull() || this.getConnectionID().equals(ack.getConnectionId()));
            this.status.established();
        }
    }

    private boolean verifyAck(WireProtocolMessage message) {
        return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isAck();
    }

    public String toString() {
        return "ServerMessageTransport{connection=" + this.getConnection() + '}';
    }

    private final class RestartConnectionAttacher
    implements MessageTransportBase.ConnectionAttacher {
        private RestartConnectionAttacher() {
        }

        @Override
        public void attachNewConnection(TCConnectionEvent closeEvent, TCConnection oldConnection, TCConnection newConnection) {
            ServerMessageTransport.this.wireNewConnection(newConnection);
            ServerMessageTransport.this.log("Attaching new connection to transport: " + newConnection);
        }
    }
}

