/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            LOG.error("Uncaught exception in netty " + String.valueOf(e.getCause()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Utils.handleUncaughtException(e);
        }
        catch (Throwable throwable) {
            LOG.error("Exception thrown while handling uncaught exception " + String.valueOf(throwable.getCause()));
        }
        LOG.info("Received error in netty thread.. terminating server...");
        Runtime.getRuntime().exit(1);
    }
}

