/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.GraphPath;
import org.apache.storm.shade.org.jgrapht.Graphs;
import org.apache.storm.shade.org.jgrapht.graph.GraphPathImpl;
import org.apache.storm.shade.org.jgrapht.traverse.ClosestFirstIterator;

public final class DijkstraShortestPath<V, E> {
    private GraphPath<V, E> path;

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex) {
        this(graph, startVertex, endVertex, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, V startVertex, V endVertex, double radius) {
        if (!graph.containsVertex(endVertex)) {
            throw new IllegalArgumentException("graph must contain the end vertex");
        }
        ClosestFirstIterator<V, E> iter2 = new ClosestFirstIterator<V, E>(graph, startVertex, radius);
        while (iter2.hasNext()) {
            Object vertex = iter2.next();
            if (!vertex.equals(endVertex)) continue;
            this.createEdgeList(graph, iter2, startVertex, endVertex);
            return;
        }
        this.path = null;
    }

    public List<E> getPathEdgeList() {
        if (this.path == null) {
            return null;
        }
        return this.path.getEdgeList();
    }

    public GraphPath<V, E> getPath() {
        return this.path;
    }

    public double getPathLength() {
        if (this.path == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.path.getWeight();
    }

    public static <V, E> List<E> findPathBetween(Graph<V, E> graph, V startVertex, V endVertex) {
        DijkstraShortestPath<V, E> alg = new DijkstraShortestPath<V, E>(graph, startVertex, endVertex);
        return alg.getPathEdgeList();
    }

    private void createEdgeList(Graph<V, E> graph, ClosestFirstIterator<V, E> iter2, V startVertex, V endVertex) {
        E edge;
        ArrayList<E> edgeList = new ArrayList<E>();
        V v = endVertex;
        while ((edge = iter2.getSpanningTreeEdge(v)) != null) {
            edgeList.add(edge);
            v = Graphs.getOppositeVertex(graph, edge, v);
        }
        Collections.reverse(edgeList);
        double pathLength = iter2.getShortestPathLength(endVertex);
        this.path = new GraphPathImpl<V, E>(graph, startVertex, endVertex, edgeList, pathLength);
    }
}

