/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.io.Content;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.handler.ContextHandler;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.Fields;
import org.sparkproject.jetty.util.StringUtil;

public class ShutdownHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHandler.class);
    private final String _shutdownPath;
    private final String _shutdownToken;
    private boolean _exitJvm = false;

    public ShutdownHandler(String shutdownToken) {
        this(null, null, shutdownToken, false);
    }

    public ShutdownHandler(String shutdownToken, boolean exitJVM) {
        this(null, null, shutdownToken, exitJVM);
    }

    public ShutdownHandler(Handler handler, String shutdownPath, String shutdownToken, boolean exitJVM) {
        super(handler);
        this._shutdownPath = StringUtil.isBlank(shutdownPath) ? "/shutdown" : shutdownPath;
        this._shutdownToken = shutdownToken;
        this._exitJvm = exitJVM;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String pathInContext;
        String fullPath = request.getHttpURI().getCanonicalPath();
        ContextHandler contextHandler = ContextHandler.getContextHandler(request);
        if (contextHandler != null ? !(pathInContext = contextHandler.getContext().getPathInContext(fullPath)).startsWith(this._shutdownPath) : !fullPath.startsWith(this._shutdownPath)) {
            return super.handle(request, response, callback);
        }
        if (!request.getMethod().equals("POST")) {
            Response.writeError(request, response, callback, 400);
            return true;
        }
        if (!this.hasCorrectSecurityToken(request)) {
            LOG.warn("Unauthorized tokenless shutdown attempt from {}", (Object)request.getConnectionMetaData().getRemoteSocketAddress());
            Response.writeError(request, response, callback, 401);
            return true;
        }
        if (!this.requestFromLocalhost(request)) {
            LOG.warn("Unauthorized non-loopback shutdown attempt from {}", (Object)request.getConnectionMetaData().getRemoteSocketAddress());
            Response.writeError(request, response, callback, 401);
            return true;
        }
        LOG.info("Shutting down by request from {}", (Object)request.getConnectionMetaData().getRemoteSocketAddress());
        Callback triggerShutdownCallback = Callback.from(() -> CompletableFuture.runAsync(this::shutdownServer));
        response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/plain, charset=utf-8");
        String message = "Shutdown triggered";
        Content.Sink.write(response, true, message, triggerShutdownCallback);
        return true;
    }

    private boolean requestFromLocalhost(Request request) {
        SocketAddress socketAddress = request.getConnectionMetaData().getRemoteSocketAddress();
        if (socketAddress == null) {
            return false;
        }
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)socketAddress;
            return addr.getAddress().isLoopbackAddress();
        }
        return false;
    }

    private boolean hasCorrectSecurityToken(Request request) {
        Fields fields = Request.extractQueryParameters(request);
        String tok = fields.getValue("token");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Token: {}", (Object)tok);
        }
        return this._shutdownToken.equals(tok);
    }

    private void shutdownServer() {
        try {
            this.getServer().stop();
        }
        catch (Exception e) {
            LOG.warn("Unable to stop server", (Throwable)e);
        }
        if (this._exitJvm) {
            System.exit(0);
        }
    }

    public void setExitJvm(boolean exitJvm) {
        this._exitJvm = exitJvm;
    }

    public boolean isExitJvm() {
        return this._exitJvm;
    }
}

