/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.compression.server;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.compression.Compression;
import org.sparkproject.jetty.compression.server.CompressionConfig;
import org.sparkproject.jetty.compression.server.internal.CompressionResponse;
import org.sparkproject.jetty.compression.server.internal.DecompressionRequest;
import org.sparkproject.jetty.http.BadMessageException;
import org.sparkproject.jetty.http.ComplianceViolation;
import org.sparkproject.jetty.http.HttpException;
import org.sparkproject.jetty.http.HttpField;
import org.sparkproject.jetty.http.HttpFields;
import org.sparkproject.jetty.http.HttpHeader;
import org.sparkproject.jetty.http.PreEncodedHttpField;
import org.sparkproject.jetty.http.QuotedQualityCSV;
import org.sparkproject.jetty.http.pathmap.MatchedResource;
import org.sparkproject.jetty.http.pathmap.PathMappings;
import org.sparkproject.jetty.http.pathmap.PathSpec;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.HttpConfiguration;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.StringUtil;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.component.LifeCycle;

public class CompressionHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionHandler.class);
    private final HttpField varyAcceptEncoding = new PreEncodedHttpField(HttpHeader.VARY, HttpHeader.ACCEPT_ENCODING.asString());
    private final Map<String, Compression> supportedEncodings = new TreeMap<String, Compression>(String.CASE_INSENSITIVE_ORDER);
    private final PathMappings<CompressionConfig> pathConfigs = new PathMappings();

    public CompressionHandler() {
        this.installBean(this.pathConfigs);
    }

    public CompressionHandler(Handler handler) {
        super(handler);
        this.installBean(this.pathConfigs);
    }

    public Compression putCompression(Compression compression) {
        Compression previous = this.supportedEncodings.put(compression.getEncodingName(), compression);
        compression.setContainer(this);
        this.updateBean(previous, compression, true);
        return previous;
    }

    public Compression removeCompression(String encodingName) {
        Compression compression = this.supportedEncodings.remove(encodingName);
        this.removeBean(compression);
        return compression;
    }

    public CompressionConfig ensureConfiguration(PathSpec pathSpec) {
        return this.pathConfigs.computeIfAbsent(pathSpec, spec -> CompressionConfig.builder().build());
    }

    public CompressionConfig ensureConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from(pathSpecString);
        return this.ensureConfiguration(pathSpec);
    }

    public CompressionConfig getConfiguration(PathSpec pathSpec) {
        return this.pathConfigs.get(pathSpec);
    }

    public CompressionConfig getConfiguration(String pathSpecString) {
        PathSpec pathSpec = PathSpec.from(pathSpecString);
        return this.getConfiguration(pathSpec);
    }

    public CompressionConfig putConfiguration(PathSpec pathSpec, CompressionConfig config) {
        return this.pathConfigs.put(pathSpec, config);
    }

    public CompressionConfig putConfiguration(String pathSpecString, CompressionConfig config) {
        PathSpec pathSpec = PathSpec.from(pathSpecString);
        return this.putConfiguration(pathSpec, config);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.supportedEncodings.isEmpty()) {
            TypeUtil.serviceStream(ServiceLoader.load(Compression.class)).forEach(this::putCompression);
        }
        this.supportedEncodings.values().forEach(compression -> {
            if (compression.getByteBufferPool() == null) {
                compression.setByteBufferPool(this.getServer().getByteBufferPool());
            }
        });
        if (this.pathConfigs.isEmpty()) {
            this.pathConfigs.put("/", CompressionConfig.builder().defaults().build());
        }
        super.doStart();
        this.pathConfigs.values().forEach(c -> LifeCycle.start(c));
    }

    @Override
    protected void doStop() throws Exception {
        this.pathConfigs.values().forEach(c -> LifeCycle.stop(c));
        super.doStop();
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String compressEncoding;
        Handler next;
        if (LOG.isDebugEnabled()) {
            LOG.debug("handling {} {} {}", new Object[]{request, response, this});
        }
        if ((next = this.getHandler()) == null) {
            return false;
        }
        if (Request.as(request, DecompressionRequest.class) != null) {
            return next.handle(request, response, callback);
        }
        String pathInContext = Request.getPathInContext(request);
        MatchedResource<CompressionConfig> matchedConfig = this.pathConfigs.getMatched(pathInContext);
        if (matchedConfig == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping compression: path {} has no matching compression config", (Object)pathInContext);
            }
            return next.handle(request, response, callback);
        }
        CompressionConfig config = matchedConfig.getResource();
        String requestContentEncoding = null;
        List<QuotedQualityCSV.QualityValue> requestAcceptEncoding = List.of();
        String ifNoneMatch = null;
        String ifMatch = null;
        QuotedQualityCSV qualityCSV = null;
        HttpFields fields = request.getHeaders();
        for (HttpField field : fields) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case CONTENT_ENCODING: {
                    String contentEncoding = field.getValue();
                    if (this.supportedEncodings.containsKey(contentEncoding)) {
                        requestContentEncoding = contentEncoding;
                        break;
                    }
                    requestContentEncoding = null;
                    break;
                }
                case ACCEPT_ENCODING: {
                    if (qualityCSV == null) {
                        final HttpConfiguration httpConfiguration = request.getConnectionMetaData().getHttpConfiguration();
                        qualityCSV = new QuotedQualityCSV(this){
                            final /* synthetic */ CompressionHandler this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            protected void onComplianceViolation(ComplianceViolation violation, String value) {
                                if (!httpConfiguration.getHttpCompliance().allows(violation)) {
                                    throw new BadMessageException(violation.toString());
                                }
                                httpConfiguration.notifyViolation(violation, value);
                            }
                        };
                    }
                    qualityCSV.addValue(field.getValue());
                    break;
                }
                case IF_MATCH: {
                    ifMatch = HttpField.asList(ifMatch, field.getValue());
                    break;
                }
                case IF_NONE_MATCH: {
                    ifNoneMatch = HttpField.asList(ifNoneMatch, field.getValue());
                }
            }
        }
        if (qualityCSV != null) {
            requestAcceptEncoding = qualityCSV.getQualityValues();
        }
        String decompressEncoding = config.getDecompressionEncoding(this.supportedEncodings.keySet(), request, requestContentEncoding, pathInContext);
        try {
            compressEncoding = config.getCompressionEncoding(this.supportedEncodings.keySet(), request, requestAcceptEncoding, pathInContext);
        }
        catch (Throwable x) {
            HttpException http;
            int statusCode;
            if (x instanceof HttpException && (statusCode = (http = (HttpException)((Object)x)).getCode()) == 415) {
                String accepted = http.getReason();
                if (StringUtil.isNotBlank(accepted)) {
                    response.getHeaders().put(HttpHeader.ACCEPT_ENCODING, accepted);
                }
                Response.writeError(request, response, callback, http.getCode(), null, x);
                return true;
            }
            throw x;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("request[{}] Content-Encoding={}, Accept-Encoding={}, decompressEncoding={}, compressEncoding={}", new Object[]{request, requestContentEncoding, requestAcceptEncoding, decompressEncoding, compressEncoding});
        }
        if (ifMatch != null || ifNoneMatch != null) {
            request = new StripEtagRequest(request, ifMatch, ifNoneMatch);
        }
        if (decompressEncoding != null) {
            request = this.newDecompressionRequest(request, decompressEncoding);
        }
        if (compressEncoding != null) {
            response.getHeaders().ensureField(this.varyAcceptEncoding);
            response = this.newCompressionResponse(request, response, compressEncoding, config);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} {}", new Object[]{request, response, this});
        }
        if (next.handle(request, response, callback)) {
            return true;
        }
        if (decompressEncoding != null) {
            Request.as(request, DecompressionRequest.class).destroy();
        }
        return false;
    }

    private Compression getCompression(String encoding) {
        Compression compression;
        Compression compression2 = compression = encoding == null ? null : this.supportedEncodings.get(encoding);
        if (compression == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no compression found for encoding type {}", (Object)encoding);
            }
            return null;
        }
        return compression;
    }

    private Response newCompressionResponse(Request request, Response response, String compressEncoding, CompressionConfig config) {
        Compression compression = this.getCompression(compressEncoding);
        if (compression == null) {
            return response;
        }
        return new CompressionResponse(request, response, compression, config);
    }

    private Request newDecompressionRequest(Request request, String decompressEncoding) {
        Compression compression = this.getCompression(decompressEncoding);
        if (compression == null) {
            return request;
        }
        return new DecompressionRequest(compression, request);
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,supported=%s}", TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getState(), String.join((CharSequence)",", this.supportedEncodings.keySet()));
    }

    private class StripEtagRequest
    extends Request.Wrapper {
        private final HttpFields _strippedHttpFields;

        StripEtagRequest(Request request, String ifMatch, String ifNoneMatch) {
            super(request);
            HttpFields.Mutable fields = HttpFields.build(request.getHeaders());
            if (ifMatch != null) {
                for (Compression known : CompressionHandler.this.supportedEncodings.values()) {
                    ifMatch = known.stripSuffixes(ifMatch);
                }
                fields.put(HttpHeader.IF_MATCH, ifMatch);
            }
            if (ifNoneMatch != null) {
                for (Compression known : CompressionHandler.this.supportedEncodings.values()) {
                    ifNoneMatch = known.stripSuffixes(ifNoneMatch);
                }
                fields.put(HttpHeader.IF_NONE_MATCH, ifNoneMatch);
            }
            this._strippedHttpFields = fields.asImmutable();
        }

        @Override
        public HttpFields getHeaders() {
            return this._strippedHttpFields;
        }
    }
}

