/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.nio.channels.Channels;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.util.ArrowUtils$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a!\u0002\b\u0010\u0001MY\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011Q\u0002!\u0011!Q\u0001\nUBQ!\u0010\u0001\u0005\u0002yBqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004L\u0001\u0001\u0006I!\u0012\u0005\b\u0019\u0002\u0011\r\u0011\"\u0005N\u0011\u0019\u0011\u0006\u0001)A\u0005\u001d\"91\u000b\u0001b\u0001\n#!\u0006B\u0002-\u0001A\u0003%Q\u000bC\u0004Z\u0001\t\u0007I\u0011\u0003.\t\r\u0005\u0004\u0001\u0015!\u0003\\\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0011\u0015Q\u0007\u0001\"\u0001l\u0005Q\u0019\u0006/\u0019:l\u0003J\u0014xn\u001e$jY\u0016<&/\u001b;fe*\u0011\u0001#E\u0001\u0006CJ\u0014xn\u001e\u0006\u0003%M\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Q)\u0012aA:rY*\u0011acF\u0001\u0006gB\f'o\u001b\u0006\u00031e\ta!\u00199bG\",'\"\u0001\u000e\u0002\u0007=\u0014xmE\u0002\u00019\u0011\u0002\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004PE*,7\r\u001e\t\u0003;\u0015J!A\n\u0010\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f\u0003\u0019\u00198\r[3nC\u000e\u0001\u0001C\u0001\u00163\u001b\u0005Y#B\u0001\u0017.\u0003\u0011\u0001xN[8\u000b\u00059z\u0013!\u0002;za\u0016\u001c(B\u0001\u00192\u0003\u00191Xm\u0019;pe*\u0011\u0001cF\u0005\u0003g-\u0012aaU2iK6\f\u0017\u0001\u00029bi\"\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\t\u0019LG.\u001a\u0006\u0003u\u0001\n1A\\5p\u0013\tatG\u0001\u0003QCRD\u0017A\u0002\u001fj]&$h\bF\u0002@\u0003\n\u0003\"\u0001\u0011\u0001\u000e\u0003=AQaJ\u0002A\u0002%BQ\u0001N\u0002A\u0002U\n\u0011\"\u00197m_\u000e\fGo\u001c:\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001S\u0019\u0002\r5,Wn\u001c:z\u0013\tQuIA\bCk\u001a4WM]!mY>\u001c\u0017\r^8s\u0003)\tG\u000e\\8dCR|'\u000fI\u0001\u0005e>|G/F\u0001O!\ty\u0005+D\u00010\u0013\t\tvF\u0001\tWK\u000e$xN]*dQ\u0016l\u0017MU8pi\u0006)!o\\8uA\u00051An\\1eKJ,\u0012!\u0016\t\u0003\u001fZK!aV\u0018\u0003\u0019Y+7\r^8s\u0019>\fG-\u001a:\u0002\u000f1|\u0017\rZ3sA\u0005Qa-\u001b7f/JLG/\u001a:\u0016\u0003m\u0003\"\u0001X0\u000e\u0003uS!AX\u0018\u0002\u0007%\u00048-\u0003\u0002a;\ny\u0011I\u001d:po\u001aKG.Z,sSR,'/A\u0006gS2,wK]5uKJ\u0004\u0013!B2m_N,G#\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\tUs\u0017\u000e^\u0001\u0006oJLG/\u001a\u000b\u0003I2DQ!\\\u0007A\u00029\faBY1uG\"\u0014\u0015\u0010^3t\u0013R,'\u000fE\u0002pojt!\u0001];\u000f\u0005E$X\"\u0001:\u000b\u0005MD\u0013A\u0002\u001fs_>$h(C\u0001h\u0013\t1h-A\u0004qC\u000e\\\u0017mZ3\n\u0005aL(\u0001C%uKJ\fGo\u001c:\u000b\u0005Y4\u0007cA3|{&\u0011AP\u001a\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003KzL!a 4\u0003\t\tKH/\u001a")
public class SparkArrowFileWriter
implements AutoCloseable {
    private final BufferAllocator allocator = ArrowUtils$.MODULE$.rootAllocator().newChildAllocator("to" + this.getClass().getSimpleName(), 0L, Long.MAX_VALUE);
    private final VectorSchemaRoot root;
    private final VectorLoader loader;
    private final ArrowFileWriter fileWriter;

    private BufferAllocator allocator() {
        return this.allocator;
    }

    public VectorSchemaRoot root() {
        return this.root;
    }

    public VectorLoader loader() {
        return this.loader;
    }

    public ArrowFileWriter fileWriter() {
        return this.fileWriter;
    }

    @Override
    public void close() {
        this.fileWriter().close();
        this.root().close();
        this.allocator().close();
    }

    public void write(Iterator<byte[]> batchBytesIter) {
        this.fileWriter().start();
        while (batchBytesIter.hasNext()) {
            byte[] batchBytes = (byte[])batchBytesIter.next();
            ArrowRecordBatch batch = ArrowConverters$.MODULE$.loadBatch(batchBytes, this.allocator());
            this.loader().load(batch);
            this.fileWriter().writeBatch();
            batch.close();
        }
        this.fileWriter().close();
    }

    public SparkArrowFileWriter(Schema schema, Path path) {
        this.root = VectorSchemaRoot.create((Schema)schema, (BufferAllocator)this.allocator());
        this.loader = new VectorLoader(this.root());
        this.fileWriter = new ArrowFileWriter(this.root(), null, Channels.newChannel(Files.newOutputStream(path, new OpenOption[0])));
    }
}

