/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.resolver.AttributeScopeStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolutionValidator;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.ArraysZip;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Exists;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.ListQuery;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.OuterReference;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001\u0002\r\u001a\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006i\u0001!\t!\u000e\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0011\u0019i\u0004\u0001)A\u0005u!9a\b\u0001a\u0001\n\u0013y\u0004bB\"\u0001\u0001\u0004%I\u0001\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0015\u0002!\t\u000b-\u0003A\u0011\u0001'\t\u000bU\u0003A\u0011\u0001,\t\u000b!\u0004A\u0011B5\t\u000b=\u0004A\u0011\u00029\t\u000bY\u0004A\u0011B<\t\u000bu\u0004A\u0011\u0002@\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a\u0014\u0001\t\u0013\t\t\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005-\u0004\u0001\"\u0003\u0002n!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0002\u001e\u000bb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8WC2LG-\u0019;pe*\u0011!dG\u0001\te\u0016\u001cx\u000e\u001c<fe*\u0011A$H\u0001\tC:\fG._:jg*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002'I,7o\u001c7vi&|gNV1mS\u0012\fGo\u001c:\u0011\u0005E\u0012T\"A\r\n\u0005MJ\"a\u0005*fg>dW\u000f^5p]Z\u000bG.\u001b3bi>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u00027oA\u0011\u0011\u0007\u0001\u0005\u0006_\t\u0001\r\u0001M\u0001\u0014CR$(/\u001b2vi\u0016\u001c6m\u001c9f'R\f7m[\u000b\u0002uA\u0011\u0011gO\u0005\u0003ye\u00111#\u0011;ue&\u0014W\u000f^3TG>\u0004Xm\u0015;bG.\fA#\u0019;ue&\u0014W\u000f^3TG>\u0004Xm\u0015;bG.\u0004\u0013aF5o\u001fV$XM\u001d*fM\u0016\u0014XM\\2f'V\u0014GO]3f+\u0005\u0001\u0005C\u0001\u0016B\u0013\t\u00115FA\u0004C_>dW-\u00198\u00027%tw*\u001e;feJ+g-\u001a:f]\u000e,7+\u001e2ue\u0016,w\fJ3r)\t)\u0005\n\u0005\u0002+\r&\u0011qi\u000b\u0002\u0005+:LG\u000fC\u0004J\r\u0005\u0005\t\u0019\u0001!\u0002\u0007a$\u0013'\u0001\rj]>+H/\u001a:SK\u001a,'/\u001a8dKN+(\r\u001e:fK\u0002\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0003\u000b6CQA\u0014\u0005A\u0002=\u000b!\"\u001a=qe\u0016\u001c8/[8o!\t\u00016+D\u0001R\u0015\t\u0011V$A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001+R\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0014m\u0006d\u0017\u000eZ1uKB\u0013xN[3di2K7\u000f\u001e\u000b\u0003\u000b^CQ\u0001W\u0005A\u0002e\u000b1\u0002\u001d:pU\u0016\u001cG\u000fT5tiB\u0019!LY3\u000f\u0005m\u0003gB\u0001/`\u001b\u0005i&B\u00010(\u0003\u0019a$o\\8u}%\tA&\u0003\u0002bW\u00059\u0001/Y2lC\u001e,\u0017BA2e\u0005\r\u0019V-\u001d\u0006\u0003C.\u0002\"\u0001\u00154\n\u0005\u001d\f&a\u0004(b[\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u0002#Y\fG.\u001b3bi\u0016\u0004&/\u001a3jG\u0006$X\r\u0006\u0002FU\")1N\u0003a\u0001Y\u0006I\u0001O]3eS\u000e\fG/\u001a\t\u0003!6L!A\\)\u0003\u0013A\u0013X\rZ5dCR,\u0017A\u0007<bY&$\u0017\r^3BiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,GCA#r\u0011\u0015\u00118\u00021\u0001t\u0003I\tG\u000f\u001e:jEV$XMU3gKJ,gnY3\u0011\u0005A#\u0018BA;R\u0005I\tE\u000f\u001e:jEV$XMU3gKJ,gnY3\u0002\u001bY\fG.\u001b3bi\u0016\fE.[1t)\t)\u0005\u0010C\u0003z\u0019\u0001\u0007!0A\u0003bY&\f7\u000f\u0005\u0002Qw&\u0011A0\u0015\u0002\u0006\u00032L\u0017m]\u0001\u0017m\u0006d\u0017\u000eZ1uK>+H/\u001a:SK\u001a,'/\u001a8dKR\u0011Qi \u0005\b\u0003\u0003i\u0001\u0019AA\u0002\u00039yW\u000f^3s%\u00164WM]3oG\u0016\u00042\u0001UA\u0003\u0013\r\t9!\u0015\u0002\u000f\u001fV$XM\u001d*fM\u0016\u0014XM\\2f\u0003a1\u0018\r\\5eCR,')\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0004\u000b\u00065\u0001bBA\b\u001d\u0001\u0007\u0011\u0011C\u0001\u0011E&t\u0017M]=FqB\u0014Xm]:j_:\u00042\u0001UA\n\u0013\r\t)\"\u0015\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\fqB^1mS\u0012\fG/\u001a'ji\u0016\u0014\u0018\r\u001c\u000b\u0004\u000b\u0006m\u0001bBA\u000f\u001f\u0001\u0007\u0011qD\u0001\bY&$XM]1m!\r\u0001\u0016\u0011E\u0005\u0004\u0003G\t&a\u0002'ji\u0016\u0014\u0018\r\\\u0001\u0017m\u0006d\u0017\u000eZ1uKN\u001b\u0017\r\\1s'V\u0014\u0017/^3ssR\u0019Q)!\u000b\t\u000f\u0005-\u0002\u00031\u0001\u0002.\u0005q1oY1mCJ\u001cVOY9vKJL\bc\u0001)\u00020%\u0019\u0011\u0011G)\u0003\u001dM\u001b\u0017\r\\1s'V\u0014\u0017/^3ss\u0006\u0011b/\u00197jI\u0006$X-\u00138Tk\n\fX/\u001a:z)\r)\u0015q\u0007\u0005\b\u0003s\t\u0002\u0019AA\u001e\u0003)IgnU;ccV,'/\u001f\t\u0004!\u0006u\u0012bAA #\nQ\u0011J\\*vEF,XM]=\u0002#Y\fG.\u001b3bi\u0016d\u0015n\u001d;Rk\u0016\u0014\u0018\u0010F\u0002F\u0003\u000bBq!a\u0012\u0013\u0001\u0004\tI%A\u0005mSN$\u0018+^3ssB\u0019\u0001+a\u0013\n\u0007\u00055\u0013KA\u0005MSN$\u0018+^3ss\u0006qa/\u00197jI\u0006$X-\u0012=jgR\u001cHcA#\u0002T!9\u0011QK\nA\u0002\u0005]\u0013AB3ySN$8\u000fE\u0002Q\u00033J1!a\u0017R\u0005\u0019)\u00050[:ug\u0006\tb/\u00197jI\u0006$X-\u0011:sCf\u001c(,\u001b9\u0015\u0007\u0015\u000b\t\u0007C\u0004\u0002dQ\u0001\r!!\u001a\u0002\u0013\u0005\u0014(/Y=t5&\u0004\bc\u0001)\u0002h%\u0019\u0011\u0011N)\u0003\u0013\u0005\u0013(/Y=t5&\u0004\u0018A\u0007<bY&$\u0017\r^3US6,'p\u001c8f\u000bb\u0004(/Z:tS>tGcA#\u0002p!9\u0011\u0011O\u000bA\u0002\u0005M\u0014A\u0005;j[\u0016TxN\\3FqB\u0014Xm]:j_:\u00042\u0001UA;\u0013\r\t9(\u0015\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\f!C^1mS\u0012\fG/Z#yaJ,7o]5p]R\u0019Q)! \t\u000b93\u0002\u0019A(\u0002-Y\fG.\u001b3bi\u0016Le\u000e];u\t\u0006$\u0018\rV=qKN$2!RAB\u0011\u0015qu\u00031\u0001P\u0001")
public class ExpressionResolutionValidator {
    private final ResolutionValidator resolutionValidator;
    private final AttributeScopeStack attributeScopeStack;
    private boolean inOuterReferenceSubtree;

    private AttributeScopeStack attributeScopeStack() {
        return this.attributeScopeStack;
    }

    private boolean inOuterReferenceSubtree() {
        return this.inOuterReferenceSubtree;
    }

    private void inOuterReferenceSubtree_$eq(boolean x$1) {
        this.inOuterReferenceSubtree = x$1;
    }

    public void validate(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression2;
            this.validateAttributeReference(attributeReference);
            return;
        }
        if (expression2 instanceof Alias) {
            Alias alias = (Alias)expression2;
            this.validateAlias(alias);
            return;
        }
        if (expression2 instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression2;
            this.validateBinaryExpression(binaryExpression);
            return;
        }
        if (expression2 instanceof Literal) {
            Literal literal = (Literal)expression2;
            this.validateLiteral(literal);
            return;
        }
        if (expression2 instanceof ScalarSubquery) {
            ScalarSubquery scalarSubquery = (ScalarSubquery)expression2;
            this.validateScalarSubquery(scalarSubquery);
            return;
        }
        if (expression2 instanceof InSubquery) {
            InSubquery inSubquery = (InSubquery)expression2;
            this.validateInSubquery(inSubquery);
            return;
        }
        if (expression2 instanceof ListQuery) {
            ListQuery listQuery = (ListQuery)expression2;
            this.validateListQuery(listQuery);
            return;
        }
        if (expression2 instanceof Exists) {
            Exists exists = (Exists)expression2;
            this.validateExists(exists);
            return;
        }
        if (expression2 instanceof Predicate) {
            Predicate predicate = (Predicate)((Object)expression2);
            this.validatePredicate(predicate);
            return;
        }
        if (expression2 instanceof ArraysZip) {
            ArraysZip arraysZip = (ArraysZip)expression2;
            this.validateArraysZip(arraysZip);
            return;
        }
        if (expression2 instanceof TimeZoneAwareExpression) {
            TimeZoneAwareExpression timeZoneAwareExpression = (TimeZoneAwareExpression)((Object)expression2);
            this.validateTimezoneExpression(timeZoneAwareExpression);
            return;
        }
        if (expression2 != null) {
            Expression expression3 = expression2;
            this.validateExpression(expression3);
            return;
        }
        throw new MatchError((Object)expression2);
    }

    public void validateProjectList(Seq<NamedExpression> projectList) {
        projectList.foreach((Function1 & Serializable)x0$1 -> {
            ExpressionResolutionValidator.$anonfun$validateProjectList$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void validatePredicate(Predicate predicate) {
        ((TreeNode)((Object)predicate)).children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        DataType dataType = predicate.dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null), (Function0 & Serializable)() -> "Output type of a predicate must be a boolean, but got: " + predicate.dataType().typeName());
        this.validateInputDataTypes((Expression)((Object)predicate));
    }

    private void validateAttributeReference(AttributeReference attributeReference) {
        Predef$.MODULE$.assert(this.attributeScopeStack().contains(attributeReference, this.inOuterReferenceSubtree()), (Function0 & Serializable)() -> "Attribute " + attributeReference + " is missing from attribute scope stack: " + this.attributeScopeStack());
    }

    private void validateAlias(Alias alias) {
        this.validate(alias.child());
    }

    private void validateOuterReference(OuterReference outerReference) {
        this.inOuterReferenceSubtree_$eq(true);
        try {
            this.validate((Expression)((Object)outerReference.e()));
        }
        finally {
            this.inOuterReferenceSubtree_$eq(false);
        }
    }

    private void validateBinaryExpression(BinaryExpression binaryExpression) {
        this.validate((Expression)binaryExpression.left());
        this.validate((Expression)binaryExpression.right());
        this.validateInputDataTypes(binaryExpression);
        BinaryExpression binaryExpression2 = binaryExpression;
        if (binaryExpression2 instanceof TimeZoneAwareExpression) {
            BinaryExpression binaryExpression3 = binaryExpression2;
            Predef$.MODULE$.assert(((TimeZoneAwareExpression)((Object)binaryExpression3)).timeZoneId().nonEmpty(), (Function0 & Serializable)() -> "Timezone expression must have a timezone");
            return;
        }
    }

    private void validateLiteral(Literal literal) {
    }

    private void validateScalarSubquery(ScalarSubquery scalarSubquery) {
        this.attributeScopeStack().pushScope(true);
        try {
            this.resolutionValidator.validate(scalarSubquery.plan());
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        scalarSubquery.outerAttrs().foreach((Function1 & Serializable)outerAttribute -> {
            this.validate(outerAttribute);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(scalarSubquery.plan().output().size() == 1, (Function0 & Serializable)() -> "Scalar subquery returns more than one column: " + scalarSubquery.plan().output());
    }

    private void validateInSubquery(InSubquery inSubquery) {
        inSubquery.values().foreach((Function1 & Serializable)value -> {
            this.validate(value);
            return BoxedUnit.UNIT;
        });
        this.validate(inSubquery.query());
    }

    private void validateListQuery(ListQuery listQuery) {
        this.attributeScopeStack().pushScope(true);
        try {
            this.resolutionValidator.validate(listQuery.plan());
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        listQuery.outerAttrs().foreach((Function1 & Serializable)outerAttribute -> {
            this.validate(outerAttribute);
            return BoxedUnit.UNIT;
        });
    }

    private void validateExists(Exists exists) {
        this.attributeScopeStack().pushScope(true);
        try {
            this.resolutionValidator.validate(exists.plan());
        }
        finally {
            this.attributeScopeStack().popScope();
        }
        exists.outerAttrs().foreach((Function1 & Serializable)outerAttribute -> {
            this.validate(outerAttribute);
            return BoxedUnit.UNIT;
        });
    }

    private void validateArraysZip(ArraysZip arraysZip) {
        arraysZip.children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        arraysZip.names().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        this.validateInputDataTypes(arraysZip);
    }

    private void validateTimezoneExpression(TimeZoneAwareExpression timezoneExpression) {
        ((TreeNode)((Object)timezoneExpression)).children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(timezoneExpression.timeZoneId().nonEmpty(), (Function0 & Serializable)() -> "Timezone expression must have a timezone");
    }

    private void validateExpression(Expression expression2) {
        expression2.children().foreach((Function1 & Serializable)expression -> {
            this.validate(expression);
            return BoxedUnit.UNIT;
        });
        this.validateInputDataTypes(expression2);
    }

    private void validateInputDataTypes(Expression expression) {
        Predef$.MODULE$.assert(expression.checkInputDataTypes().isSuccess(), (Function0 & Serializable)() -> "Input types of " + expression.getClass().getName() + " must be valid, but got: " + ((IterableOnceOps)expression.children().map((Function1 & Serializable)x$1 -> x$1.dataType().typeName())).mkString(", "));
    }

    public static final /* synthetic */ void $anonfun$validateProjectList$1(ExpressionResolutionValidator $this, NamedExpression x0$1) {
        NamedExpression namedExpression = x0$1;
        if (namedExpression instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)namedExpression;
            $this.validateAttributeReference(attributeReference);
            return;
        }
        if (namedExpression instanceof Alias) {
            Alias alias = (Alias)namedExpression;
            $this.validateAlias(alias);
            return;
        }
        if (namedExpression instanceof OuterReference) {
            OuterReference outerReference = (OuterReference)namedExpression;
            $this.validateOuterReference(outerReference);
            return;
        }
        throw new MatchError((Object)namedExpression);
    }

    public ExpressionResolutionValidator(ResolutionValidator resolutionValidator) {
        this.resolutionValidator = resolutionValidator;
        this.attributeScopeStack = resolutionValidator.getAttributeScopeStack();
        this.inOuterReferenceSubtree = false;
    }
}

