/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.storage.CSIStorageCapacity;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CSIStorageCapacityFluent<A extends CSIStorageCapacityFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private Quantity capacity;
    private String kind;
    private Quantity maximumVolumeSize;
    private ObjectMetaBuilder metadata;
    private LabelSelectorBuilder nodeTopology;
    private String storageClassName;

    public CSIStorageCapacityFluent() {
    }

    public CSIStorageCapacityFluent(CSIStorageCapacity instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public LabelSelector buildNodeTopology() {
        return this.nodeTopology != null ? this.nodeTopology.build() : null;
    }

    protected void copyInstance(CSIStorageCapacity instance) {
        CSIStorageCapacity cSIStorageCapacity = instance = instance != null ? instance : new CSIStorageCapacity();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCapacity(instance.getCapacity());
            this.withKind(instance.getKind());
            this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
            this.withMetadata(instance.getMetadata());
            this.withNodeTopology(instance.getNodeTopology());
            this.withStorageClassName(instance.getStorageClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public NodeTopologyNested<A> editNodeTopology() {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public NodeTopologyNested<A> editOrNewNodeTopology() {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(new LabelSelectorBuilder().build()));
    }

    public NodeTopologyNested<A> editOrNewNodeTopologyLike(LabelSelector item) {
        return this.withNewNodeTopologyLike(Optional.ofNullable(this.buildNodeTopology()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIStorageCapacityFluent that = (CSIStorageCapacityFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.maximumVolumeSize, that.maximumVolumeSize)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.nodeTopology, that.nodeTopology)) {
            return false;
        }
        if (!Objects.equals(this.storageClassName, that.storageClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Quantity getCapacity() {
        return this.capacity;
    }

    public String getKind() {
        return this.kind;
    }

    public Quantity getMaximumVolumeSize() {
        return this.maximumVolumeSize;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasMaximumVolumeSize() {
        return this.maximumVolumeSize != null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasNodeTopology() {
        return this.nodeTopology != null;
    }

    public boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.capacity, this.kind, this.maximumVolumeSize, this.metadata, this.nodeTopology, this.storageClassName, this.additionalProperties);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.capacity != null) {
            sb.append("capacity:");
            sb.append(this.capacity);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.maximumVolumeSize != null) {
            sb.append("maximumVolumeSize:");
            sb.append(this.maximumVolumeSize);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.nodeTopology != null) {
            sb.append("nodeTopology:");
            sb.append(this.nodeTopology);
            sb.append(",");
        }
        if (this.storageClassName != null) {
            sb.append("storageClassName:");
            sb.append(this.storageClassName);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withCapacity(Quantity capacity) {
        this.capacity = capacity;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withMaximumVolumeSize(Quantity maximumVolumeSize) {
        this.maximumVolumeSize = maximumVolumeSize;
        return (A)((Object)this);
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public A withNewCapacity(String amount) {
        return this.withCapacity(new Quantity(amount));
    }

    public A withNewCapacity(String amount, String format) {
        return this.withCapacity(new Quantity(amount, format));
    }

    public A withNewMaximumVolumeSize(String amount) {
        return this.withMaximumVolumeSize(new Quantity(amount));
    }

    public A withNewMaximumVolumeSize(String amount, String format) {
        return this.withMaximumVolumeSize(new Quantity(amount, format));
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public NodeTopologyNested<A> withNewNodeTopology() {
        return new NodeTopologyNested(null);
    }

    public NodeTopologyNested<A> withNewNodeTopologyLike(LabelSelector item) {
        return new NodeTopologyNested(item);
    }

    public A withNodeTopology(LabelSelector nodeTopology) {
        this._visitables.remove((Object)"nodeTopology");
        if (nodeTopology != null) {
            this.nodeTopology = new LabelSelectorBuilder(nodeTopology);
            this._visitables.get((Object)"nodeTopology").add(this.nodeTopology);
        } else {
            this.nodeTopology = null;
            this._visitables.get((Object)"nodeTopology").remove(this.nodeTopology);
        }
        return (A)((Object)this);
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return (A)((Object)this);
    }

    public class NodeTopologyNested<N>
    extends LabelSelectorFluent<NodeTopologyNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NodeTopologyNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)CSIStorageCapacityFluent.this.withNodeTopology(this.builder.build());
        }

        public N endNodeTopology() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)CSIStorageCapacityFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

