/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.V2TableReference;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.execution.CacheManager$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelationWithTable$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2CatalogAndIdentifier$;
import org.apache.spark.sql.execution.datasources.v2.ExtractV2Table$;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.execution.datasources.v2.V2TableRefreshUtil$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\r-f\u0001B\u00181\u0001mBQA\u0014\u0001\u0005\u0002=CqA\u0015\u0001A\u0002\u0013%1\u000bC\u0004`\u0001\u0001\u0007I\u0011\u00021\t\r\u0019\u0004\u0001\u0015)\u0003U\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015\t\b\u0001\"\u0001s\u0011\u00191\b\u0001\"\u00013o\")1\u0010\u0001C\u0001y\"11\u0010\u0001C\u0001\u0003GAaa\u001f\u0001\u0005\u0002\u0005\u0005\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u00033\u0003A\u0011AAN\u0011\u001d\tI\n\u0001C\u0001\u0003cCq!!'\u0001\t\u0003\t\t\rC\u0004\u0002\u001a\u0002!\t!!4\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\b\"\u0003B\u0001\u0001E\u0005I\u0011\u0001B\u0002\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqA!\u0007\u0001\t\u0013\u0011\u0019\u0004C\u0004\u0003h\u0001!IA!\u001b\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003\f\"9!Q\u0013\u0001\u0005\n\t]\u0005\u0002\u0003BU\u0001\u0011\u0005!Ga+\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!Q\u001a\u0001\u0005\u0002\t=\u0007\"\u0003Bl\u0001E\u0005I\u0011\u0001B\u0002\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057DqA!:\u0001\t\u0013\u00119\u000fC\u0004\u0003r\u0002!IAa=\t\u0011\tm\b\u0001\"\u00013\u0005{Dqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0004\u0004\u000e\u0001!\taa\u0004\t\u000f\r5\u0001\u0001\"\u0001\u0004\u001e!91Q\u0005\u0001\u0005\n\r\u001d\u0002\u0002CB\u0016\u0001\u0011\u0005!g!\f\t\u000f\rE\u0002\u0001\"\u0001\u00044!91\u0011\u0007\u0001\u0005\u0002\rm\u0002bBB-\u0001\u0011%11\f\u0005\b\u0007K\u0002A\u0011BB4\u0011\u001d\u0019i\b\u0001C\u0001\u0007\u007fBqa!#\u0001\t\u0013\u0019YiB\u0004\u0004\u0010BB\ta!%\u0007\r=\u0002\u0004\u0012ABJ\u0011\u0019qE\u0006\"\u0001\u0004\u0016\"91q\u0013\u0017\u0005\u0002\re%\u0001D\"bG\",W*\u00198bO\u0016\u0014(BA\u00193\u0003%)\u00070Z2vi&|gN\u0003\u00024i\u0005\u00191/\u001d7\u000b\u0005U2\u0014!B:qCJ\\'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001y\tC\u0005CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g\r\u0005\u0002D\r6\tAI\u0003\u0002Fi\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002H\t\n9Aj\\4hS:<\u0007CA%M\u001b\u0005Q%BA&1\u0003!\tG-\u00199uSZ,\u0017BA'K\u0005]\tE-\u00199uSZ,7\u000b]1sWBc\u0017M\u001c%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002!B\u0011\u0011\u000bA\u0007\u0002a\u0005Q1-Y2iK\u0012$\u0015\r^1\u0016\u0003Q\u00032!\u0016.]\u001b\u00051&BA,Y\u0003%IW.\\;uC\ndWM\u0003\u0002Z}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m3&AC%oI\u0016DX\rZ*fcB\u0011\u0011+X\u0005\u0003=B\u0012!bQ1dQ\u0016$G)\u0019;b\u00039\u0019\u0017m\u00195fI\u0012\u000bG/Y0%KF$\"!\u00193\u0011\u0005u\u0012\u0017BA2?\u0005\u0011)f.\u001b;\t\u000f\u0015\u001c\u0011\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\r\f7\r[3e\t\u0006$\u0018\r\t\u0015\u0003\t!\u0004\"!P5\n\u0005)t$!\u0003;sC:\u001c\u0018.\u001a8uQ\t!A\u000e\u0005\u0002>[&\u0011aN\u0010\u0002\tm>d\u0017\r^5mK\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\u0003\u0005\fq![:F[B$\u00180F\u0001t!\tiD/\u0003\u0002v}\t9!i\\8mK\u0006t\u0017\u0001\u00058v[\u000e\u000b7\r[3e\u000b:$(/[3t+\u0005A\bCA\u001fz\u0013\tQhHA\u0002J]R\f!bY1dQ\u0016\fV/\u001a:z)\t\tW\u0010C\u0003\u007f\u0011\u0001\u0007q0A\u0003rk\u0016\u0014\u0018\u0010\r\u0003\u0002\u0002\u0005E\u0001CBA\u0002\u0003\u0013\ti!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u001a\u0002\u000f\rd\u0017m]:jG&!\u00111BA\u0003\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0004\u0002\u00121\u0001AaCA\n{\u0006\u0005\t\u0011!B\u0001\u0003+\u00111a\u0018\u00132#\u0011\t9\"!\b\u0011\u0007u\nI\"C\u0002\u0002\u001cy\u0012qAT8uQ&tw\rE\u0002>\u0003?I1!!\t?\u0005\r\te.\u001f\u000b\bC\u0006\u0015\u0012\u0011GA)\u0011\u0019q\u0018\u00021\u0001\u0002(A\"\u0011\u0011FA\u0017!\u0019\t\u0019!!\u0003\u0002,A!\u0011qBA\u0017\t1\ty#!\n\u0002\u0002\u0003\u0005)\u0011AA\u000b\u0005\ryFE\r\u0005\b\u0003gI\u0001\u0019AA\u001b\u0003%!\u0018M\u00197f\u001d\u0006lW\rE\u0003>\u0003o\tY$C\u0002\u0002:y\u0012aa\u00149uS>t\u0007\u0003BA\u001f\u0003\u0017rA!a\u0010\u0002HA\u0019\u0011\u0011\t \u000e\u0005\u0005\r#bAA#u\u00051AH]8pizJ1!!\u0013?\u0003\u0019\u0001&/\u001a3fM&!\u0011QJA(\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\n \t\u000f\u0005M\u0013\u00021\u0001\u0002V\u0005a1\u000f^8sC\u001e,G*\u001a<fYB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\Q\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002`\u0005e#\u0001D*u_J\fw-\u001a'fm\u0016dG#C1\u0002d\u0005-\u00141QAC\u0011\u0019)$\u00021\u0001\u0002fA!\u00111AA4\u0013\u0011\tI'!\u0002\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f\u00055$\u00021\u0001\u0002p\u0005Y\u0001\u000f\\1o)>\u001c\u0015m\u00195f!\u0011\t\t(a \u000e\u0005\u0005M$\u0002BA;\u0003o\nq\u0001\\8hS\u000e\fGN\u0003\u0003\u0002z\u0005m\u0014!\u00029mC:\u001c(bAA?e\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002\u0002\u0006M$a\u0003'pO&\u001c\u0017\r\u001c)mC:Dq!a\r\u000b\u0001\u0004\t)\u0004C\u0004\u0002T)\u0001\r!!\u0016\u0002%\r\f7\r[3Rk\u0016\u0014\u00180\u00138uKJt\u0017\r\u001c\u000b\fC\u0006-\u0015QRAI\u0003+\u000b9\n\u0003\u00046\u0017\u0001\u0007\u0011Q\r\u0005\b\u0003\u001f[\u0001\u0019AA8\u0003A)hN\\8s[\u0006d\u0017N_3e!2\fg\u000eC\u0004\u0002\u0014.\u0001\r!a\u001c\u0002\u001d9|'/\\1mSj,G\r\u00157b]\"9\u00111G\u0006A\u0002\u0005U\u0002bBA*\u0017\u0001\u0007\u0011QK\u0001\rk:\u001c\u0017m\u00195f#V,'/\u001f\u000b\bC\u0006u\u0015\u0011VAW\u0011\u0019qH\u00021\u0001\u0002 B\"\u0011\u0011UAS!\u0019\t\u0019!!\u0003\u0002$B!\u0011qBAS\t1\t9+!(\u0002\u0002\u0003\u0005)\u0011AA\u000b\u0005\ryFe\r\u0005\u0007\u0003Wc\u0001\u0019A:\u0002\u000f\r\f7oY1eK\"1\u0011q\u0016\u0007A\u0002M\f\u0001B\u00197pG.Lgn\u001a\u000b\u0006C\u0006M\u0016q\u0018\u0005\u0007}6\u0001\r!!.1\t\u0005]\u00161\u0018\t\u0007\u0003\u0007\tI!!/\u0011\t\u0005=\u00111\u0018\u0003\r\u0003{\u000b\u0019,!A\u0001\u0002\u000b\u0005\u0011Q\u0003\u0002\u0004?\u0012\"\u0004BBAV\u001b\u0001\u00071\u000fF\u0005b\u0003\u0007\f)-!3\u0002L\"1QG\u0004a\u0001\u0003KBq!a2\u000f\u0001\u0004\ty'\u0001\u0003qY\u0006t\u0007BBAV\u001d\u0001\u00071\u000f\u0003\u0004\u00020:\u0001\ra\u001d\u000b\bC\u0006=\u0017\u0011[Aj\u0011\u0019)t\u00021\u0001\u0002f!9\u0011qY\bA\u0002\u0005=\u0004BBAV\u001f\u0001\u00071/\u0001\u000bv]\u000e\f7\r[3Rk\u0016\u0014\u00180\u00138uKJt\u0017\r\u001c\u000b\nC\u0006e\u00171\\Ao\u0003?Da!\u000e\tA\u0002\u0005\u0015\u0004bBAd!\u0001\u0007\u0011q\u000e\u0005\u0007\u0003W\u0003\u0002\u0019A:\t\r\u0005=\u0006\u00031\u0001t\u0003I)hnY1dQ\u0016$\u0016M\u00197f\u001fJ4\u0016.Z<\u0015\u0013\u0005\f)/a:\u0002~\u0006}\bBB\u001b\u0012\u0001\u0004\t)\u0007C\u0004\u0002jF\u0001\r!a;\u0002\t9\fW.\u001a\t\u0007\u0003[\f90a\u000f\u000f\t\u0005=\u00181\u001f\b\u0005\u0003\u0003\n\t0C\u0001@\u0013\r\t)PP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI0a?\u0003\u0007M+\u0017OC\u0002\u0002vzBa!a+\u0012\u0001\u0004\u0019\b\u0002CAX#A\u0005\t\u0019A:\u00029Ut7-Y2iKR\u000b'\r\\3PeZKWm\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0001\u0016\u0004g\n\u001d1F\u0001B\u0005!\u0011\u0011YA!\u0006\u000e\u0005\t5!\u0002\u0002B\b\u0005#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tMa(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0006\u0003\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)%\u001cX*\u0019;dQ\u0016$G+\u00192mK>\u0013h+[3x)%\u0019(Q\u0004B\u0010\u0005C\u0011y\u0003C\u0004\u0002HN\u0001\r!a\u001c\t\u000f\u0005%8\u00031\u0001\u0002l\"9!1E\nA\u0002\t\u0015\u0012\u0001B2p]\u001a\u0004BAa\n\u0003,5\u0011!\u0011\u0006\u0006\u0003\u000bJJAA!\f\u0003*\t91+\u0015'D_:4\u0007B\u0002B\u0019'\u0001\u00071/A\tj]\u000edW\u000fZ3US6,GK]1wK2$\u0012b\u001dB\u001b\u0005o\u0011ID!\u001a\t\u000f\u0005\u001dG\u00031\u0001\u0002p!9\u0011\u0011\u001e\u000bA\u0002\u0005-\bb\u0002B\u001e)\u0001\u0007!QH\u0001\te\u0016\u001cx\u000e\u001c<feB!!q\bB0\u001d\u0011\u0011\tEa\u0017\u000f\t\t\r#q\u000b\b\u0005\u0005\u000b\u0012)F\u0004\u0003\u0003H\tMc\u0002\u0002B%\u0005#rAAa\u0013\u0003P9!\u0011\u0011\tB'\u0013\u0005I\u0014BA\u001c9\u0013\t)d'\u0003\u00024i%\u0019\u0011Q\u0010\u001a\n\t\te\u00131P\u0001\tC:\fG._:jg&!\u0011Q\u001fB/\u0015\u0011\u0011I&a\u001f\n\t\t\u0005$1\r\u0002\t%\u0016\u001cx\u000e\u001c<fe*!\u0011Q\u001fB/\u0011\u0019\u0011\t\u0004\u0006a\u0001g\u0006Q\u0011n]*b[\u0016t\u0015-\\3\u0015\u0013M\u0014YG!\u001c\u0003\u0000\t%\u0005bBAu+\u0001\u0007\u00111\u001e\u0005\b\u0005_*\u0002\u0019\u0001B9\u0003\u001d\u0019\u0017\r^1m_\u001e\u0004BAa\u001d\u0003|5\u0011!Q\u000f\u0006\u0005\u0005_\u00129HC\u0002\u0003zI\n\u0011bY8o]\u0016\u001cGo\u001c:\n\t\tu$Q\u000f\u0002\u000e\u0007\u0006$\u0018\r\\8h!2,x-\u001b8\t\u000f\t\u0005U\u00031\u0001\u0003\u0004\u0006)\u0011\u000eZ3oiB!!1\u000fBC\u0013\u0011\u00119I!\u001e\u0003\u0015%#WM\u001c;jM&,'\u000fC\u0004\u0003<U\u0001\rA!\u0010\u0015\u000fM\u0014iIa$\u0003\u0014\"9\u0011\u0011\u001e\fA\u0002\u0005-\bb\u0002BI-\u0001\u0007\u00111^\u0001\f]\u0006lW-\u00138DC\u000eDW\rC\u0004\u0003<Y\u0001\rA!\u0010\u0002%Ut7-Y2iK\nK8i\u001c8eSRLwN\u001c\u000b\nC\ne%1\u0014BS\u0005OCa!N\fA\u0002\u0005\u0015\u0004b\u0002BO/\u0001\u0007!qT\u0001\u000eSNl\u0015\r^2iK\u0012\u0004F.\u00198\u0011\ru\u0012\t+a\u001ct\u0013\r\u0011\u0019K\u0010\u0002\n\rVt7\r^5p]FBa!a+\u0018\u0001\u0004\u0019\bBBAX/\u0001\u00071/A\fb]\u0006d\u0017P_3D_2,XN\\\"bG\",\u0017+^3ssR9\u0011M!,\u00032\nM\u0006b\u0002BX1\u0001\u0007\u0011QM\u0001\rgB\f'o[*fgNLwN\u001c\u0005\u0006%b\u0001\r\u0001\u0018\u0005\b\u0005kC\u0002\u0019\u0001B\\\u0003\u0019\u0019w\u000e\\;n]B1\u0011Q^A|\u0005s\u0003BAa/\u0003B6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u000bY(A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002Bb\u0005{\u0013\u0011\"\u0011;ue&\u0014W\u000f^3\u0002\u001bI,7-Y2iK\nK\b\u000b\\1o)\u0015\t'\u0011\u001aBf\u0011\u0019)\u0014\u00041\u0001\u0002f!9\u0011qY\rA\u0002\u0005=\u0014A\u0005:fG\u0006\u001c\u0007.\u001a+bE2,wJ\u001d,jK^$r!\u0019Bi\u0005'\u0014)\u000e\u0003\u000465\u0001\u0007\u0011Q\r\u0005\b\u0003ST\u0002\u0019AAv\u0011!\u0011\tD\u0007I\u0001\u0002\u0004\u0019\u0018\u0001\b:fG\u0006\u001c\u0007.\u001a+bE2,wJ\u001d,jK^$C-\u001a4bk2$HeM\u0001\u0013e\u0016\u001c\u0017m\u00195f\u0005f\u001cuN\u001c3ji&|g\u000eF\u0003b\u0005;\u0014y\u000e\u0003\u000469\u0001\u0007\u0011Q\r\u0005\b\u0005Cd\u0002\u0019\u0001Br\u0003%\u0019wN\u001c3ji&|g\u000eE\u0003>\u0005Cc6/\u0001\u000buef\u0014VMY;jY\u0012\u001c\u0015m\u00195f\u000b:$(/\u001f\u000b\u0007\u0005S\u0014YO!<\u0011\tu\n9\u0004\u0018\u0005\u0007ku\u0001\r!!\u001a\t\r\t=X\u00041\u0001]\u0003\t\u0019G-\u0001\buef\u0014VM\u001a:fg\"\u0004F.\u00198\u0015\r\tU(q\u001fB}!\u0015i\u0014qGA8\u0011\u0019)d\u00041\u0001\u0002f!9\u0011q\u0019\u0010A\u0002\u0005=\u0014!\u00057p_.,\boQ1dQ\u0016$G+\u00192mKR1!Q\u001fB\u0000\u0007\u0003Aq!!; \u0001\u0004\tY\u000fC\u0004\u0003<}\u0001\rA!\u0010\u0002'\u0019Lg\u000eZ\"bG\",GMU3mCRLwN\\:\u0015\r\r\u001d1\u0011BB\u0006!\u0019\ti/a>\u0002p!9\u0011\u0011\u001e\u0011A\u0002\u0005-\bb\u0002B\u001eA\u0001\u0007!QH\u0001\u0011Y>|7.\u001e9DC\u000eDW\r\u001a#bi\u0006$BA!;\u0004\u0012!1a0\ta\u0001\u0007'\u0001Da!\u0006\u0004\u001aA1\u00111AA\u0005\u0007/\u0001B!a\u0004\u0004\u001a\u0011a11DB\t\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\t\u0019q\fJ\u001b\u0015\r\t%8qDB\u0012\u0011\u001d\u0019\tC\ta\u0001\u0003K\nqa]3tg&|g\u000eC\u0004\u0002H\n\u0002\r!a\u001c\u000211|wn[;q\u0007\u0006\u001c\u0007.\u001a3ECR\f\u0017J\u001c;fe:\fG\u000e\u0006\u0003\u0003j\u000e%\u0002bBAdG\u0001\u0007\u0011qN\u0001\u000ekN,7)Y2iK\u0012$\u0015\r^1\u0015\t\u0005=4q\u0006\u0005\b\u0003\u000f$\u0003\u0019AA8\u00035\u0011XmY1dQ\u0016\u0014\u0015\u0010U1uQR)\u0011m!\u000e\u00048!1Q'\na\u0001\u0003KBqa!\u000f&\u0001\u0004\tY$\u0001\u0007sKN|WO]2f!\u0006$\b\u000eF\u0004b\u0007{\u0019yd!\u0015\t\rU2\u0003\u0019AA3\u0011\u001d\u0019ID\na\u0001\u0007\u0003\u0002Baa\u0011\u0004N5\u00111Q\t\u0006\u0005\u0007\u000f\u001aI%\u0001\u0002gg*\u001911\n\u001c\u0002\r!\fGm\\8q\u0013\u0011\u0019ye!\u0012\u0003\tA\u000bG\u000f\u001b\u0005\b\u0007\u000f2\u0003\u0019AB*!\u0011\u0019\u0019e!\u0016\n\t\r]3Q\t\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00057p_.,\b/\u00118e%\u00164'/Z:i)\u001d\u00198QLB0\u0007CBq!a2(\u0001\u0004\ty\u0007C\u0004\u0004H\u001d\u0002\raa\u0015\t\u000f\r\rt\u00051\u0001\u0004B\u0005i\u0011/^1mS\u001aLW\r\u001a)bi\"\f1D]3ge\u0016\u001c\bNR5mK&sG-\u001a=JM:+7-Z:tCJLHcB:\u0004j\re41\u0010\u0005\b\u0007WB\u0003\u0019AB7\u0003%1\u0017\u000e\\3J]\u0012,\u0007\u0010\u0005\u0003\u0004p\rUTBAB9\u0015\r\u0019\u0019\bM\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0004x\rE$!\u0003$jY\u0016Le\u000eZ3y\u0011\u001d\u00199\u0005\u000ba\u0001\u0007'Bqaa\u0019)\u0001\u0004\u0019\t%\u0001\u0005jgN+(\rR5s)\u0015\u00198\u0011QBC\u0011\u001d\u0019\u0019)\u000ba\u0001\u0007\u0003\n1#];bY&4\u0017.\u001a3QCRD\u0007+\u0019:f]RDqaa\"*\u0001\u0004\u0019\t%\u0001\nrk\u0006d\u0017NZ5fIB\u000bG\u000f[\"iS2$\u0017aH4fi>\u00138\t\\8oKN+7o]5p]^KG\u000f[\"p]\u001aLwm](gMR!\u0011QMBG\u0011\u001d\u0019\tC\u000ba\u0001\u0003K\nAbQ1dQ\u0016l\u0015M\\1hKJ\u0004\"!\u0015\u0017\u0014\u00071b$\t\u0006\u0002\u0004\u0012\u0006\tBn\\4DC\u000eDWm\u00149fe\u0006$\u0018n\u001c8\u0015\u0007\u0005\u001cY\n\u0003\u0005\u0004\u001e:\"\t\u0019ABP\u0003\u00051\u0007#B\u001f\u0004\"\u000e\u0015\u0016bABR}\tAAHY=oC6,g\bE\u0002D\u0007OK1a!+E\u0005IiUm]:bO\u0016<\u0016\u000e\u001e5D_:$X\r\u001f;")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void logCacheOperation(Function0<MessageWithContext> f) {
        CacheManager$.MODULE$.logCacheOperation(f);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$)));
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cleared all Dataframe cache entries"}))).log((Seq)Nil$.MODULE$));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public int numCachedEntries() {
        return this.cachedData().size();
    }

    public void cacheQuery(Dataset<?> query) {
        this.cacheQuery(query, (Option<String>)None$.MODULE$, StorageLevel$.MODULE$.MEMORY_AND_DISK());
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        this.cacheQueryInternal(query.sparkSession(), query.queryExecution().analyzed(), query.queryExecution().normalized(), tableName, storageLevel);
    }

    public void cacheQuery(SparkSession spark, LogicalPlan planToCache, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, planToCache, QueryExecution$.MODULE$.normalize$default$3());
        this.cacheQueryInternal(spark, planToCache, normalized, tableName, storageLevel);
    }

    private void cacheQueryInternal(SparkSession spark, LogicalPlan unnormalizedPlan, LogicalPlan normalizedPlan, Option<String> tableName, StorageLevel storageLevel) {
        StorageLevel storageLevel2 = storageLevel;
        StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null)) {
            return;
        }
        if (unnormalizedPlan instanceof IgnoreCachedData) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Asked to cache a plan that is inapplicable for caching: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.LOGICAL_PLAN, unnormalizedPlan)})))));
            return;
        }
        if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Asked to cache already cached data.");
            return;
        }
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        InMemoryRelation inMemoryRelation = (InMemoryRelation)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> {
            QueryExecution qe = sessionWithConfigsOff.sessionState().executePlan(unnormalizedPlan, sessionWithConfigsOff.sessionState().executePlan$default$2());
            return InMemoryRelation$.MODULE$.apply(storageLevel, qe, tableName);
        });
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            if (this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalizedPlan).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Data has already been cached.");
            } else {
                CachedData cd;
                CachedData cachedData = cd = new CachedData(normalizedPlan, inMemoryRelation);
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Added Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, cd)}))));
            }
        }
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade, boolean blocking) {
        this.uncacheQueryInternal(query.sparkSession(), query.queryExecution().normalized(), cascade, blocking);
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query, cascade, false);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.uncacheQueryInternal(spark, normalized, cascade, blocking);
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade) {
        this.uncacheQuery(spark, plan, cascade, false);
    }

    private void uncacheQueryInternal(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.sameResult((QueryPlan)plan)), cascade, blocking);
    }

    public void uncacheTableOrView(SparkSession spark, Seq<String> name, boolean cascade, boolean blocking) {
        this.uncacheByCondition(spark, (Function1<LogicalPlan, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$3, (Seq<String>)name, spark.sessionState().conf(), true)), cascade, blocking);
    }

    public boolean uncacheTableOrView$default$4() {
        return false;
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, SQLConf conf, boolean includeTimeTravel) {
        return this.isMatchedTableOrView(plan, name, (Function2<String, String, Object>)conf.resolver(), includeTimeTravel);
    }

    private boolean isMatchedTableOrView(LogicalPlan plan, Seq<String> name, Function2<String, String, Object> resolver, boolean includeTimeTravel) {
        Option option;
        LogicalRelation logicalRelation;
        Option<Tuple2<BaseRelation, Option<CatalogTable>>> option2;
        LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(plan);
        if (logicalPlan2 instanceof LogicalRelation && !(option2 = LogicalRelationWithTable$.MODULE$.unapply(logicalRelation = (LogicalRelation)logicalPlan2)).isEmpty() && (option = (Option)((Tuple2)option2.get())._2()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable catalogTable = (CatalogTable)some.value();
            return this.isSameName(name, (Seq<String>)catalogTable.identifier().nameParts(), resolver);
        }
        if (logicalPlan2 instanceof DataSourceV2Relation) {
            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2;
            Option option3 = dataSourceV2Relation.catalog();
            Option option4 = dataSourceV2Relation.identifier();
            Option timeTravelSpec = dataSourceV2Relation.timeTravelSpec();
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                CatalogPlugin catalog = (CatalogPlugin)some.value();
                if (option4 instanceof Some) {
                    Some some2 = (Some)option4;
                    Identifier v2Ident = (Identifier)some2.value();
                    Seq nameInCache = CatalogV2Implicits$.MODULE$.IdentifierHelper(v2Ident).toQualifiedNameParts(catalog);
                    return this.isSameName(name, (Seq<String>)nameInCache, resolver) && (includeTimeTravel || timeTravelSpec.isEmpty());
                }
            }
        }
        if (logicalPlan2 instanceof V2TableReference) {
            V2TableReference v2TableReference = (V2TableReference)logicalPlan2;
            return this.isSameName(name, (Seq<String>)CatalogV2Implicits$.MODULE$.IdentifierHelper(v2TableReference.identifier()).toQualifiedNameParts((CatalogPlugin)v2TableReference.catalog()), resolver);
        }
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            return this.isSameName(name, (Seq<String>)view.desc().identifier().nameParts(), resolver);
        }
        if (logicalPlan2 instanceof HiveTableRelation) {
            HiveTableRelation hiveTableRelation = (HiveTableRelation)logicalPlan2;
            CatalogTable catalogTable = hiveTableRelation.tableMeta();
            return this.isSameName(name, (Seq<String>)catalogTable.identifier().nameParts(), resolver);
        }
        return false;
    }

    private boolean isSameName(Seq<String> name, CatalogPlugin catalog, Identifier ident, Function2<String, String, Object> resolver) {
        return this.isSameName(name, (Seq<String>)CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).toQualifiedNameParts(catalog), resolver);
    }

    private boolean isSameName(Seq<String> name, Seq<String> nameInCache, Function2<String, String, Object> resolver) {
        return nameInCache.length() == name.length() && ((IterableOnceOps)nameInCache.zip(name)).forall(resolver.tupled());
    }

    private void uncacheByCondition(SparkSession spark, Function1<LogicalPlan, Object> isMatchedPlan, boolean cascade, boolean blocking) {
        Function1 & Serializable shouldRemove = cascade ? (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.exists(isMatchedPlan)) : isMatchedPlan;
        IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$2(shouldRemove, cd)));
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$4(cd, x$5)))))));
        }
        plansToUncache.foreach((Function1 & Serializable)x$6 -> {
            CacheManager.$anonfun$uncacheByCondition$5(blocking, x$6);
            return BoxedUnit.UNIT;
        });
        CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " Dataframe "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SIZE, BoxesRunTime.boxToInteger((int)plansToUncache.size()))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cache entries, with logical plans being "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, ((IterableOnceOps)plansToUncache.map((Function1 & Serializable)x$7 -> x$7.plan())).mkString(",\n"))}))));
        if (!cascade) {
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheByCondition$8(isMatchedPlan, cd)));
            return;
        }
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, scala.collection.immutable.Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        scala.collection.immutable.Map newColStats = (scala.collection.immutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        long rowCount2 = tuple22._1$mcJ$sp();
        scala.collection.immutable.Map newColStats2 = (scala.collection.immutable.Map)tuple22._2();
        relation.updateStats(rowCount2, (scala.collection.immutable.Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(spark, plan, QueryExecution$.MODULE$.normalize$default$3());
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(normalized, x$9)));
    }

    public void recacheTableOrView(SparkSession spark, Seq<String> name, boolean includeTimeTravel) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)this.shouldInvalidate$1(entry, name, spark, includeTimeTravel)));
    }

    public boolean recacheTableOrView$default$3() {
        return true;
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.foreach((Function1 & Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    private Option<CachedData> tryRebuildCacheEntry(SparkSession spark, CachedData cd) {
        SparkSession sessionWithConfigsOff = this.getOrCloneSessionWithConfigsOff(spark);
        return (Option)sessionWithConfigsOff.withActive((Function0 & Serializable)() -> this.tryRefreshPlan(sessionWithConfigsOff, cd.plan()).map((Function1 & Serializable)refreshedPlan -> {
            QueryExecution qe = QueryExecution$.MODULE$.create(sessionWithConfigsOff, (LogicalPlan)refreshedPlan, false);
            LogicalPlan newKey = qe.normalized();
            InMemoryRelation newCache = InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder(), qe);
            return cd.copy(newKey, newCache);
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<LogicalPlan> tryRefreshPlan(SparkSession spark, LogicalPlan plan) {
        Some some;
        try {
            DataSourceV2Relation dataSourceV2Relation;
            Option option;
            LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(plan);
            if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty()) {
                TableCatalog catalog = (TableCatalog)((Tuple2)option.get())._1();
                Identifier ident = (Identifier)((Tuple2)option.get())._2();
                if (dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                    Table table = catalog.loadTable(ident);
                    String string = dataSourceV2Relation.table().id();
                    String string2 = table.id();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        some = new Some((Object)DataSourceV2Relation$.MODULE$.create(table, (Option)new Some((Object)catalog), (Option)new Some((Object)ident)));
                        return some;
                    }
                    some = None$.MODULE$;
                    return some;
                }
            }
            some = new Some((Object)V2TableRefreshUtil$.MODULE$.refresh(spark, plan, V2TableRefreshUtil$.MODULE$.refresh$default$3()));
            return some;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 == null) throw throwable;
            Throwable throwable3 = throwable2;
            if (!NonFatal$.MODULE$.apply(throwable3)) throw throwable;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to refresh plan while attempting to recache"}))).log((Seq)Nil$.MODULE$)), throwable3);
            some = None$.MODULE$;
            return some;
        }
    }

    public Option<LogicalPlan> lookupCachedTable(Seq<String> name, Function2<String, String, Object> resolver) {
        Option option;
        Seq<LogicalPlan> cachedRelations = this.findCachedRelations(name, resolver);
        Seq<LogicalPlan> seq = cachedRelations;
        if (seq != null && !(option = scala.package$.MODULE$.$plus$colon().unapply(seq)).isEmpty()) {
            LogicalPlan cachedRelation = (LogicalPlan)((Tuple2)option.get())._1();
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Relation cache hit for table ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TABLE_NAME, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(name).quoted())})));
            return new Some((Object)cachedRelation);
        }
        return None$.MODULE$;
    }

    private Seq<LogicalPlan> findCachedRelations(Seq<String> name, Function2<String, String, Object> resolver) {
        return (Seq)this.cachedData().flatMap((Function1 & Serializable)cd -> {
            Identifier ident;
            TableCatalog catalog;
            DataSourceV2Relation dataSourceV2Relation;
            Option option;
            LogicalPlan plan = EliminateSubqueryAliases$.MODULE$.apply(cd.plan());
            LogicalPlan logicalPlan2 = plan;
            if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2CatalogAndIdentifier$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty() && this.isSameName(name, (CatalogPlugin)(catalog = (TableCatalog)((Tuple2)option.get())._1()), ident = (Identifier)((Tuple2)option.get())._2(), resolver) && dataSourceV2Relation.timeTravelSpec().isEmpty()) {
                return new Some((Object)dataSourceV2Relation);
            }
            return None$.MODULE$;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(query.queryExecution().normalized());
    }

    public Option<CachedData> lookupCachedData(SparkSession session, LogicalPlan plan) {
        LogicalPlan normalized = QueryExecution$.MODULE$.normalize(session, plan, QueryExecution$.MODULE$.normalize$default$3());
        return this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(normalized);
    }

    public Option<CachedData> org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(LogicalPlan plan) {
        Option result;
        block0: {
            result = this.cachedData().find((Function1 & Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
            if (!result.isDefined()) break block0;
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit for input plan:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\n", " matched with cache entry:"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, result.get())}))));
        }
        return result;
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = (LogicalPlan)plan.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof IgnoreCachedData) {
                    IgnoreCachedData ignoreCachedData = (IgnoreCachedData)A1;
                    return (B1)ignoreCachedData;
                }
                return (B1)this.$outer.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(A1).map((Function1 & Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)cachedPlan, (Function2 & Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 != null) {
                            HintInfo hint = (HintInfo)tuple2._1();
                            LogicalPlan p = (LogicalPlan)tuple2._2();
                            return new ResolvedHint(p, hint);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }).getOrElse((Function0 & Serializable)() -> A1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                if (logicalPlan2 instanceof IgnoreCachedData) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        LogicalPlan result = newPlan.transformAllExpressionsWithPruning((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())), newPlan.transformAllExpressionsWithPruning$default$2(), (PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    return (B1)subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                return expression instanceof SubqueryExpression;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (result.fastEquals((TreeNode)plan)) {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache miss for input plan:\\n", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN, plan)})));
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Last 20 Dataframe cache entry logical plans:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, ((IterableOnceOps)((IndexedSeqOps)this.cachedData().take(20)).map((Function1 & Serializable)x$14 -> x$14.plan())).mkString(",\n"))}))));
        } else {
            CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dataframe cache hit plan change summary:\\n"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.QUERY_PLAN_COMPARISON, package$.MODULE$.sideBySide(plan.treeString(), result.treeString()).mkString("\n"))}))));
        }
        return result;
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$15)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        Table fileTable;
        DataSourceV2Relation dataSourceV2Relation;
        Option option;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                return this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            }
            return false;
        }
        if (logicalPlan2 instanceof DataSourceV2Relation && !(option = ExtractV2Table$.MODULE$.unapply(dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2)).isEmpty() && (fileTable = (Table)option.get()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            return this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        }
        return false;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            needToRefresh = ((IterableOnceOps)fileIndex.rootPaths().map((Function1 & Serializable)x$17 -> x$17.makeQualified(fs.getUri(), fs.getWorkingDirectory()))).exists((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)this.isSubDir(qualifiedPath, x$18)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public boolean isSubDir(Path qualifiedPathParent, Path qualifiedPathChild) {
        return scala.package$.MODULE$.Iterator().iterate((Object)qualifiedPathChild, (Function1 & Serializable)x$19 -> x$19.getParent()).takeWhile((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$isSubDir$2(x$20))).exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.equals((Object)qualifiedPathParent)));
    }

    private SparkSession getOrCloneSessionWithConfigsOff(SparkSession session) {
        .colon.colon disableConfigs;
        block0: {
            disableConfigs = new .colon.colon((Object)SQLConf$.MODULE$.AUTO_BUCKETED_SCAN_ENABLED(), (List)Nil$.MODULE$);
            if (BoxesRunTime.unboxToBoolean((Object)session.sessionState().conf().getConf(SQLConf$.MODULE$.CAN_CHANGE_CACHED_PLAN_OUTPUT_PARTITIONING()))) break block0;
            disableConfigs = (Seq)disableConfigs.$colon$plus((Object)SQLConf$.MODULE$.ADAPTIVE_EXECUTION_APPLY_FINAL_STAGE_SHUFFLE_OPTIMIZATIONS());
        }
        return SparkSession$.MODULE$.getOrCloneSessionWithConfigsOff(session, (Seq<ConfigEntry<Object>>)disableConfigs);
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$2(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$4(CachedData cd$2, CachedData x$5) {
        return x$5 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$uncacheByCondition$5(boolean blocking$1, CachedData x$6) {
        x$6.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheByCondition$8(Function1 isMatchedPlan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().exists(isMatchedPlan$1) && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan normalized$1, CachedData x$9) {
        return x$9.plan().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.sameResult((QueryPlan)normalized$1)));
    }

    private final boolean shouldInvalidate$1(CachedData entry, Seq name$2, SparkSession spark$2, boolean includeTimeTravel$1) {
        return entry.plan().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)this.isMatchedTableOrView(x$11, (Seq<String>)name$2, spark$2.sessionState().conf(), includeTimeTravel$1)));
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$3, CachedData x$12) {
        return x$12 == cd$3;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$4(CacheManager $this, CachedData entry) {
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.org$apache$spark$sql$execution$CacheManager$$lookupCachedDataInternal(entry.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = entry;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData)));
                CacheManager$.MODULE$.logCacheOperation((Function0<MessageWithContext>)(Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Re-cached Dataframe cache entry:"}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.MDC((LogKey)LogKeys.DATAFRAME_CACHE_ENTRY, entry)}))));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$3, CachedData cd) {
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        $this.tryRebuildCacheEntry(spark$3, cd).foreach((Function1 & Serializable)entry -> {
            CacheManager.$anonfun$recacheByCondition$4($this, entry);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$15) {
        return x$15.plan().exists((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$16, fs$1, qualifiedPath$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isSubDir$2(Path x$20) {
        return x$20 != null;
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Nil$.MODULE$);
    }
}

