/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.variant;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExplodeGeneratorBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="_FUNC_(expr) - It separates a variant object/array into multiple rows containing its fields/elements. Its result schema is `struct<pos int, key string, value variant>`. `pos` is the position of the field/element in its parent object/array, and `value` is the field/element value. `key` is the field name when exploding a variant object, or is NULL when exploding a variant array. It ignores any input that is not a variant array/object, including SQL NULL, variant null, and any other variant values.", examples="\n    Examples:\n      > SELECT * from _FUNC_(parse_json('[\"hello\", \"world\"]'));\n       0\tNULL\t\"hello\"\n       1\tNULL\t\"world\"\n      > SELECT * from _FUNC_(input => parse_json('{\"a\": true, \"b\": 3.14}'));\n       0\ta\ttrue\n       1\tb\t3.14\n  ", since="4.0.0", group="variant_funcs")
@ScalaSignature(bytes="\u0006\u0005i:Q\u0001B\u0003\t\u0002Q1QAF\u0003\t\u0002]AQ!I\u0001\u0005\u0002\tBQaI\u0001\u0005B\u0011\naDV1sS\u0006tG/\u0012=qY>$WmR3oKJ\fGo\u001c:Ck&dG-\u001a:\u000b\u0005\u00199\u0011a\u0002<be&\fg\u000e\u001e\u0006\u0003\u0011%\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011!bC\u0001\tG\u0006$\u0018\r\\=ti*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001A\u0011Q#A\u0007\u0002\u000b\tqb+\u0019:jC:$X\t\u001f9m_\u0012,w)\u001a8fe\u0006$xN\u001d\"vS2$WM]\n\u0004\u0003aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002\u0016?%\u0011\u0001%\u0002\u0002#-\u0006\u0014\u0018.\u00198u\u000bb\u0004Hn\u001c3f\u000f\u0016tWM]1u_J\u0014U/\u001b7eKJ\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005!\u0012aB5t\u001fV$XM]\u000b\u0002KA\u0011\u0011DJ\u0005\u0003Oi\u0011qAQ8pY\u0016\fg\u000e\u000b\u0006\u0002S5r\u0003'M\u001a5m]\u0002\"AK\u0016\u000e\u0003\u001dI!\u0001L\u0004\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\nq&ABu?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.A%#\be]3qCJ\fG/Z:!C\u00022\u0018M]5b]R\u0004sN\u00196fGR|\u0013M\u001d:bs\u0002Jg\u000e^8![VdG/\u001b9mK\u0002\u0012xn^:!G>tG/Y5oS:<\u0007%\u001b;tA\u0019LW\r\u001c3t_\u0015dW-\\3oiNt\u0003%\u0013;tAI,7/\u001e7uAM\u001c\u0007.Z7bA%\u001c\b\u0005Y:ueV\u001cG\u000f\u00109pg\u0002Jg\u000e\u001e\u0017!W\u0016L\be\u001d;sS:<G\u0006\t<bYV,\u0007E^1sS\u0006tGO\u00101/A\u0001\u0004xn\u001d1!SN\u0004C\u000f[3!a>\u001c\u0018\u000e^5p]\u0002zg\r\t;iK\u00022\u0017.\u001a7e_\u0015dW-\\3oi\u0002Jg\u000eI5ug\u0002\u0002\u0018M]3oi\u0002z'M[3di>\n'O]1zY\u0001\ng\u000e\u001a\u0011am\u0006dW/\u001a1!SN\u0004C\u000f[3!M&,G\u000eZ\u0018fY\u0016lWM\u001c;!m\u0006dW/\u001a\u0018!A.,\u0017\u0010\u0019\u0011jg\u0002\"\b.\u001a\u0011gS\u0016dG\r\t8b[\u0016\u0004s\u000f[3oA\u0015D\b\u000f\\8eS:<\u0007%\u0019\u0011wCJL\u0017M\u001c;!_\nTWm\u0019;-A=\u0014\b%[:!\u001dVcE\nI<iK:\u0004S\r\u001f9m_\u0012Lgn\u001a\u0011bAY\f'/[1oi\u0002\n'O]1z]\u0001JE\u000fI5h]>\u0014Xm\u001d\u0011b]f\u0004\u0013N\u001c9vi\u0002\"\b.\u0019;!SN\u0004cn\u001c;!C\u00022\u0018M]5b]R\u0004\u0013M\u001d:bs>z'M[3di2\u0002\u0013N\\2mk\u0012Lgn\u001a\u0011T#2\u0003c*\u0016'MY\u00012\u0018M]5b]R\u0004c.\u001e7mY\u0001\ng\u000e\u001a\u0011b]f\u0004s\u000e\u001e5fe\u00022\u0018M]5b]R\u0004c/\u00197vKNt\u0013\u0001C3yC6\u0004H.Z:\"\u0003I\n\u0011Q\u001b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!U\u00012'o\\7!?\u001a+fjQ0)a\u0006\u00148/Z0kg>t\u0007fJ.#Q\u0016dGn\u001c\u0012-A\t:xN\u001d7eEu;\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!a%qU\u000b\u0014'\nE!,G\u000e\\8#\u0015\u0001\u0002\u0003\u0005\t\u0011!AEJa*\u0016'M\u0013\t:xN\u001d7eE)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0006\t4s_6\u0004sLR+O\u0007~C\u0013N\u001c9vi\u0002jd\b\t9beN,wL[:p]\":3PI1#u\u0001\"(/^3-A\t\u0012'E\u000f\u00114]E\"TpJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0014\"Y\u0005ueV,'\u0002\t\u0011!A\u0001\u0002\u0003%M\u0005c\u0013Mr\u0013\u0007\u000e\u0006!A\u0005)1/\u001b8dK\u0006\nQ'A\u00035]Ar\u0003'A\u0003he>,\b/I\u00019\u000351\u0018M]5b]R|f-\u001e8dg\"R\u0001!K\u0017/aE\u001aDGN\u001c")
public final class VariantExplodeGeneratorBuilder {
    public static boolean isOuter() {
        return VariantExplodeGeneratorBuilder$.MODULE$.isOuter();
    }

    public static Generator buildGenerator(String funcName, Seq<Expression> expressions) {
        return VariantExplodeGeneratorBuilder$.MODULE$.buildGenerator(funcName, expressions);
    }

    public static Option<FunctionSignature> functionSignature() {
        return VariantExplodeGeneratorBuilder$.MODULE$.functionSignature();
    }

    public static LogicalPlan build(String funcName, Seq<Expression> expressions) {
        return VariantExplodeGeneratorBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return VariantExplodeGeneratorBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return VariantExplodeGeneratorBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }
}

