/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnDictionary;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tuuA\u0002\u001e<\u0011\u0003k\u0014J\u0002\u0004Lw!\u0005U\b\u0014\u0005\u0006M\u0006!\ta\u001a\u0005\bQ\u0006\u0011\r\u0011\"\u0011j\u0011\u0019i\u0017\u0001)A\u0005U\"9a.\u0001b\u0001\n\u0003y\u0007BB:\u0002A\u0003%\u0001\u000fC\u0003u\u0003\u0011\u0005S\u000fC\u0004\u0002B\u0006!\t%a1\t\u000f\t-\u0013\u0001\"\u0011\u0003N\u00191\u0011\u0011Z\u0001\u0001\u0003\u0017D!\"a\f\u000b\u0005\u0003\u0005\u000b\u0011BAl\u0011\u00191'\u0002\"\u0001\u0002Z\"A\u0011q\u001c\u0006A\u0002\u0013%\u0011\u000eC\u0005\u0002b*\u0001\r\u0011\"\u0003\u0002d\"9\u0011q\u001d\u0006!B\u0013Q\u0007\"CAu\u0015\u0001\u0007I\u0011BAL\u0011%\tYO\u0003a\u0001\n\u0013\ti\u000f\u0003\u0005\u0002r*\u0001\u000b\u0015BAM\u0011!\t\u0019P\u0003a\u0001\n\u0013I\u0007\"CA{\u0015\u0001\u0007I\u0011BA|\u0011\u001d\tYP\u0003Q!\n)D\u0011\"!@\u000b\u0005\u0004%I!a@\t\u0011\t]!\u0002)A\u0005\u0005\u0003A\u0011\"!\u0012\u000b\u0005\u0004%IA!\u0007\t\u0011\u0005U#\u0002)A\u0005\u00057A\u0001B!\t\u000b\u0001\u0004%I!\u001b\u0005\n\u0005GQ\u0001\u0019!C\u0005\u0005KAqA!\u000b\u000bA\u0003&!\u000eC\u0004\u0003,)!\tE!\f\t\u000f\tM\"\u0002\"\u0011\u00036!1!q\b\u0006\u0005B%DaA!\u0011\u000b\t\u0003Jg\u0001B=\u0002\u0001iD!\"!\b\"\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\ty#\tB\u0001B\u0003%\u0011\u0011\u0007\u0005\u0007M\u0006\"\t!!\u000f\t\u0011\u0005\u0005\u0013E1A\u0005\u0002%Dq!a\u0011\"A\u0003%!\u000eC\u0005\u0002F\u0005\u0012\r\u0011\"\u0003\u0002H!A\u0011QK\u0011!\u0002\u0013\tI\u0005C\u0005\u0002X\u0005\u0002\r\u0011\"\u0003\u0002Z!I\u0011QL\u0011A\u0002\u0013%\u0011q\f\u0005\t\u0003W\n\u0003\u0015)\u0003\u0002\\!I\u0011QN\u0011A\u0002\u0013%\u0011q\u000e\u0005\n\u0003s\n\u0003\u0019!C\u0005\u0003wB\u0001\"a \"A\u0003&\u0011\u0011\u000f\u0005\b\u0003\u0003\u000bC\u0011IAB\u0011\u001d\t)*\tC!\u0003/Cq!a(\"\t\u0003\n\t\u000bC\u0005\u0003b\u0005\t\t\u0011\"\u0011\u0003d!A!\u0011O\u0001\u0002\u0002\u0013\u0005\u0011\u000eC\u0005\u0003t\u0005\t\t\u0011\"\u0001\u0003v!I!\u0011P\u0001\u0002\u0002\u0013\u0005#1\u0010\u0005\n\u0005\u000b\u000b\u0011\u0011!C\u0001\u0005\u000fC\u0011Ba#\u0002\u0003\u0003%\tE!$\t\u0013\t=\u0015!!A\u0005B\tE\u0005\"\u0003BJ\u0003\u0005\u0005I\u0011\u0002BK\u0003I!\u0015n\u0019;j_:\f'/_#oG>$\u0017N\\4\u000b\u0005qj\u0014aC2p[B\u0014Xm]:j_:T!AP \u0002\u0011\r|G.^7oCJT!\u0001Q!\u0002\u0013\u0015DXmY;uS>t'B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\t\u0016\u000bQa\u001d9be.T!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sOB\u0011!*A\u0007\u0002w\t\u0011B)[2uS>t\u0017M]=F]\u000e|G-\u001b8h'\u0015\tQj\u0015,Z!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011!\nV\u0005\u0003+n\u0012\u0011cQ8naJ,7o]5p]N\u001b\u0007.Z7f!\tqu+\u0003\u0002Y\u001f\n9\u0001K]8ek\u000e$\bC\u0001.d\u001d\tY\u0016M\u0004\u0002]A6\tQL\u0003\u0002_?\u00061AH]8piz\u001a\u0001!C\u0001Q\u0013\t\u0011w*A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'\u0001D*fe&\fG.\u001b>bE2,'B\u00012P\u0003\u0019a\u0014N\\5u}Q\t\u0011*\u0001\u0004usB,\u0017\nZ\u000b\u0002UB\u0011aj[\u0005\u0003Y>\u00131!\u00138u\u0003\u001d!\u0018\u0010]3JI\u0002\nQ\"T!Y?\u0012K5\tV0T\u0013j+U#\u00019\u0011\u00059\u000b\u0018B\u0001:P\u0005\u0015\u0019\u0006n\u001c:u\u00039i\u0015\tW0E\u0013\u000e#vlU%[\u000b\u0002\nq\u0001Z3d_\u0012,'/F\u0002w\u0003s#Ra^A^\u0003{\u0003B\u0001_\u0011\u000286\t\u0011AA\u0004EK\u000e|G-\u001a:\u0016\u0007m\f\taE\u0002\"\u001br\u00042AS?\u007f\u0013\tI8\bE\u0002\u0000\u0003\u0003a\u0001\u0001B\u0004\u0002\u0004\u0005\u0012\r!!\u0002\u0003\u0003Q\u000bB!a\u0002\u0002\u000eA\u0019a*!\u0003\n\u0007\u0005-qJA\u0004O_RD\u0017N\\4\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005)A/\u001f9fg*\u0019\u0011qC!\u0002\u0011\r\fG/\u00197zgRLA!a\u0007\u0002\u0012\t\u0001\u0002\u000b[=tS\u000e\fG\u000eR1uCRK\b/Z\u0001\u0007EV4g-\u001a:\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005\u0019a.[8\u000b\u0005\u0005%\u0012\u0001\u00026bm\u0006LA!!\f\u0002$\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0015\r|G.^7o)f\u0004X\rE\u0003\u00024\u0005Ub0D\u0001>\u0013\r\t9$\u0010\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016$b!a\u000f\u0002>\u0005}\u0002c\u0001=\"}\"9\u0011Q\u0004\u0013A\u0002\u0005}\u0001bBA\u0018I\u0001\u0007\u0011\u0011G\u0001\u000bK2,W.\u001a8u\u001dVl\u0017aC3mK6,g\u000e\u001e(v[\u0002\n!\u0002Z5di&|g.\u0019:z+\t\tI\u0005E\u0003O\u0003\u0017\ny%C\u0002\u0002N=\u0013Q!\u0011:sCf\u00042ATA)\u0013\r\t\u0019f\u0014\u0002\u0004\u0003:L\u0018a\u00033jGRLwN\\1ss\u0002\nQ\"\u001b8u\t&\u001cG/[8oCJLXCAA.!\u0011q\u00151\n6\u0002#%tG\u000fR5di&|g.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002b\u0005\u001d\u0004c\u0001(\u0002d%\u0019\u0011QM(\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003SR\u0013\u0011!a\u0001\u00037\n1\u0001\u001f\u00132\u00039Ig\u000e\u001e#jGRLwN\\1ss\u0002\na\u0002\\8oO\u0012K7\r^5p]\u0006\u0014\u00180\u0006\u0002\u0002rA)a*a\u0013\u0002tA\u0019a*!\u001e\n\u0007\u0005]tJ\u0001\u0003M_:<\u0017A\u00057p]\u001e$\u0015n\u0019;j_:\f'/_0%KF$B!!\u0019\u0002~!I\u0011\u0011N\u0017\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0010Y>tw\rR5di&|g.\u0019:zA\u0005!a.\u001a=u)\u0019\t\t'!\"\u0002\u0012\"9\u0011qQ\u0018A\u0002\u0005%\u0015a\u0001:poB!\u00111RAG\u001b\t\t)\"\u0003\u0003\u0002\u0010\u0006U!aC%oi\u0016\u0014h.\u00197S_^Da!a%0\u0001\u0004Q\u0017aB8sI&t\u0017\r\\\u0001\bQ\u0006\u001ch*\u001a=u+\t\tI\nE\u0002O\u00037K1!!(P\u0005\u001d\u0011un\u001c7fC:\f!\u0002Z3d_6\u0004(/Z:t)\u0019\t\t'a)\u00024\"9\u0011QU\u0019A\u0002\u0005\u001d\u0016\u0001D2pYVlgNV3di>\u0014\b\u0003BAU\u0003_k!!a+\u000b\u0007\u00055v(\u0001\u0006wK\u000e$xN]5{K\u0012LA!!-\u0002,\n!rK]5uC\ndWmQ8mk6tg+Z2u_JDa!!.2\u0001\u0004Q\u0017\u0001C2ba\u0006\u001c\u0017\u000e^=\u0011\u0007}\fI\fB\u0004\u0002\u0004\u001d\u0011\r!!\u0002\t\u000f\u0005uq\u00011\u0001\u0002 !9\u0011qF\u0004A\u0002\u0005}\u0006CBA\u001a\u0003k\t9,A\u0004f]\u000e|G-\u001a:\u0016\t\u0005\u0015'Q\t\u000b\u0005\u0003\u000f\u00149\u0005\u0005\u0003y\u0015\t\r#aB#oG>$WM]\u000b\u0005\u0003\u001b\f)n\u0005\u0003\u000b\u001b\u0006=\u0007#\u0002&\u0002R\u0006M\u0017bAAewA\u0019q0!6\u0005\u000f\u0005\r!B1\u0001\u0002\u0006A1\u00111GA\u001b\u0003'$B!a7\u0002^B!\u0001PCAj\u0011\u001d\ty\u0003\u0004a\u0001\u0003/\f\u0011cX;oG>l\u0007O]3tg\u0016$7+\u001b>f\u0003UyVO\\2p[B\u0014Xm]:fINK'0Z0%KF$B!!\u0019\u0002f\"A\u0011\u0011\u000e\b\u0002\u0002\u0003\u0007!.\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013\u0001C8wKJ4Gn\\<\u0002\u0019=4XM\u001d4m_^|F%Z9\u0015\t\u0005\u0005\u0014q\u001e\u0005\n\u0003S\n\u0012\u0011!a\u0001\u00033\u000b\u0011b\u001c<fe\u001adwn\u001e\u0011\u0002\u000b\r|WO\u001c;\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003BA1\u0003sD\u0001\"!\u001b\u0015\u0003\u0003\u0005\rA[\u0001\u0007G>,h\u000e\u001e\u0011\u0002\rY\fG.^3t+\t\u0011\t\u0001\u0005\u0004\u0003\u0004\t5!\u0011C\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u00059Q.\u001e;bE2,'b\u0001B\u0006\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t=!Q\u0001\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0002T\nM\u0011\u0002\u0002B\u000b\u00033\u0011A\"\u00138uKJt\u0017\r\u001c+za\u0016\fqA^1mk\u0016\u001c\b%\u0006\u0002\u0003\u001cA9!1\u0001B\u000f\u0003\u001f\u0002\u0018\u0002\u0002B\u0010\u0005\u000b\u0011q\u0001S1tQ6\u000b\u0007/\u0001\beS\u000e$\u0018n\u001c8bef\u001c\u0016N_3\u0002%\u0011L7\r^5p]\u0006\u0014\u0018pU5{K~#S-\u001d\u000b\u0005\u0003C\u00129\u0003\u0003\u0005\u0002jm\t\t\u00111\u0001k\u0003=!\u0017n\u0019;j_:\f'/_*ju\u0016\u0004\u0013AG4bi\",'oQ8naJ,7o]5cS2LG/_*uCR\u001cHCBA1\u0005_\u0011\t\u0004C\u0004\u0002\bv\u0001\r!!#\t\r\u0005MU\u00041\u0001k\u0003!\u0019w.\u001c9sKN\u001cHCBA\u0010\u0005o\u0011Y\u0004C\u0004\u0003:y\u0001\r!a\b\u0002\t\u0019\u0014x.\u001c\u0005\b\u0005{q\u0002\u0019AA\u0010\u0003\t!x.\u0001\tv]\u000e|W\u000e\u001d:fgN,GmU5{K\u0006q1m\\7qe\u0016\u001c8/\u001a3TSj,\u0007cA@\u0003F\u00119\u00111\u0001\u0005C\u0002\u0005\u0015\u0001bBA\u0018\u0011\u0001\u0007!\u0011\n\t\u0007\u0003g\t)Da\u0011\u0002\u0011M,\b\u000f]8siN$B!!'\u0003P!9\u0011qF\u0005A\u0002\tE\u0003\u0007\u0002B*\u00057\u0002b!a\r\u0003V\te\u0013b\u0001B,{\tQ1i\u001c7v[:$\u0016\u0010]3\u0011\u0007}\u0014Y\u0006\u0002\u0007\u0003^\t=\u0013\u0011!A\u0001\u0006\u0003\u0011yFA\u0002`IM\nB!a\u0002\u0002P\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u001a\u0011\t\t\u001d$QN\u0007\u0003\u0005SRAAa\u001b\u0002(\u0005!A.\u00198h\u0013\u0011\u0011yG!\u001b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0014\u0003x!A\u0011\u0011\u000e\u001b\u0002\u0002\u0003\u0007!.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\b\u0005\u0004\u0003\u0000\t\u0005\u0015qJ\u0007\u0003\u0005\u0013IAAa!\u0003\n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tIJ!#\t\u0013\u0005%d'!AA\u0002\u0005=\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003)\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005K\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa&\u0011\t\t\u001d$\u0011T\u0005\u0005\u00057\u0013IG\u0001\u0004PE*,7\r\u001e")
public final class DictionaryEncoding {
    public static String toString() {
        return DictionaryEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return DictionaryEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object x$1) {
        return DictionaryEncoding$.MODULE$.canEqual(x$1);
    }

    public static Iterator<Object> productIterator() {
        return DictionaryEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int x$1) {
        return DictionaryEncoding$.MODULE$.productElement(x$1);
    }

    public static int productArity() {
        return DictionaryEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return DictionaryEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return DictionaryEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> Encoder<T> encoder(NativeColumnType<T> columnType) {
        return DictionaryEncoding$.MODULE$.encoder((NativeColumnType)columnType);
    }

    public static <T extends PhysicalDataType> Decoder<T> decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
        return DictionaryEncoding$.MODULE$.decoder(buffer, (NativeColumnType)columnType);
    }

    public static short MAX_DICT_SIZE() {
        return DictionaryEncoding$.MODULE$.MAX_DICT_SIZE();
    }

    public static int typeId() {
        return DictionaryEncoding$.MODULE$.typeId();
    }

    public static Iterator<String> productElementNames() {
        return DictionaryEncoding$.MODULE$.productElementNames();
    }

    public static String productElementName(int n) {
        return DictionaryEncoding$.MODULE$.productElementName(n);
    }

    public static class Decoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private final int elementNum;
        private final Object[] dictionary;
        private int[] intDictionary;
        private long[] longDictionary;

        public int elementNum() {
            return this.elementNum;
        }

        private Object[] dictionary() {
            return this.dictionary;
        }

        private int[] intDictionary() {
            return this.intDictionary;
        }

        private void intDictionary_$eq(int[] x$1) {
            this.intDictionary = x$1;
        }

        private long[] longDictionary() {
            return this.longDictionary;
        }

        private void longDictionary_$eq(long[] x$1) {
            this.longDictionary = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            this.columnType.setField(row, ordinal, this.dictionary()[this.buffer.getShort()]);
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            int pos;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            T t = this.columnType.dataType();
            if (t instanceof PhysicalIntegerType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.intDictionary()));
                for (pos = 0; pos < capacity; ++pos) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                        continue;
                    }
                    if (++seenNulls < nullCount) {
                        nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                    }
                    columnVector.putNull(pos);
                }
                return;
            }
            if (t instanceof PhysicalLongType) {
                WritableColumnVector dictionaryIds = columnVector.reserveDictionaryIds(capacity);
                columnVector.setDictionary(new ColumnDictionary(this.longDictionary()));
                while (pos < capacity) {
                    if (pos != nextNullIndex) {
                        dictionaryIds.putInt(pos, this.buffer.getShort());
                    } else {
                        if (++seenNulls < nullCount) {
                            nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                        }
                        columnVector.putNull(pos);
                    }
                    ++pos;
                }
                return;
            }
            throw SparkException$.MODULE$.internalError("Not supported type in DictionaryEncoding.");
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.elementNum = ByteBufferHelper$.MODULE$.getInt(buffer);
            this.dictionary = new Object[this.elementNum()];
            this.intDictionary = null;
            this.longDictionary = null;
            T t = columnType.dataType();
            if (t instanceof PhysicalIntegerType) {
                this.intDictionary_$eq(new int[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    int v;
                    $this.intDictionary()[i] = v = BoxesRunTime.unboxToInt($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToInteger((int)v);
                });
            } else if (t instanceof PhysicalLongType) {
                this.longDictionary_$eq(new long[this.elementNum()]);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    long v;
                    $this.longDictionary()[i] = v = BoxesRunTime.unboxToLong($this.columnType.extract($this.buffer));
                    $this.dictionary()[i] = BoxesRunTime.boxToLong((long)v);
                });
            } else if (t instanceof PhysicalStringType) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.elementNum()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Object v = $this.columnType.extract($this.buffer);
                    $this.dictionary()[i] = v;
                });
            } else {
                throw new MatchError(t);
            }
        }
    }

    public static class Encoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private boolean overflow;
        private int count;
        private final ArrayBuffer<Object> values;
        private final HashMap<Object, Object> dictionary;
        private int dictionarySize;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private boolean overflow() {
            return this.overflow;
        }

        private void overflow_$eq(boolean x$1) {
            this.overflow = x$1;
        }

        private int count() {
            return this.count;
        }

        private void count_$eq(int x$1) {
            this.count = x$1;
        }

        private ArrayBuffer<Object> values() {
            return this.values;
        }

        private HashMap<Object, Object> dictionary() {
            return this.dictionary;
        }

        private int dictionarySize() {
            return this.dictionarySize;
        }

        private void dictionarySize_$eq(int x$1) {
            this.dictionarySize = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            if (!this.overflow()) {
                int actualSize = this.columnType.actualSize(row, ordinal);
                this.count_$eq(this.count() + 1);
                this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
                if (!this.dictionary().contains(value)) {
                    if (this.dictionary().size() < DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                        Object clone = this.columnType.clone(value);
                        this.values().$plus$eq(clone);
                        this.dictionarySize_$eq(this.dictionarySize() + actualSize);
                        this.dictionary().update(clone, (Object)BoxesRunTime.boxToShort((short)((short)this.dictionary().size())));
                        return;
                    }
                    this.overflow_$eq(true);
                    this.values().clear();
                    this.dictionary().clear();
                    return;
                }
                return;
            }
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            if (this.overflow()) {
                throw QueryExecutionErrors$.MODULE$.useDictionaryEncodingWhenDictionaryOverflowError();
            }
            to.putInt(DictionaryEncoding$.MODULE$.typeId()).putInt(this.dictionary().size());
            for (int i = 0; i < this.values().length(); ++i) {
                this.columnType.append(this.values().apply(i), to);
            }
            while (from.hasRemaining()) {
                to.putShort(BoxesRunTime.unboxToShort((Object)this.dictionary().apply(this.columnType.extract(from))));
            }
            to.rewind();
            return to;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            if (this.overflow()) {
                return Integer.MAX_VALUE;
            }
            return this.dictionarySize() + this.count() * 2;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this.overflow = false;
            this.count = 0;
            this.values = new ArrayBuffer(1024);
            this.dictionary = HashMap$.MODULE$.empty();
            this.dictionarySize = 4;
        }
    }
}

