/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.QuantilesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.req.ReqSketch;

public final class KolmogorovSmirnov {
    public static double computeKSDelta(QuantilesDoublesAPI sketch1, QuantilesDoublesAPI sketch2) {
        DoublesSortedView p = sketch1.getSortedView();
        DoublesSortedView q = sketch2.getSortedView();
        double[] pSamplesArr = p.getQuantiles();
        double[] qSamplesArr = q.getQuantiles();
        long[] pCumWtsArr = p.getCumulativeWeights();
        long[] qCumWtsArr = q.getCumulativeWeights();
        int pSamplesArrLen = pSamplesArr.length;
        int qSamplesArrLen = qSamplesArr.length;
        double n1 = sketch1.getN();
        double n2 = sketch2.getN();
        double deltaHeight = 0.0;
        int i = 0;
        int j = 0;
        while (i < pSamplesArrLen - 1 && j < qSamplesArrLen - 1) {
            deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
            if (pSamplesArr[i] < qSamplesArr[j]) {
                ++i;
                continue;
            }
            if (qSamplesArr[j] < pSamplesArr[i]) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
        return deltaHeight;
    }

    public static double computeKSDelta(QuantilesFloatsAPI sketch1, QuantilesFloatsAPI sketch2) {
        FloatsSortedView p = sketch1.getSortedView();
        FloatsSortedView q = sketch2.getSortedView();
        float[] pSamplesArr = p.getQuantiles();
        float[] qSamplesArr = q.getQuantiles();
        long[] pCumWtsArr = p.getCumulativeWeights();
        long[] qCumWtsArr = q.getCumulativeWeights();
        int pSamplesArrLen = pSamplesArr.length;
        int qSamplesArrLen = qSamplesArr.length;
        double n1 = sketch1.getN();
        double n2 = sketch2.getN();
        double deltaHeight = 0.0;
        int i = 0;
        int j = 0;
        while (i < pSamplesArrLen - 1 && j < qSamplesArrLen - 1) {
            deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
            if (pSamplesArr[i] < qSamplesArr[j]) {
                ++i;
                continue;
            }
            if (qSamplesArr[j] < pSamplesArr[i]) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
        return deltaHeight;
    }

    public static double computeKSThreshold(QuantilesAPI sketch1, QuantilesAPI sketch2, double tgtPvalue) {
        double r1 = sketch1.getNumRetained();
        double r2 = sketch2.getNumRetained();
        double alpha = tgtPvalue;
        double alphaFactor = Math.sqrt(-0.5 * Math.log(0.5 * alpha));
        double deltaAreaThreshold = alphaFactor * Math.sqrt((r1 + r2) / (r1 * r2));
        double eps1 = sketch1.getNormalizedRankError(false);
        double eps2 = sketch2.getNormalizedRankError(false);
        return deltaAreaThreshold + eps1 + eps2;
    }

    public static boolean kolmogorovSmirnovTest(QuantilesAPI sketch1, QuantilesAPI sketch2, double tgtPvalue) {
        double delta = KolmogorovSmirnov.isDoubleType(sketch1, sketch2) ? KolmogorovSmirnov.computeKSDelta((QuantilesDoublesAPI)sketch1, (QuantilesDoublesAPI)sketch2) : KolmogorovSmirnov.computeKSDelta((QuantilesFloatsAPI)sketch1, (QuantilesFloatsAPI)sketch2);
        double thresh = KolmogorovSmirnov.computeKSThreshold(sketch1, sketch2, tgtPvalue);
        return delta > thresh;
    }

    private static boolean isDoubleType(Object sk1, Object sk2) {
        boolean isFlt;
        if (sk1 instanceof ReqSketch || sk2 instanceof ReqSketch) {
            throw new UnsupportedOperationException("Unsupported operation for this Sketch Type. ");
        }
        boolean isDbl = sk1 instanceof QuantilesDoublesAPI && sk2 instanceof QuantilesDoublesAPI;
        boolean bl = isFlt = sk1 instanceof QuantilesFloatsAPI && sk2 instanceof QuantilesFloatsAPI;
        if (isDbl ^ isFlt) {
            return isDbl;
        }
        throw new UnsupportedOperationException("Unsupported operation for this Sketch Type. ");
    }
}

