/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext$;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalMathUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001\u0002\u0014(\u0001RB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011!\u0019\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003-\u0001\u0005#\u0005\u000b\u0011B+\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A0\t\u000b\t\u0004A\u0011I2\t\u000b)\u0004A\u0011I6\t\u000bQ\u0004A\u0011I6\t\u000bU\u0004A\u0011\t<\t\r\u0005-\u0001\u0001\"\u0011l\u0011)\ti\u0001\u0001EC\u0002\u0013%\u0011q\u0002\u0005\b\u0003;\u0001A\u0011KA\u0010\u0011\u001d\tI\u0003\u0001C!\u0003WAq!a\r\u0001\t#\n)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0001\u0002B!I\u0011\u0011\n\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003\u0017B\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA>\u0001\u0005\u0005I\u0011AA?\u0011%\ty\bAA\u0001\n\u0003\t\t\tC\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0003G\u0003\u0011\u0011!C!\u0003KC\u0011\"!+\u0001\u0003\u0003%\t%a+\b\u000f\u0005=w\u0005#\u0001\u0002R\u001a1ae\nE\u0001\u0003'Da!\u0017\u0010\u0005\u0002\u0005\u0015\bbBAt=\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003Ot\u0012\u0011!CA\u0005\u0007A\u0011Ba\u0003\u001f#\u0003%\t!!\u001a\t\u0013\t5a$!A\u0005\u0002\n=\u0001\"\u0003B\u000f=E\u0005I\u0011AA3\u0011%\u0011yBHA\u0001\n\u0013\u0011\tC\u0001\u0005Tk\n$(/Y2u\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0016,\u0003!\u0019\u0017\r^1msN$(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011\u0003\u0002\u00016s}\u0002\"AN\u001c\u000e\u0003\u001dJ!\u0001O\u0014\u0003!\tKg.\u0019:z\u0003JLG\u000f[7fi&\u001c\u0007C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0001\"s!!\u0011$\u000f\u0005\t+U\"A\"\u000b\u0005\u0011\u001b\u0014A\u0002\u001fs_>$h(C\u0001=\u0013\t95(A\u0004qC\u000e\\\u0017mZ3\n\u0005%S%\u0001D*fe&\fG.\u001b>bE2,'BA$<\u0003\u0011aWM\u001a;\u0016\u00035\u0003\"A\u000e(\n\u0005=;#AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\n1\"\u001a<bY\u000e{g\u000e^3yiV\tQ\u000b\u0005\u00027-&\u0011qk\n\u0002\u0013\u001dVlWM]5d\u000bZ\fGnQ8oi\u0016DH/\u0001\u0007fm\u0006d7i\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u00057rkf\f\u0005\u00027\u0001!)1j\u0002a\u0001\u001b\")\u0011k\u0002a\u0001\u001b\"91k\u0002I\u0001\u0002\u0004)FcA.aC\")1\n\u0003a\u0001\u001b\")\u0011\u000b\u0003a\u0001\u001b\u0006I\u0011N\u001c9viRK\b/Z\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011qmK\u0001\u0006if\u0004Xm]\u0005\u0003S\u001a\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\rMLXNY8m+\u0005a\u0007CA7r\u001d\tqw\u000e\u0005\u0002Cw%\u0011\u0001oO\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002qw\u0005iA-Z2j[\u0006dW*\u001a;i_\u0012\f\u0011C]3tk2$H)Z2j[\u0006dG+\u001f9f)\u001d9(p`A\u0002\u0003\u000f\u0001\"!\u001a=\n\u0005e4'a\u0003#fG&l\u0017\r\u001c+za\u0016DQa\u001f\u0007A\u0002q\f!\u0001]\u0019\u0011\u0005ij\u0018B\u0001@<\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u0003a\u0001\u0019\u0001?\u0002\u0005M\f\u0004BBA\u0003\u0019\u0001\u0007A0\u0001\u0002qe!1\u0011\u0011\u0002\u0007A\u0002q\f!a\u001d\u001a\u0002-\r\fG.\u001a8eCJLe\u000e^3sm\u0006dW*\u001a;i_\u0012\fqA\\;nKJL7-\u0006\u0002\u0002\u0012A)\u0001)a\u0005\u0002\u0018%\u0019\u0011Q\u0003&\u0003\u000f9+X.\u001a:jGB\u0019!(!\u0007\n\u0007\u0005m1HA\u0002B]f\fAB\\;mYN\u000bg-Z#wC2$b!a\u0006\u0002\"\u0005\u0015\u0002bBA\u0012\u001f\u0001\u0007\u0011qC\u0001\u0007S:\u0004X\u000f^\u0019\t\u000f\u0005\u001dr\u00021\u0001\u0002\u0018\u00051\u0011N\u001c9viJ\nq\"\u001a=bGRl\u0015\r\u001e5NKRDw\u000eZ\u000b\u0003\u0003[\u0001BAOA\u0018Y&\u0019\u0011\u0011G\u001e\u0003\r=\u0003H/[8o\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003\\\u0003o\tY\u0004\u0003\u0004\u0002:E\u0001\r!T\u0001\b]\u0016<H*\u001a4u\u0011\u0019\ti$\u0005a\u0001\u001b\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLHcB.\u0002D\u0005\u0015\u0013q\t\u0005\b\u0017J\u0001\n\u00111\u0001N\u0011\u001d\t&\u0003%AA\u00025Cqa\u0015\n\u0011\u0002\u0003\u0007Q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055#fA'\u0002P-\u0012\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003%)hn\u00195fG.,GMC\u0002\u0002\\m\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty&!\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\r\u0016\u0004+\u0006=\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002nA!\u0011qNA=\u001b\t\t\tH\u0003\u0003\u0002t\u0005U\u0014\u0001\u00027b]\u001eT!!a\u001e\u0002\t)\fg/Y\u0005\u0004e\u0006E\u0014\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001?\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qCAB\u0011!\t)\tGA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fB1\u0011QRAJ\u0003/i!!a$\u000b\u0007\u0005E5(\u0001\u0006d_2dWm\u0019;j_:LA!!&\u0002\u0010\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY*!)\u0011\u0007i\ni*C\u0002\u0002 n\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0006j\t\t\u00111\u0001\u0002\u0018\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ti'a*\t\u0011\u0005\u00155$!AA\u0002q\fa!Z9vC2\u001cH\u0003BAN\u0003[C\u0011\"!\"\u001d\u0003\u0003\u0005\r!a\u0006)'\u0001\t\t,a.\u0002:\u0006u\u0016qXAb\u0003\u000b\fI-a3\u0011\u0007Y\n\u0019,C\u0002\u00026\u001e\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002<\u0006iS\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005Y3yaJ\f\u0004-\f1fqB\u0014(\u0007\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!1\u0002k)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003#\u0007I0G+:\u001bu\fI\u0019<\u0015\u0001\u0002\u0003\u0005\t\u0011!AER\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000f\fQ!\r\u00181]A\nQa\u001a:pkB\f#!!4\u0002\u00155\fG\u000f[0gk:\u001c7/\u0001\u0005Tk\n$(/Y2u!\t1ddE\u0003\u001f\u0003+\fY\u000eE\u0002;\u0003/L1!!7<\u0005\u0019\te.\u001f*fMB!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002b\u0006U\u0014AA5p\u0013\rI\u0015q\u001c\u000b\u0003\u0003#\fQ!\u00199qYf$raWAv\u0003[\fy\u000fC\u0003LA\u0001\u0007Q\nC\u0003RA\u0001\u0007Q\nC\u0004\u0002r\u0002\u0002\r!a=\u0002\u0011\u00154\u0018\r\\'pI\u0016\u0004B!!>\u0002|:\u0019a'a>\n\u0007\u0005ex%\u0001\u0005Fm\u0006dWj\u001c3f\u0013\u0011\ti0a@\u0003\u000bY\u000bG.^3\n\u0007\t\u00051HA\u0006F]VlWM]1uS>tGcB.\u0003\u0006\t\u001d!\u0011\u0002\u0005\u0006\u0017\u0006\u0002\r!\u0014\u0005\u0006#\u0006\u0002\r!\u0014\u0005\b'\u0006\u0002\n\u00111\u0001V\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005#\u0011I\u0002E\u0003;\u0003_\u0011\u0019\u0002\u0005\u0004;\u0005+iU*V\u0005\u0004\u0005/Y$A\u0002+va2,7\u0007\u0003\u0005\u0003\u001c\r\n\t\u00111\u0001\\\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\r\u0002\u0003BA8\u0005KIAAa\n\u0002r\t1qJ\u00196fGR\u0004")
public class Subtract
extends BinaryArithmetic {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final NumericEvalContext evalContext;
    private volatile boolean bitmap$0;

    public static NumericEvalContext $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, NumericEvalContext>> unapply(Subtract x$0) {
        return Subtract$.MODULE$.unapply(x$0);
    }

    public static NumericEvalContext apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public NumericEvalContext evalContext() {
        return this.evalContext;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public DecimalType resultDecimalType(int p1, int s1, int p2, int s2) {
        int resultScale = package$.MODULE$.max(s1, s2);
        int resultPrecision = package$.MODULE$.max(p1 - s1, p2 - s2) + resultScale + 1;
        if (this.allowPrecisionLoss()) {
            return DecimalType$.MODULE$.adjustPrecisionScale(resultPrecision, resultScale);
        }
        return DecimalType$.MODULE$.bounded(resultPrecision, resultScale);
    }

    @Override
    public String calendarIntervalMethod() {
        if (this.failOnError()) {
            return "subtractExact";
        }
        return "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        DecimalType decimalType;
        Option option;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return this.checkDecimalOverflow((Decimal)this.numeric().minus(input1, input2), precision, scale);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                return IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
            }
        }
        if (bl) {
            return IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToInteger((int)IntervalMathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2)));
        }
        if (dataType2 instanceof IntegerType && this.failOnError()) {
            return BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2), this.getContextOrNull()));
        }
        if (dataType2 instanceof LongType && this.failOnError()) {
            return BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2), this.getContextOrNull()));
        }
        return this.numeric().minus(input1, input2);
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    @Override
    public Subtract withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Subtract copy(Expression left, Expression right, NumericEvalContext evalContext) {
        return new Subtract(left, right, evalContext);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public NumericEvalContext copy$default$3() {
        return this.evalContext();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.evalContext();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "evalContext";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        NumericEvalContext numericEvalContext = this.evalContext();
        NumericEvalContext numericEvalContext2 = subtract.evalContext();
        if (numericEvalContext == null) {
            if (numericEvalContext2 != null) {
                return false;
            }
        } else if (!((Object)numericEvalContext).equals(numericEvalContext2)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, NumericEvalContext evalContext) {
        this.left = left;
        this.right = right;
        this.evalContext = evalContext;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, NumericEvalContext$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

