/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.memory.netty;

import org.sparkproject.io.netty.buffer.PooledByteBufAllocatorL;
import org.sparkproject.io.netty.buffer.UnsafeDirectLittleEndian;
import org.sparkproject.io.netty.util.internal.PlatformDependent;
import org.sparkproject.org.apache.arrow.memory.AllocationManager;
import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.memory.ReferenceManager;

public class NettyAllocationManager
extends AllocationManager {
    public static final AllocationManager.Factory FACTORY = new AllocationManager.Factory(){

        @Override
        public AllocationManager create(BufferAllocator accountingAllocator, long size) {
            return new NettyAllocationManager(accountingAllocator, size);
        }

        @Override
        public ArrowBuf empty() {
            return EMPTY_BUFFER;
        }
    };
    public static final int DEFAULT_ALLOCATION_CUTOFF_VALUE = Integer.MAX_VALUE;
    private static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL();
    static final UnsafeDirectLittleEndian EMPTY = NettyAllocationManager.INNER_ALLOCATOR.empty;
    static final ArrowBuf EMPTY_BUFFER = new ArrowBuf(ReferenceManager.NO_OP, null, 0L, EMPTY.memoryAddress());
    static final long CHUNK_SIZE = INNER_ALLOCATOR.getChunkSize();
    private final long allocatedSize;
    private final UnsafeDirectLittleEndian memoryChunk;
    private final long allocatedAddress;

    NettyAllocationManager(BufferAllocator accountingAllocator, long requestedSize, int allocationCutOffValue) {
        super(accountingAllocator);
        if (requestedSize > (long)allocationCutOffValue) {
            this.memoryChunk = null;
            this.allocatedAddress = PlatformDependent.allocateMemory(requestedSize);
            this.allocatedSize = requestedSize;
        } else {
            this.memoryChunk = INNER_ALLOCATOR.allocate(requestedSize);
            this.allocatedAddress = this.memoryChunk.memoryAddress();
            this.allocatedSize = this.memoryChunk.capacity();
        }
    }

    NettyAllocationManager(BufferAllocator accountingAllocator, long requestedSize) {
        this(accountingAllocator, requestedSize, Integer.MAX_VALUE);
    }

    @Deprecated
    UnsafeDirectLittleEndian getMemoryChunk() {
        return this.memoryChunk;
    }

    @Override
    protected long memoryAddress() {
        return this.allocatedAddress;
    }

    @Override
    protected void release0() {
        if (this.memoryChunk == null) {
            PlatformDependent.freeMemory(this.allocatedAddress);
        } else {
            this.memoryChunk.release();
        }
    }

    @Override
    public long getSize() {
        return this.allocatedSize;
    }
}

