/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.st.GeospatialInputTypes;
import org.apache.spark.sql.catalyst.expressions.st.STExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.st.ST_SetSrid$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(geo, srid) - Returns a new GEOGRAPHY or GEOMETRY value whose SRID is the specified SRID value.", arguments="\n    Arguments:\n      * geo - A GEOGRAPHY or GEOMETRY value.\n      * srid - The new SRID value of the geography or geometry.\n  ", examples="\n    Examples:\n      > SELECT st_srid(_FUNC_(ST_GeogFromWKB(X'0101000000000000000000F03F0000000000000040'), 4326));\n       4326\n      > SELECT st_srid(_FUNC_(ST_GeomFromWKB(X'0101000000000000000000F03F0000000000000040'), 3857));\n       3857\n  ", since="4.1.0", group="st_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\u000f\u001f\u00016B\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t'\u0002\u0011\t\u0012)A\u0005]!AA\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005V\u0001\tE\t\u0015!\u0003/\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0006\u0001\"\u0011]\u0011!1\u0007\u0001#b\u0001\n\u0003\u0012\u0006\"B4\u0001\t\u0003B\u0007\"B9\u0001\t\u0003\u0012\u0006\"\u0002:\u0001\t\u0003\u0012\u0006\"B:\u0001\t#\"\bbB=\u0001\u0003\u0003%\tA\u001f\u0005\b{\u0002\t\n\u0011\"\u0001\u007f\u0011!\t\u0019\u0002AI\u0001\n\u0003q\b\"CA\u000b\u0001\u0005\u0005I\u0011IA\f\u0011%\t9\u0003AA\u0001\n\u0003\tI\u0003C\u0005\u00022\u0001\t\t\u0011\"\u0001\u00024!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0013\u0011\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\rt!CAG=\u0005\u0005\t\u0012AAH\r!ib$!A\t\u0002\u0005E\u0005B\u0002,\u0018\t\u0003\tI\u000bC\u0005\u0002,^\t\t\u0011\"\u0012\u0002.\"I\u0011qV\f\u0002\u0002\u0013\u0005\u0015\u0011\u0017\u0005\n\u0003o;\u0012\u0011!CA\u0003sC\u0011\"a3\u0018\u0003\u0003%I!!4\u0003\u0015M#vlU3u'JLGM\u0003\u0002 A\u0005\u00111\u000f\u001e\u0006\u0003C\t\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0005J\u0001\tG\u0006$\u0018\r\\=ti*\u0011QEJ\u0001\u0004gFd'BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0004\u0001M9\u0001A\f\u001a6s}*\u0005CA\u00181\u001b\u0005\u0001\u0013BA\u0019!\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_MJ!\u0001\u000e\u0011\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003m]j\u0011AH\u0005\u0003qy\u0011AcR3pgB\fG/[1m\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bc\u0001\u001e>]5\t1H\u0003\u0002=E\u0005)AO]3fg&\u0011ah\u000f\u0002\u000b\u0005&t\u0017M]=MS.,\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002)s_\u0012,8\r\u001e\t\u0003\r:s!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)c\u0013A\u0002\u001fs_>$h(C\u0001C\u0013\ti\u0015)A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&\u0001D*fe&\fG.\u001b>bE2,'BA'B\u0003\r9Wm\\\u000b\u0002]\u0005!q-Z8!\u0003\u0011\u0019(/\u001b3\u0002\u000bM\u0014\u0018\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\rA\u0016L\u0017\t\u0003m\u0001AQ!U\u0003A\u00029BQ\u0001V\u0003A\u00029\n!\"\u001b8qkR$\u0016\u0010]3t+\u0005i\u0006c\u0001$_A&\u0011q\f\u0015\u0002\u0004'\u0016\f\bCA1e\u001b\u0005\u0011'BA2%\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002SB\u0011!N\u001c\b\u0003W2\u0004\"\u0001S!\n\u00055\f\u0015A\u0002)sK\u0012,g-\u0003\u0002pa\n11\u000b\u001e:j]\u001eT!!\\!\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2\u0001W;x\u0011\u001518\u00021\u0001/\u0003\u001dqWm\u001e'fMRDQ\u0001_\u0006A\u00029\n\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0002YwrDq!\u0015\u0007\u0011\u0002\u0003\u0007a\u0006C\u0004U\u0019A\u0005\t\u0019\u0001\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqPK\u0002/\u0003\u0003Y#!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\t\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011CA\u0004\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0012\u0001\u00026bm\u0006L1a\\A\u000f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\u0003E\u0002A\u0003[I1!a\fB\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)$a\u000f\u0011\u0007\u0001\u000b9$C\u0002\u0002:\u0005\u00131!\u00118z\u0011%\ti$EA\u0001\u0002\u0004\tY#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0007\u0002b!!\u0012\u0002L\u0005URBAA$\u0015\r\tI%Q\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA'\u0003\u000f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111KA-!\r\u0001\u0015QK\u0005\u0004\u0003/\n%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{\u0019\u0012\u0011!a\u0001\u0003k\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011\u0011DA0\u0011%\ti\u0004FA\u0001\u0002\u0004\tY#\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003'\n)\u0007C\u0005\u0002>U\t\t\u00111\u0001\u00026!:\u0002!!\u001b\u0002p\u0005E\u0014QOA<\u0003w\ni(!!\u0002\u0004\u0006\u001d\u0015\u0011\u0012\t\u0004_\u0005-\u0014bAA7A\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA:\u0003\u0015|f)\u0016(D?\":Wm\u001c\u0017!gJLG-\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007E\\3xA\u001d+uj\u0012*B!\"K\u0006e\u001c:!\u000f\u0016{U*\u0012+S3\u00022\u0018\r\\;fA]Dwn]3!'JKE\tI5tAQDW\rI:qK\u000eLg-[3eAM\u0013\u0016\n\u0012\u0011wC2,XML\u0001\nCJ<W/\\3oiN\f#!!\u001f\u0002\u007f*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003eZ3pA5\u0002\u0013\tI$F\u001f\u001e\u0013\u0016\t\u0015%ZA=\u0014\beR#P\u001b\u0016#&+\u0017\u0011wC2,XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gJLG\rI\u0017!)\",\u0007E\\3xAM\u0013\u0016\n\u0012\u0011wC2,X\rI8gAQDW\rI4f_\u001e\u0014\u0018\r\u001d5zA=\u0014\beZ3p[\u0016$(/\u001f\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\n\u0011q\u001d\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!gR|6O]5eQ}3UKT\"`QM#vlR3pO\u001a\u0013x.\\,L\u0005\"Bv\u0005M\u00191cA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r$1g\u0019\u0003\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\"\u0004gJ\u0015-AQ\u001a$GN\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\"4G\r\u001c\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAM$xl\u001d:jI\"zf)\u0016(D?\"\u001aFkX$f_64%o\\7X\u0017\nC\u0003l\n\u00192aE\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u0019GaM2\u0005\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002D\u0007M\u0014*Y\u0001\u001a\u0004(N\u001c*SmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007O\u001b8\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAAC\u0003\u0015!d&\r\u00181\u0003\u00159'o\\;qC\t\tY)\u0001\u0005ti~3WO\\2t\u0003)\u0019FkX*fiN\u0013\u0018\u000e\u001a\t\u0003m]\u0019RaFAJ\u0003?\u0003r!!&\u0002\u001c:r\u0003,\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T!\u0002\u000fI,h\u000e^5nK&!\u0011QTAL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*!\u0011QUA\u0011\u0003\tIw.C\u0002P\u0003G#\"!a$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0007\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000ba\u000b\u0019,!.\t\u000bES\u0002\u0019\u0001\u0018\t\u000bQS\u0002\u0019\u0001\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u00111XAd!\u0015\u0001\u0015QXAa\u0013\r\ty,\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0001\u000b\u0019M\f\u0018\n\u0007\u0005\u0015\u0017I\u0001\u0004UkBdWM\r\u0005\t\u0003\u0013\\\u0012\u0011!a\u00011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005=\u0007\u0003BA\u000e\u0003#LA!a5\u0002\u001e\t1qJ\u00196fGR\u0004")
public class ST_SetSrid
extends Expression
implements RuntimeReplaceable,
GeospatialInputTypes,
BinaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression geo;
    private final Expression srid;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ST_SetSrid x$0) {
        return ST_SetSrid$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ST_SetSrid> tupled() {
        return ST_SetSrid$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ST_SetSrid>> curried() {
        return ST_SetSrid$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$st$GeospatialInputTypes$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return GeospatialInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression geo() {
        return this.geo;
    }

    public Expression srid() {
        return this.srid;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{GeographyType$.MODULE$, GeometryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    private Expression replacement$lzycompute() {
        ST_SetSrid sT_SetSrid = this;
        synchronized (sT_SetSrid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Class<STUtils> x$1 = STUtils.class;
                DataType x$2 = STExpressionUtils$.MODULE$.geospatialTypeWithSrid(this.geo().dataType(), this.srid());
                String x$3 = "stSetSrid";
                .colon.colon x$4 = new .colon.colon((Object)this.geo(), (List)new .colon.colon((Object)this.srid(), (List)Nil$.MODULE$));
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                this.replacement = new StaticInvoke(STUtils.class, x$2, "stSetSrid", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "st_setsrid";
    }

    @Override
    public Expression left() {
        return this.geo();
    }

    @Override
    public Expression right() {
        return this.srid();
    }

    @Override
    public ST_SetSrid withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ST_SetSrid copy(Expression geo, Expression srid) {
        return new ST_SetSrid(geo, srid);
    }

    public Expression copy$default$1() {
        return this.geo();
    }

    public Expression copy$default$2() {
        return this.srid();
    }

    @Override
    public String productPrefix() {
        return "ST_SetSrid";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.geo();
            }
            case 1: {
                return this.srid();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_SetSrid;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "geo";
            }
            case 1: {
                return "srid";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_SetSrid)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_SetSrid sT_SetSrid = (ST_SetSrid)x$1;
        Expression expression = this.geo();
        Expression expression2 = sT_SetSrid.geo();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.srid();
        Expression expression4 = sT_SetSrid.srid();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sT_SetSrid.canEqual(this)) return false;
        return true;
    }

    public ST_SetSrid(Expression geo, Expression srid) {
        this.geo = geo;
        this.srid = srid;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        GeospatialInputTypes.$init$(this);
        BinaryLike.$init$(this);
        Statics.releaseFence();
    }
}

