/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.AddColumns;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumnSpec;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumns;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.QualifiedColType;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.V2CreateTablePlan;
import org.apache.spark.sql.catalyst.util.GeneratedColumn$;
import org.apache.spark.sql.catalyst.util.IdentityColumn$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumnsUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class ColumnDefinition$
implements Serializable {
    public static final ColumnDefinition$ MODULE$ = new ColumnDefinition$();

    public boolean $lessinit$greater$default$3() {
        return true;
    }

    public Option<String> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Option<DefaultValueExpression> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Option<IdentityColumnSpec> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public Metadata $lessinit$greater$default$8() {
        return Metadata$.MODULE$.empty();
    }

    public ColumnDefinition fromV1Column(StructField col, ParserInterface parser) {
        None$ none$;
        boolean hasDefaultValue;
        MetadataBuilder metadataBuilder = new MetadataBuilder().withMetadata(col.metadata());
        metadataBuilder.remove("comment");
        metadataBuilder.remove(ResolveDefaultColumnsUtils$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
        metadataBuilder.remove(ResolveDefaultColumnsUtils$.MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
        metadataBuilder.remove(GeneratedColumn$.MODULE$.GENERATION_EXPRESSION_METADATA_KEY());
        metadataBuilder.remove(IdentityColumn$.MODULE$.IDENTITY_INFO_START());
        metadataBuilder.remove(IdentityColumn$.MODULE$.IDENTITY_INFO_STEP());
        metadataBuilder.remove(IdentityColumn$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT());
        boolean bl = hasDefaultValue = col.getCurrentDefaultValue().isDefined() && col.getExistenceDefaultValue().isDefined();
        if (hasDefaultValue) {
            String defaultValueSQL = (String)col.getCurrentDefaultValue().get();
            none$ = new Some((Object)new DefaultValueExpression(parser.parseExpression(defaultValueSQL), defaultValueSQL, DefaultValueExpression$.MODULE$.apply$default$3()));
        } else {
            none$ = None$.MODULE$;
        }
        None$ defaultValue = none$;
        Option<String> generationExpr = GeneratedColumn$.MODULE$.getGenerationExpression(col);
        None$ identityColumnSpec = col.metadata().contains(IdentityColumn$.MODULE$.IDENTITY_INFO_START()) ? new Some((Object)new IdentityColumnSpec(col.metadata().getLong(IdentityColumn$.MODULE$.IDENTITY_INFO_START()), col.metadata().getLong(IdentityColumn$.MODULE$.IDENTITY_INFO_STEP()), col.metadata().getBoolean(IdentityColumn$.MODULE$.IDENTITY_INFO_ALLOW_EXPLICIT_INSERT()))) : None$.MODULE$;
        return new ColumnDefinition(col.name(), col.dataType(), col.nullable(), (Option<String>)col.getComment(), (Option<DefaultValueExpression>)defaultValue, generationExpr, (Option<IdentityColumnSpec>)identityColumnSpec, metadataBuilder.build());
    }

    public void checkColumnDefinitions(LogicalPlan plan2) {
        AlterColumns alterColumns;
        AddColumns addColumns;
        V2CreateTablePlan v2CreateTablePlan;
        LogicalPlan logicalPlan = plan2;
        if (!plan2.childrenResolved()) {
            return;
        }
        if (logicalPlan instanceof V2CreateTablePlan && (v2CreateTablePlan = (V2CreateTablePlan)((Object)logicalPlan)).columns().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ColumnDefinition$.$anonfun$checkColumnDefinitions$1(x$3)))) {
            String string;
            V2CreateTablePlan v2CreateTablePlan2 = v2CreateTablePlan;
            if (v2CreateTablePlan2 instanceof CreateTable) {
                string = "CREATE TABLE";
            } else if (v2CreateTablePlan2 instanceof ReplaceTable) {
                string = "REPLACE TABLE";
            } else {
                String cmd = v2CreateTablePlan2.getClass().getSimpleName();
                throw SparkException$.MODULE$.internalError("Command " + cmd + " should not have column default value expression.");
            }
            String statement = string;
            v2CreateTablePlan.columns().foreach((Function1 & Serializable)col -> {
                ColumnDefinition$.$anonfun$checkColumnDefinitions$2(statement, col);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (logicalPlan instanceof AddColumns && (addColumns = (AddColumns)logicalPlan).columnsToAdd().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ColumnDefinition$.$anonfun$checkColumnDefinitions$4(x$4)))) {
            addColumns.columnsToAdd().foreach((Function1 & Serializable)c -> {
                ColumnDefinition$.$anonfun$checkColumnDefinitions$5(c);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (logicalPlan instanceof AlterColumns && (alterColumns = (AlterColumns)logicalPlan).specs().exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ColumnDefinition$.$anonfun$checkColumnDefinitions$7(x$5)))) {
            alterColumns.specs().foreach((Function1 & Serializable)c -> {
                ColumnDefinition$.$anonfun$checkColumnDefinitions$8(c);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void checkDefaultColumnConflicts(ColumnDefinition col) {
        if (col.generationExpression().isDefined()) {
            throw new AnalysisException("GENERATED_COLUMN_WITH_DEFAULT_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)col.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)((DefaultValueExpression)col.defaultValue().get()).originalSQL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"genExpr"), col.generationExpression().get())})));
        }
        if (col.identityColumnSpec().isDefined()) {
            throw new AnalysisException("IDENTITY_COLUMN_WITH_DEFAULT_VALUE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)col.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultValue"), (Object)((DefaultValueExpression)col.defaultValue().get()).originalSQL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identityColumnSpec"), (Object)((IdentityColumnSpec)col.identityColumnSpec().get()).toString())})));
        }
    }

    public ColumnDefinition apply(String name, DataType dataType, boolean nullable, Option<String> comment, Option<DefaultValueExpression> defaultValue, Option<String> generationExpression, Option<IdentityColumnSpec> identityColumnSpec, Metadata metadata) {
        return new ColumnDefinition(name, dataType, nullable, comment, defaultValue, generationExpression, identityColumnSpec, metadata);
    }

    public boolean apply$default$3() {
        return true;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<DefaultValueExpression> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<IdentityColumnSpec> apply$default$7() {
        return None$.MODULE$;
    }

    public Metadata apply$default$8() {
        return Metadata$.MODULE$.empty();
    }

    public Option<Tuple8<String, DataType, Object, Option<String>, Option<DefaultValueExpression>, Option<String>, Option<IdentityColumnSpec>, Metadata>> unapply(ColumnDefinition x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.name(), (Object)x$0.dataType(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.nullable()), x$0.comment(), x$0.defaultValue(), x$0.generationExpression(), x$0.identityColumnSpec(), (Object)x$0.metadata()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ColumnDefinition$.class);
    }

    public static final /* synthetic */ boolean $anonfun$checkColumnDefinitions$1(ColumnDefinition x$3) {
        return x$3.defaultValue().isDefined();
    }

    public static final /* synthetic */ void $anonfun$checkColumnDefinitions$3(ColumnDefinition col$1, String statement$2, DefaultValueExpression defaultValueExpression) {
        MODULE$.checkDefaultColumnConflicts(col$1);
        ResolveDefaultColumns$.MODULE$.validateDefaultValueExpr(defaultValueExpression, statement$2, col$1.name(), (Option<DataType>)new Some((Object)col$1.dataType()));
    }

    public static final /* synthetic */ void $anonfun$checkColumnDefinitions$2(String statement$2, ColumnDefinition col) {
        col.defaultValue().foreach((Function1 & Serializable)defaultValueExpression -> {
            ColumnDefinition$.$anonfun$checkColumnDefinitions$3(col, statement$2, defaultValueExpression);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkColumnDefinitions$4(QualifiedColType x$4) {
        return x$4.default().isDefined();
    }

    public static final /* synthetic */ void $anonfun$checkColumnDefinitions$5(QualifiedColType c) {
        c.default().foreach((Function1 & Serializable)d -> {
            ResolveDefaultColumns$.MODULE$.validateDefaultValueExpr(d, "ALTER TABLE ADD COLUMNS", c.colName(), (Option<DataType>)new Some((Object)c.dataType()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkColumnDefinitions$7(AlterColumnSpec x$5) {
        return x$5.newDefaultExpression().isDefined();
    }

    public static final /* synthetic */ void $anonfun$checkColumnDefinitions$8(AlterColumnSpec c) {
        c.newDefaultExpression().foreach((Function1 & Serializable)d -> {
            ResolveDefaultColumns$.MODULE$.validateDefaultValueExpr(d, "ALTER TABLE ALTER COLUMN", CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(c.column().name()).quoted(), (Option<DataType>)None$.MODULE$);
            return BoxedUnit.UNIT;
        });
    }

    private ColumnDefinition$() {
    }
}

