/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class AbstractFilterStringColLikeStringScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private String pattern;
    transient Checker checker = null;

    public AbstractFilterStringColLikeStringScalar() {
    }

    public AbstractFilterStringColLikeStringScalar(int colNum, String pattern) {
        this.colNum = colNum;
        this.pattern = pattern;
    }

    protected abstract List<CheckerFactory> getCheckerFactories();

    Checker createChecker(String pattern) {
        for (CheckerFactory checkerFactory : this.getCheckerFactories()) {
            Checker checker = checkerFactory.tryCreate(pattern);
            if (checker == null) continue;
            return checker;
        }
        return null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.checker == null) {
            this.checker = this.createChecker(this.pattern);
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (!this.checker.check(vector[0], start[0], length[0])) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!this.checker.check(vector[i], start[i], length[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!this.checker.check(vector[i], start[i], length[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (!this.checker.check(vector[0], start[0], length[0])) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || !this.checker.check(vector[i], start[i], length[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || !this.checker.check(vector[i], start[i], length[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", pattern " + this.pattern;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    private static class FastUTF8Decoder {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        CharBuffer charBuffer = CharBuffer.allocate(4);

        public CharBuffer decodeUnsafely(byte[] byteS, int start, int len) {
            if (this.byteBuffer.capacity() < len) {
                this.byteBuffer = ByteBuffer.allocate(len * 2);
            }
            this.byteBuffer.clear();
            this.byteBuffer.put(byteS, start, len);
            this.byteBuffer.flip();
            int maxChars = (int)((float)this.byteBuffer.capacity() * this.decoder.maxCharsPerByte());
            if (this.charBuffer.capacity() < maxChars) {
                this.charBuffer = CharBuffer.allocate(maxChars);
            }
            this.charBuffer.clear();
            this.decoder.reset();
            this.decoder.decode(this.byteBuffer, this.charBuffer, true);
            this.decoder.flush(this.charBuffer);
            this.charBuffer.flip();
            return this.charBuffer;
        }
    }

    protected static class ComplexChecker
    implements Checker {
        Pattern compiledPattern;
        Matcher matcher;
        FastUTF8Decoder decoder;

        ComplexChecker(String pattern) {
            this.compiledPattern = Pattern.compile(pattern);
            this.matcher = this.compiledPattern.matcher("");
            this.decoder = new FastUTF8Decoder();
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            this.matcher.reset(this.decoder.decodeUnsafely(byteS, start, len));
            return this.matcher.find(0);
        }
    }

    protected static final class ChainedChecker
    implements Checker {
        final int minLen;
        final BeginChecker begin;
        final EndChecker end;
        final MiddleChecker[] middle;
        final int[] midLens;
        final int beginLen;
        final int endLen;

        ChainedChecker(String pattern) {
            StringTokenizer tokens = new StringTokenizer(pattern, "%");
            boolean leftAnchor = !pattern.startsWith("%");
            boolean rightAnchor = !pattern.endsWith("%");
            int len = 0;
            BeginChecker left = null;
            EndChecker right = null;
            int leftLen = 0;
            int rightLen = 0;
            ArrayList<MiddleChecker> checkers = new ArrayList<MiddleChecker>(2);
            ArrayList<Integer> lengths = new ArrayList<Integer>(2);
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String chunk = tokens.nextToken();
                if (chunk.length() != 0) {
                    len += this.utf8Length(chunk);
                    if (leftAnchor && i == 0) {
                        left = new BeginChecker(chunk);
                        leftLen = this.utf8Length(chunk);
                    } else if (rightAnchor && !tokens.hasMoreTokens()) {
                        right = new EndChecker(chunk);
                        rightLen = this.utf8Length(chunk);
                    } else {
                        checkers.add(new MiddleChecker(chunk));
                        lengths.add(this.utf8Length(chunk));
                    }
                }
                ++i;
            }
            this.midLens = ArrayUtils.toPrimitive((Integer[])lengths.toArray(ArrayUtils.EMPTY_INTEGER_OBJECT_ARRAY));
            this.middle = checkers.toArray(new MiddleChecker[0]);
            this.minLen = len;
            this.begin = left;
            this.end = right;
            this.beginLen = leftLen;
            this.endLen = rightLen;
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            int pos = start;
            int mark = len;
            if (len < this.minLen) {
                return false;
            }
            if (this.begin != null && !this.begin.check(byteS, pos, mark)) {
                return false;
            }
            if (this.end != null && !this.end.check(byteS, pos += this.beginLen, mark -= this.beginLen)) {
                return false;
            }
            mark -= this.endLen;
            for (int i = 0; i < this.middle.length; ++i) {
                int index = this.middle[i].index(byteS, pos, mark);
                if (index == -1) {
                    return false;
                }
                mark -= index - pos + this.midLens[i];
                pos = index + this.midLens[i];
            }
            return true;
        }

        private int utf8Length(String chunk) {
            try {
                return chunk.getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException(ue);
            }
        }
    }

    protected static final class MiddleChecker
    implements Checker {
        final StringExpr.Finder finder;

        MiddleChecker(String pattern) {
            this.finder = StringExpr.compile((byte[])pattern.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            return this.index(byteS, start, len) != -1;
        }

        public int index(byte[] byteS, int start, int len) {
            return this.finder.find(byteS, start, len);
        }
    }

    protected static final class EndChecker
    implements Checker {
        final byte[] byteSub;

        EndChecker(String pattern) {
            try {
                this.byteSub = pattern.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            int lenSub = this.byteSub.length;
            if (len < lenSub) {
                return false;
            }
            return StringExpr.equal((byte[])this.byteSub, (int)0, (int)lenSub, (byte[])byteS, (int)(start + len - lenSub), (int)lenSub);
        }
    }

    protected static final class BeginChecker
    implements Checker {
        final byte[] byteSub;

        BeginChecker(String pattern) {
            try {
                this.byteSub = pattern.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            int lenSub = this.byteSub.length;
            if (len < this.byteSub.length) {
                return false;
            }
            return StringExpr.equal((byte[])this.byteSub, (int)0, (int)lenSub, (byte[])byteS, (int)start, (int)lenSub);
        }
    }

    protected static final class NoneChecker
    implements Checker {
        final byte[] byteSub;

        NoneChecker(String pattern) {
            try {
                this.byteSub = pattern.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean check(byte[] byteS, int start, int len) {
            int lenSub = this.byteSub.length;
            if (len != lenSub) {
                return false;
            }
            int i = start;
            for (int j = 0; j < len; ++j) {
                if (byteS[i] != this.byteSub[j]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    protected static interface CheckerFactory {
        public Checker tryCreate(String var1);
    }

    public static interface Checker {
        public boolean check(byte[] var1, int var2, int var3);
    }
}

