/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.FutureIOSupport;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.util.LineReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NLineInputFormat
extends FileInputFormat<LongWritable, Text> {
    public static final String LINES_PER_MAP = "mapreduce.input.lineinputformat.linespermap";

    @Override
    public RecordReader<LongWritable, Text> createRecordReader(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        context.setStatus(genericSplit.toString());
        return new LineRecordReader();
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        int numLinesPerSplit = NLineInputFormat.getNumLinesPerSplit(job);
        for (FileStatus status : this.listStatus(job)) {
            splits.addAll(NLineInputFormat.getSplitsForFile(status, job.getConfiguration(), numLinesPerSplit));
        }
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileSplit> getSplitsForFile(FileStatus status, Configuration conf, int numLinesPerSplit) throws IOException {
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        Path fileName = status.getPath();
        if (status.isDirectory()) {
            throw new IOException("Not a file: " + fileName);
        }
        try (LineReader lr = null;){
            FutureDataInputStreamBuilder builder = fileName.getFileSystem(conf).openFile(fileName);
            FutureIOSupport.propagateOptions(builder, conf, "mapreduce.job.input.file.option.", "mapreduce.job.input.file.must.");
            FSDataInputStream in = (FSDataInputStream)FutureIOSupport.awaitFuture(builder.build());
            lr = new LineReader((InputStream)in, conf);
            Text line = new Text();
            int numLines = 0;
            long begin = 0L;
            long length = 0L;
            int num = -1;
            while ((num = lr.readLine(line)) > 0) {
                length += (long)num;
                if (++numLines != numLinesPerSplit) continue;
                splits.add(NLineInputFormat.createFileSplit(fileName, begin, length));
                begin += length;
                length = 0L;
                numLines = 0;
            }
            if (numLines != 0) {
                splits.add(NLineInputFormat.createFileSplit(fileName, begin, length));
            }
        }
        return splits;
    }

    protected static FileSplit createFileSplit(Path fileName, long begin, long length) {
        return begin == 0L ? new FileSplit(fileName, begin, length - 1L, new String[0]) : new FileSplit(fileName, begin - 1L, length, new String[0]);
    }

    public static void setNumLinesPerSplit(Job job, int numLines) {
        job.getConfiguration().setInt(LINES_PER_MAP, numLines);
    }

    public static int getNumLinesPerSplit(JobContext job) {
        return job.getConfiguration().getInt(LINES_PER_MAP, 1);
    }
}

