/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Log2$;
import org.apache.spark.sql.catalyst.expressions.UnaryLogExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the logarithm of `expr` with base 2.", examples="\n    Examples:\n      > SELECT _FUNC_(2);\n       1.0\n  ", since="1.4.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u000b\u0017\u0001\u000eB\u0001\"\r\u0001\u0003\u0016\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0012)A\u0005g!)q\u0007\u0001C\u0001q!)1\b\u0001C!y!)!\n\u0001C)\u0017\"9a\nAA\u0001\n\u0003y\u0005bB)\u0001#\u0003%\tA\u0015\u0005\b;\u0002\t\t\u0011\"\u0011_\u0011\u001d9\u0007!!A\u0005\u0002!Dq\u0001\u001c\u0001\u0002\u0002\u0013\u0005Q\u000eC\u0004t\u0001\u0005\u0005I\u0011\t;\t\u000fm\u0004\u0011\u0011!C\u0001y\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0013QA\u0004\n\u0003S1\u0012\u0011!E\u0001\u0003W1\u0001\"\u0006\f\u0002\u0002#\u0005\u0011Q\u0006\u0005\u0007o=!\t!a\u000f\t\u0013\u0005ur\"!A\u0005F\u0005}\u0002\"CA!\u001f\u0005\u0005I\u0011QA\"\u0011%\t9eDA\u0001\n\u0003\u000bI\u0005C\u0005\u0002V=\t\t\u0011\"\u0003\u0002X\t!Aj\\43\u0015\t9\u0002$A\u0006fqB\u0014Xm]:j_:\u001c(BA\r\u001b\u0003!\u0019\u0017\r^1msN$(BA\u000e\u001d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011\u0003\u0002\u0001%Q9\u0002\"!\n\u0014\u000e\u0003YI!a\n\f\u0003%Us\u0017M]=M_\u001e,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\b!J|G-^2u!\tIs&\u0003\u00021U\ta1+\u001a:jC2L'0\u00192mK\u0006)1\r[5mIV\t1\u0007\u0005\u0002&i%\u0011QG\u0006\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003si\u0002\"!\n\u0001\t\u000bE\u001a\u0001\u0019A\u001a\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA\u001fD\u0011B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IF\u0001\bG>$WmZ3o\u0013\t\u0011uH\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015!E\u00011\u0001F\u0003\r\u0019G\u000f\u001f\t\u0003}\u0019K!aR \u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")\u0011\n\u0002a\u0001{\u0005\u0011QM^\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0005eb\u0005\"B'\u0006\u0001\u0004\u0019\u0014\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u0003sACq!\r\u0004\u0011\u0002\u0003\u00071'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003MS#a\r+,\u0003U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\u0013Ut7\r[3dW\u0016$'B\u0001.+\u0003)\tgN\\8uCRLwN\\\u0005\u00039^\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006!A.\u00198h\u0015\u0005!\u0017\u0001\u00026bm\u0006L!AZ1\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005I\u0007CA\u0015k\u0013\tY'FA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002ocB\u0011\u0011f\\\u0005\u0003a*\u00121!\u00118z\u0011\u001d\u0011(\"!AA\u0002%\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014X#A;\u0011\u0007YLh.D\u0001x\u0015\tA(&\u0001\u0006d_2dWm\u0019;j_:L!A_<\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004{\u0006\u0005\u0001CA\u0015\u007f\u0013\ty(FA\u0004C_>dW-\u00198\t\u000fId\u0011\u0011!a\u0001]\u00061Q-];bYN$2!`A\u0004\u0011\u001d\u0011X\"!AA\u00029D3\u0003AA\u0006\u0003#\t\u0019\"a\u0006\u0002\u001a\u0005u\u0011qDA\u0012\u0003K\u00012!JA\u0007\u0013\r\tyA\u0006\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t)\"A\u001e`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t7pO\u0006\u0014\u0018\u000e\u001e5nA=4\u0007\u0005Y3yaJ\u0004\u0007e^5uQ\u0002\u0012\u0017m]3!e9\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u00037\taG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\f\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!\t\u0002\u000bErCG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u001d\u0012AC7bi\"|f-\u001e8dg\u0006!Aj\\43!\t)sb\u0005\u0003\u0010\u0003_q\u0003CBA\u0019\u0003o\u0019\u0014(\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0016\u0002\u000fI,h\u000e^5nK&!\u0011\u0011HA\u001a\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002?\u0006)\u0011\r\u001d9msR\u0019\u0011(!\u0012\t\u000bE\u0012\u0002\u0019A\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111JA)!\u0011I\u0013QJ\u001a\n\u0007\u0005=#F\u0001\u0004PaRLwN\u001c\u0005\t\u0003'\u001a\u0012\u0011!a\u0001s\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u00022\u0001YA.\u0013\r\ti&\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class Log2
extends UnaryLogExpression {
    private final Expression child;

    public static Option<Expression> unapply(Log2 log2) {
        return Log2$.MODULE$.unapply(log2);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Log2, A> function1) {
        return Log2$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Log2> compose(Function1<A, Expression> function1) {
        return Log2$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & java.io.Serializable & Serializable)c -> new StringBuilder(144).append("\n        if (").append((String)c).append(" <= ").append(this.yAsymptote()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = java.lang.StrictMath.log(").append((String)c).append(") / java.lang.StrictMath.log(2);\n        }\n      ").toString());
    }

    @Override
    public Log2 withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Log2 copy(Expression child) {
        return new Log2(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Log2";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Log2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Log2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Log2 log2 = (Log2)x$1;
        Expression expression = this.child();
        Expression expression2 = log2.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!log2.canEqual(this)) return false;
        return true;
    }

    public Log2(Expression child) {
        this.child = child;
        super((Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return StrictMath.log(x) / StrictMath.log(2.0);
            }
        }, "LOG2");
    }
}

