/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.io.LongWritable;

class LongTransformerAdapter
extends AbstractTransformerAdapter {
    final LongObjectInspector columnType;
    final LongWritable writable;

    public LongTransformerAdapter(LongObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new LongWritable());
    }

    public LongTransformerAdapter(LongObjectInspector columnType, AbstractTransformer transformer, LongWritable writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        Long transformedValue;
        Long value = (Long)this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue.longValue());
            return this.writable;
        }
        return null;
    }
}

