/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileBase;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric\n       or ANSI interval column `col` at the given percentage. The value of percentage must be\n       between 0.0 and 1.0. The value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 0.3) FROM VALUES (0), (10) AS tab(col);\n       3.0\n      > SELECT _FUNC_(col, array(0.25, 0.75)) FROM VALUES (0), (10) AS tab(col);\n       [2.5,7.5]\n      > SELECT _FUNC_(col, 0.5) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-5\n      > SELECT _FUNC_(col, array(0.2, 0.5)) FROM VALUES (INTERVAL '0' SECOND), (INTERVAL '10' SECOND) AS tab(col);\n       [0 00:00:02.000000000,0 00:00:05.000000000]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\t5c\u0001\u0002\u001b6\u0001\u0012C\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\t=\u0002\u0011\t\u0012)A\u0005\u001f\"Aq\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005a\u0001\tE\t\u0015!\u0003P\u0011!\t\u0007A!f\u0001\n\u0003i\u0006\u0002\u00032\u0001\u0005#\u0005\u000b\u0011B(\t\u0011\r\u0004!Q3A\u0005\u0002\u0011D\u0001\u0002\u001b\u0001\u0003\u0012\u0003\u0006I!\u001a\u0005\tS\u0002\u0011)\u001a!C\u0001I\"A!\u000e\u0001B\tB\u0003%Q\r\u0003\u0005l\u0001\tU\r\u0011\"\u0001m\u0011!\u0001\bA!E!\u0002\u0013i\u0007\"B9\u0001\t\u0003\u0011\b\"B9\u0001\t\u0003Q\b\"B9\u0001\t\u0003i\bBB9\u0001\t\u0003\t)\u0001\u0003\u0004\u0002\u000e\u0001!\t%\u0018\u0005\u0007\u0003\u001f\u0001A\u0011I/\t\r\u0005E\u0001\u0001\"\u0011^\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aa!!\f\u0001\t\u0003b\u0007bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003o\u0001A\u0011IA\u001d\u0011\u001d\ty\u0004\u0001C)\u0003\u0003Bq!a\u0017\u0001\t#\ni\u0006C\u0005\u0002l\u0001\t\t\u0011\"\u0001\u0002n!I\u00111\u0010\u0001\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003'\u0003\u0011\u0013!C\u0001\u0003{B\u0011\"!&\u0001#\u0003%\t!! \t\u0013\u0005]\u0005!%A\u0005\u0002\u0005e\u0005\"CAO\u0001E\u0005I\u0011AAM\u0011%\ty\nAI\u0001\n\u0003\t\t\u000bC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\"A\u0011q\u0017\u0001\u0002\u0002\u0013\u0005A\rC\u0005\u0002:\u0002\t\t\u0011\"\u0001\u0002<\"I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003\u001f\u0004\u0011\u0011!C\u0001\u0003#D\u0011\"!6\u0001\u0003\u0003%\t%a6\b\u0013\u0005mX'!A\t\u0002\u0005uh\u0001\u0003\u001b6\u0003\u0003E\t!a@\t\rEDC\u0011\u0001B\u0007\u0011%\u0011y\u0001KA\u0001\n\u000b\u0012\t\u0002C\u0005\u0003\u0014!\n\t\u0011\"!\u0003\u0016!I!1\u0005\u0015\u0012\u0002\u0013\u0005\u0011\u0011\u0014\u0005\n\u0005KA\u0013\u0013!C\u0001\u00033C\u0011Ba\n)#\u0003%\t!!)\t\u0013\t%\u0002&!A\u0005\u0002\n-\u0002\"\u0003B\u001fQE\u0005I\u0011AAM\u0011%\u0011y\u0004KI\u0001\n\u0003\tI\nC\u0005\u0003B!\n\n\u0011\"\u0001\u0002\"\"I!1\t\u0015\u0002\u0002\u0013%!Q\t\u0002\u000b!\u0016\u00148-\u001a8uS2,'B\u0001\u001c8\u0003%\twm\u001a:fO\u0006$XM\u0003\u00029s\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tQ4(\u0001\u0005dCR\fG._:u\u0015\taT(A\u0002tc2T!AP \u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u0015\u0001Q)S*Z!\t1u)D\u00016\u0013\tAUG\u0001\bQKJ\u001cWM\u001c;jY\u0016\u0014\u0015m]3\u0011\u0007)ku*D\u0001L\u0015\ta\u0015(A\u0003ue\u0016,7/\u0003\u0002O\u0017\nYA+\u001a:oCJLH*[6f!\t\u0001\u0016+D\u00018\u0013\t\u0011vG\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002U5&\u00111,\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u001f\u000611\r[5mI\u0002\nA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0017!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000eI\u0001\u0014MJ,\u0017/^3oGf,\u0005\u0010\u001d:fgNLwN\\\u0001\u0015MJ,\u0017/^3oGf,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012!\u001a\t\u0003)\u001aL!aZ+\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%A\u0004sKZ,'o]3\u0016\u00035\u0004\"\u0001\u00168\n\u0005=,&a\u0002\"p_2,\u0017M\\\u0001\te\u00164XM]:fA\u00051A(\u001b8jiz\"ra\u001d;vm^D\u0018\u0010\u0005\u0002G\u0001!)A,\u0004a\u0001\u001f\")q,\u0004a\u0001\u001f\")\u0011-\u0004a\u0001\u001f\"91-\u0004I\u0001\u0002\u0004)\u0007bB5\u000e!\u0003\u0005\r!\u001a\u0005\bW6\u0001\n\u00111\u0001n)\r\u00198\u0010 \u0005\u00069:\u0001\ra\u0014\u0005\u0006?:\u0001\ra\u0014\u000b\u0006gz|\u0018\u0011\u0001\u0005\u00069>\u0001\ra\u0014\u0005\u0006?>\u0001\ra\u0014\u0005\u0007\u0003\u0007y\u0001\u0019A(\u0002\u0013\u0019\u0014X-];f]\u000eLHcB:\u0002\b\u0005%\u00111\u0002\u0005\u00069B\u0001\ra\u0014\u0005\u0006?B\u0001\ra\u0014\u0005\u0006WB\u0001\r!\\\u0001\u0006M&\u00148\u000f^\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000bQD\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0014\u001d\u0011\tY\"a\t\u0011\u0007\u0005uQ+\u0004\u0002\u0002 )\u0019\u0011\u0011E\"\u0002\rq\u0012xn\u001c;?\u0013\r\t)#V\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00121\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015R+\u0001\u0005eSN\u001c'/\u001a;f\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HcA:\u00024!1\u0011Q\u0007\fA\u0002\u0015\f\u0011D\\3x\u001bV$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006Yr/\u001b;i\u001d\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2a]A\u001e\u0011\u0019\tid\u0006a\u0001K\u00069b.Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u000bgR\u0014\u0018N\\4Be\u001e\u001cXCAA\"!\u0019\t)%a\u0014\u0002V9!\u0011qIA&\u001d\u0011\ti\"!\u0013\n\u0003YK1!!\u0014V\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0015\u0002T\tA\u0011\n^3sCR|'OC\u0002\u0002NU\u00032\u0001VA,\u0013\r\tI&\u0016\u0002\u0004\u0003:L\u0018aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001d\u0019\u0018qLA2\u0003OBa!!\u0019\u001a\u0001\u0004y\u0015\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005\u0015\u0014\u00041\u0001P\u0003%qWm^*fG>tG\r\u0003\u0004\u0002je\u0001\raT\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)5\u0019\u0018qNA9\u0003g\n)(a\u001e\u0002z!9AL\u0007I\u0001\u0002\u0004y\u0005bB0\u001b!\u0003\u0005\ra\u0014\u0005\bCj\u0001\n\u00111\u0001P\u0011\u001d\u0019'\u0004%AA\u0002\u0015Dq!\u001b\u000e\u0011\u0002\u0003\u0007Q\rC\u0004l5A\u0005\t\u0019A7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0010\u0016\u0004\u001f\u0006\u00055FAAB!\u0011\t))a$\u000e\u0005\u0005\u001d%\u0002BAE\u0003\u0017\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055U+\u0001\u0006b]:|G/\u0019;j_:LA!!%\u0002\b\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00037S3!ZAA\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0002$*\u001aQ.!!\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000b\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\t1\fgn\u001a\u0006\u0003\u0003g\u000bAA[1wC&!\u0011\u0011FAW\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0016\u0002>\"A\u0011qX\u0012\u0002\u0002\u0003\u0007Q-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u000b\u0004b!a2\u0002N\u0006USBAAe\u0015\r\tY-V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA)\u0003\u0013\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004[\u0006M\u0007\"CA`K\u0005\u0005\t\u0019AA+\u0003\u0019)\u0017/^1mgR\u0019Q.!7\t\u0013\u0005}f%!AA\u0002\u0005U\u0003f\u0005\u0001\u0002^\u0006\r\u0018Q]Au\u0003W\fy/!=\u0002v\u0006]\bc\u0001)\u0002`&\u0019\u0011\u0011]\u001c\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011q]\u0001\u0005|)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011qKJ\u001cWM\u001c;bO\u0016\u00043\f\f\u0011ge\u0016\fX/\u001a8dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001a=bGR\u0004\u0003/\u001a:dK:$\u0018\u000e\\3!m\u0006dW/\u001a\u0011pM\u0002rW/\\3sS\u000eT\u0001\u0005\t\u0011!A\u0001\u0002sN\u001d\u0011B\u001dNK\u0005%\u001b8uKJ4\u0018\r\u001c\u0011d_2,XN\u001c\u0011aG>d\u0007\rI1uAQDW\rI4jm\u0016t\u0007\u0005]3sG\u0016tG/Y4f]\u0001\"\u0006.\u001a\u0011wC2,X\rI8gAA,'oY3oi\u0006<W\rI7vgR\u0004#-\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,\u0007\u0005]8tSRLg/\u001a\u0011j]R,wM]1m\u0015)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011beJ\f\u0017\u0010\u000b9fe\u000e,g\u000e^1hKF\u00023\f\f\u0011qKJ\u001cWM\u001c;bO\u0016\u0014TL\f\u0018/S\u0001ZF\u0006\t4sKF,XM\\2z;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004S\r_1di*\u0001\u0003\u0005\t\u0011!AA,'oY3oi&dW\r\t<bYV,\u0007%\u0019:sCf\u0004sN\u001a\u0011ok6,'/[2!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,g\u000e\t9fe\u000e,g\u000e^1hK\"\u001a\u0018F\f\u0011FC\u000eD\u0007E^1mk\u0016T\u0001\u0005\t\u0011!A\u0001zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t4sKF,XM\\2zAMDw.\u001e7eA\t,'\u0002\t\u0011!A\u0001\u0002\u0003o\\:ji&4X\rI5oi\u0016<'/\u00197\u000b\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAw\u0003\r=&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY2\u0002\u0003GL\u001a*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005K\u00191S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMr\u0003G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u0019:sCfD\u0003G\f\u001a6Y\u0001\u0002dfN\u001b*S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152a%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&GL\u001b-o9*TL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003\u0005\r\u00186S\u00012%kT'!-\u0006cU+R*!Q%sE+\u0012*W\u00032\u0003s\u0005M\u0014!\u001b>sE\u000bS\u0015-A!Je\nV#S-\u0006c\u0005eJ\u00191O\u0001juJ\u0014+IS\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AAjSG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003%\u0019:sCfD\u0003G\f\u001a-AArS'K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u0015J\u001dR+%KV!MA\u001d\u0002t\u0005I*F\u0007>sE)\u000b\u0017!Q%sE+\u0012*W\u00032\u0003s%\r\u0019(AM+5i\u0014(ES\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0003\u0004\u0005\r\u0019;aAR\u0004G\r\u00181aA\u0002\u0004\u0007\r\u00191a1\u0002\u0004\u0005\r\u0019;aAR\u0004'\u000e\u00181aA\u0002\u0004\u0007\r\u00191auS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003g\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005e\u0018!\u0002\u001a/c9\u0002\u0014A\u0003)fe\u000e,g\u000e^5mKB\u0011a\tK\n\u0005Q\t\u0005\u0011\fE\u0006\u0003\u0004\t%qjT(fK6\u001cXB\u0001B\u0003\u0015\r\u00119!V\u0001\beVtG/[7f\u0013\u0011\u0011YA!\u0002\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007\u0006\u0002\u0002~\u0006AAo\\*ue&tw\r\u0006\u0002\u0002*\u0006)\u0011\r\u001d9msRi1Oa\u0006\u0003\u001a\tm!Q\u0004B\u0010\u0005CAQ\u0001X\u0016A\u0002=CQaX\u0016A\u0002=CQ!Y\u0016A\u0002=CqaY\u0016\u0011\u0002\u0003\u0007Q\rC\u0004jWA\u0005\t\u0019A3\t\u000f-\\\u0003\u0013!a\u0001[\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u00122\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005[\u0011I\u0004E\u0003U\u0005_\u0011\u0019$C\u0002\u00032U\u0013aa\u00149uS>t\u0007#\u0003+\u00036={u*Z3n\u0013\r\u00119$\u0016\u0002\u0007)V\u0004H.\u001a\u001c\t\u0011\tmr&!AA\u0002M\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0012\u0011\t\u0005-&\u0011J\u0005\u0005\u0005\u0017\niK\u0001\u0004PE*,7\r\u001e")
public class Percentile
extends PercentileBase
implements TernaryLike<Expression>,
scala.Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final boolean reverse;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$6() {
        return Percentile$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple6<Expression, Expression, Expression, Object, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static boolean apply$default$6() {
        return Percentile$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple6<Expression, Expression, Expression, Object, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Function1<Object, Percentile>>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    @Override
    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public boolean reverse() {
        return this.reverse;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.percentageExpression();
    }

    @Override
    public Expression third() {
        return this.frequencyExpression();
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public boolean discrete() {
        return false;
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        boolean x$6 = this.copy$default$6();
        return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    @Override
    public Iterator<Object> stringArgs() {
        if (this.discrete()) {
            return super.stringArgs().$plus$plus((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToBoolean((boolean)this.discrete()))));
        }
        return super.stringArgs();
    }

    @Override
    public Percentile withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset, boolean reverse) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset, reverse);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    public boolean copy$default$6() {
        return this.reverse();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.percentageExpression();
            }
            case 2: {
                return this.frequencyExpression();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
            case 5: {
                return BoxesRunTime.boxToBoolean((boolean)this.reverse());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (this.reverse() != percentile.reverse()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset, boolean reverse) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.reverse = reverse;
        TernaryLike.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0, Percentile$.MODULE$.$lessinit$greater$default$6());
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0, Percentile$.MODULE$.$lessinit$greater$default$6());
    }

    public Percentile(Expression child, Expression percentageExpression, boolean reverse) {
        Expression x$1 = child;
        Expression x$2 = percentageExpression;
        Literal x$3 = Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L));
        boolean x$4 = reverse;
        int x$5 = Percentile$.MODULE$.$lessinit$greater$default$4();
        int x$6 = Percentile$.MODULE$.$lessinit$greater$default$5();
        this(x$1, x$2, x$3, x$5, x$6, x$4);
    }
}

