/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.insight;

import com.alipay.sofa.common.config.log.ConfigLoggerFactory;
import com.alipay.sofa.common.insight.NoopRecorder;
import com.alipay.sofa.common.insight.Recorder;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class RecorderManager {
    private static final Logger LOGGER = ConfigLoggerFactory.getLogger(RecorderManager.class);
    private static final AtomicReference<Recorder> RECORDER = new AtomicReference<NoopRecorder>(NoopRecorder.INSTANCE);

    public static Recorder getRecorder() {
        return RECORDER.get();
    }

    public static void init() {
        Recorder targetRecorder = null;
        ServiceLoader<Recorder> loader = ServiceLoader.load(Recorder.class);
        Iterator<Recorder> iterator = loader.iterator();
        if (iterator.hasNext()) {
            targetRecorder = iterator.next();
        }
        if (targetRecorder != null) {
            boolean state = RECORDER.compareAndSet(NoopRecorder.INSTANCE, targetRecorder);
            if (state) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Init recorder successfully, class: {}", (Object)targetRecorder.getClass().getName());
                }
            } else {
                LOGGER.warn("Cannot init recorder repeatedly ");
            }
        }
    }
}

