/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.internal;

import java.util.Arrays;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.internal.BoundedQueue;
import zipkin2.reporter.internal.SpanWithSizeConsumer;

final class CountBoundedQueue<S>
extends BoundedQueue<S> {
    final ReentrantLock lock = new ReentrantLock(false);
    final Condition available = this.lock.newCondition();
    final BytesEncoder<S> encoder;
    final BytesMessageSender sender;
    final ReporterMetrics metrics;
    final int messageMaxBytes;
    final int maxSize;
    final S[] elements;
    int count;
    int writePos;
    int readPos;

    CountBoundedQueue(BytesEncoder<S> encoder, BytesMessageSender sender, ReporterMetrics metrics, int messageMaxBytes, int maxSize) {
        this.encoder = encoder;
        this.sender = sender;
        this.metrics = metrics;
        this.messageMaxBytes = messageMaxBytes;
        this.elements = new Object[maxSize];
        this.maxSize = maxSize;
    }

    @Override
    public boolean offer(S next, int nextSizeInBytes) {
        return this.offer(next);
    }

    @Override
    public boolean offer(S next) {
        this.lock.lock();
        try {
            if (this.count == this.maxSize) {
                boolean bl = false;
                return bl;
            }
            this.elements[this.writePos++] = next;
            if (this.writePos == this.maxSize) {
                this.writePos = 0;
            }
            ++this.count;
            this.available.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    int drainTo(SpanWithSizeConsumer<S> consumer, long nanosTimeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int clear() {
        this.lock.lock();
        try {
            int result = this.count;
            this.writePos = 0;
            this.readPos = 0;
            this.count = 0;
            Arrays.fill(this.elements, null);
            int n = result;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    int doDrain(SpanWithSizeConsumer<S> consumer) {
        S next;
        int drainedCount;
        for (drainedCount = 0; drainedCount < this.count && (next = this.elements[this.readPos]) != null; ++drainedCount) {
            int nextSizeInBytes = this.encoder.sizeInBytes(next);
            int messageSizeOfNextSpan = this.sender.messageSizeInBytes(nextSizeInBytes);
            this.metrics.incrementSpanBytes(nextSizeInBytes);
            if (messageSizeOfNextSpan > this.messageMaxBytes) {
                this.metrics.incrementSpansDropped(1);
            } else if (!consumer.offer(next, nextSizeInBytes)) break;
            this.elements[this.readPos] = null;
            if (++this.readPos != this.elements.length) continue;
            this.readPos = 0;
        }
        this.count -= drainedCount;
        return drainedCount;
    }

    @Override
    int maxSize() {
        return this.maxSize;
    }
}

