/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.http;

import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.exception.ServiceException;
import com.huaweicloud.lts.producer.http.ClientConfiguration;
import com.huaweicloud.lts.producer.model.http.HttpMessage;
import com.huaweicloud.lts.producer.model.http.HttpMethod;
import com.huaweicloud.lts.producer.model.http.RequestMessage;
import com.huaweicloud.lts.producer.model.http.ResponseMessage;
import com.huaweicloud.lts.producer.util.HttpUtil;
import com.huaweicloud.lts.producer.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public abstract class ServiceClient {
    private static final int DEFAULT_MARK_LIMIT = 4096;
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, String charset) throws ServiceException, ClientException {
        Utils.assertArgumentNotNull(request, "request");
        Utils.assertArgumentNotNullOrEmpty(charset, "charset");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, charset);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ResponseMessage sendRequestImpl(RequestMessage request, String charset) throws ClientException, ServiceException {
        try {
            Request httpRequest = this.buildRequest(request, charset);
            return this.sendRequestCore(httpRequest, charset);
        }
        catch (Exception ex) {
            throw new ClientException(ex.getMessage(), ex);
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, String var2) throws Exception;

    private Request buildRequest(RequestMessage requestMessage, String charset) throws ClientException {
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setHeaders(requestMessage.getHeaders());
        request.getHeaders().putAll(requestMessage.getSignRequest().getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), charset);
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean putParamsInUri = !requestIsPost || requestHasNoPayload;
        String uri = requestMessage.getRequestUrl();
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(charset);
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    public abstract void shutdown();

    public static class Request
    extends HttpMessage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

