/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.relay;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.service.channel.SimpleChannel;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayResult;
import org.apache.rocketmq.proxy.service.relay.ProxyRelayService;
import org.apache.rocketmq.proxy.service.relay.RelayData;
import org.apache.rocketmq.proxy.service.transaction.TransactionData;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;

public abstract class ProxyChannel
extends SimpleChannel {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final SocketAddress remoteSocketAddress;
    protected final SocketAddress localSocketAddress;
    protected final ProxyRelayService proxyRelayService;

    protected ProxyChannel(ProxyRelayService proxyRelayService, Channel parent, String remoteAddress, String localAddress) {
        super(parent, remoteAddress, localAddress);
        this.proxyRelayService = proxyRelayService;
        this.remoteSocketAddress = NetworkUtil.string2SocketAddress((String)remoteAddress);
        this.localSocketAddress = NetworkUtil.string2SocketAddress((String)localAddress);
    }

    protected ProxyChannel(ProxyRelayService proxyRelayService, Channel parent, ChannelId id, String remoteAddress, String localAddress) {
        super(parent, id, remoteAddress, localAddress);
        this.proxyRelayService = proxyRelayService;
        this.remoteSocketAddress = NetworkUtil.string2SocketAddress((String)remoteAddress);
        this.localSocketAddress = NetworkUtil.string2SocketAddress((String)localAddress);
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        CompletableFuture<Object> processFuture = new CompletableFuture();
        try {
            if (msg instanceof RemotingCommand) {
                ProxyContext context = ProxyContext.createForInner(((Object)((Object)this)).getClass()).setRemoteAddress(this.remoteAddress).setLocalAddress(this.localAddress);
                RemotingCommand command = (RemotingCommand)msg;
                if (command.getExtFields() == null) {
                    command.setExtFields(new HashMap());
                }
                switch (command.getCode()) {
                    case 39: {
                        CheckTransactionStateRequestHeader header = (CheckTransactionStateRequestHeader)command.readCustomHeader();
                        MessageExt messageExt = MessageDecoder.decode((ByteBuffer)ByteBuffer.wrap(command.getBody()), (boolean)true, (boolean)false, (boolean)false);
                        RelayData<TransactionData, Void> relayData = this.proxyRelayService.processCheckTransactionState(context, command, header, messageExt);
                        processFuture = this.processCheckTransaction(header, messageExt, relayData.getProcessResult(), relayData.getRelayFuture());
                        break;
                    }
                    case 307: {
                        GetConsumerRunningInfoRequestHeader header = (GetConsumerRunningInfoRequestHeader)command.readCustomHeader();
                        CompletableFuture<ProxyRelayResult<ConsumerRunningInfo>> relayFuture = this.proxyRelayService.processGetConsumerRunningInfo(context, command, header);
                        processFuture = this.processGetConsumerRunningInfo(command, header, relayFuture);
                        break;
                    }
                    case 309: {
                        ConsumeMessageDirectlyResultRequestHeader header = (ConsumeMessageDirectlyResultRequestHeader)command.readCustomHeader();
                        MessageExt messageExt = MessageDecoder.decode((ByteBuffer)ByteBuffer.wrap(command.getBody()), (boolean)true, (boolean)false, (boolean)false);
                        processFuture = this.processConsumeMessageDirectly(command, header, messageExt, this.proxyRelayService.processConsumeMessageDirectly(context, command, header));
                        break;
                    }
                }
            } else {
                processFuture = this.processOtherMessage(msg);
            }
        }
        catch (Throwable t2) {
            log.error("process failed. msg:{}", msg, (Object)t2);
            processFuture.completeExceptionally(t2);
        }
        DefaultChannelPromise promise = new DefaultChannelPromise((Channel)this, (EventExecutor)GlobalEventExecutor.INSTANCE);
        ((CompletableFuture)processFuture.thenAccept(ignore -> promise.setSuccess())).exceptionally(t -> {
            promise.setFailure(t);
            return null;
        });
        return promise;
    }

    protected abstract CompletableFuture<Void> processOtherMessage(Object var1);

    protected abstract CompletableFuture<Void> processCheckTransaction(CheckTransactionStateRequestHeader var1, MessageExt var2, TransactionData var3, CompletableFuture<ProxyRelayResult<Void>> var4);

    protected abstract CompletableFuture<Void> processGetConsumerRunningInfo(RemotingCommand var1, GetConsumerRunningInfoRequestHeader var2, CompletableFuture<ProxyRelayResult<ConsumerRunningInfo>> var3);

    protected abstract CompletableFuture<Void> processConsumeMessageDirectly(RemotingCommand var1, ConsumeMessageDirectlyResultRequestHeader var2, MessageExt var3, CompletableFuture<ProxyRelayResult<ConsumeMessageDirectlyResult>> var4);

    @Override
    public ChannelConfig config() {
        return null;
    }

    @Override
    public ChannelMetadata metadata() {
        return null;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return null;
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return false;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
    }

    @Override
    protected void doClose() throws Exception {
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.localSocketAddress;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remoteSocketAddress;
    }
}

