/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.ProtocolDetectionResult;
import io.netty.handler.codec.ProtocolDetectionState;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.BinaryUtil;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.TlsMode;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.AttributeKeys;
import org.apache.rocketmq.remoting.netty.FileRegionEncoder;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.remoting.netty.RemotingCodeDistributionHandler;
import org.apache.rocketmq.remoting.netty.TlsHelper;
import org.apache.rocketmq.remoting.netty.TlsSystemConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final Logger TRAFFIC_LOGGER = LoggerFactory.getLogger((String)"RocketmqTraffic");
    private final ServerBootstrap serverBootstrap;
    protected final EventLoopGroup eventLoopGroupSelector;
    protected final EventLoopGroup eventLoopGroupBoss;
    protected final NettyServerConfig nettyServerConfig;
    private final ExecutorService publicExecutor;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ChannelEventListener channelEventListener;
    private final HashedWheelTimer timer = new HashedWheelTimer(r -> new Thread(r, "ServerHouseKeepingService"));
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final ConcurrentMap<Integer, NettyRemotingAbstract> remotingServerTable = new ConcurrentHashMap<Integer, NettyRemotingAbstract>();
    public static final String HANDSHAKE_HANDLER_NAME = "handshakeHandler";
    public static final String HA_PROXY_DECODER = "HAProxyDecoder";
    public static final String HA_PROXY_HANDLER = "HAProxyHandler";
    public static final String TLS_MODE_HANDLER = "TlsModeHandler";
    public static final String TLS_HANDLER_NAME = "sslHandler";
    public static final String FILE_REGION_ENCODER_NAME = "fileRegionEncoder";
    protected final TlsModeHandler tlsModeHandler = new TlsModeHandler(TlsSystemConfig.tlsMode);
    protected final NettyEncoder encoder = new NettyEncoder();
    protected final NettyConnectManageHandler connectionManageHandler = new NettyConnectManageHandler();
    protected final NettyServerHandler serverHandler = new NettyServerHandler();
    protected final RemotingCodeDistributionHandler distributionHandler = new RemotingCodeDistributionHandler();

    public NettyRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null);
    }

    public NettyRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig.getServerOnewaySemaphoreValue(), nettyServerConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.nettyServerConfig = nettyServerConfig;
        this.channelEventListener = channelEventListener;
        this.publicExecutor = this.buildPublicExecutor(nettyServerConfig);
        this.scheduledExecutorService = this.buildScheduleExecutor();
        this.eventLoopGroupBoss = this.buildEventLoopGroupBoss();
        this.eventLoopGroupSelector = this.buildEventLoopGroupSelector();
        this.loadSslContext();
    }

    protected EventLoopGroup buildEventLoopGroupSelector() {
        if (this.useEpoll()) {
            return new EpollEventLoopGroup(this.nettyServerConfig.getServerSelectorThreads(), (ThreadFactory)new ThreadFactoryImpl("NettyServerEPOLLSelector_"));
        }
        return new NioEventLoopGroup(this.nettyServerConfig.getServerSelectorThreads(), (ThreadFactory)new ThreadFactoryImpl("NettyServerNIOSelector_"));
    }

    protected EventLoopGroup buildEventLoopGroupBoss() {
        if (this.useEpoll()) {
            return new EpollEventLoopGroup(1, (ThreadFactory)new ThreadFactoryImpl("NettyEPOLLBoss_"));
        }
        return new NioEventLoopGroup(1, (ThreadFactory)new ThreadFactoryImpl("NettyNIOBoss_"));
    }

    private ExecutorService buildPublicExecutor(NettyServerConfig nettyServerConfig) {
        int publicThreadNums = nettyServerConfig.getServerCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        return Executors.newFixedThreadPool(publicThreadNums, (ThreadFactory)new ThreadFactoryImpl("NettyServerPublicExecutor_"));
    }

    private ScheduledExecutorService buildScheduleExecutor() {
        return ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)new ThreadFactoryImpl("NettyServerScheduler_", true), (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void loadSslContext() {
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        log.info("Server is running in TLS {} mode", (Object)tlsMode.getName());
        if (tlsMode != TlsMode.DISABLED) {
            try {
                this.sslContext = TlsHelper.buildSslContext(false);
                log.info("SslContext created for server");
            }
            catch (IOException | CertificateException e) {
                log.error("Failed to create SslContext for server", (Throwable)e);
            }
        }
    }

    private boolean useEpoll() {
        return NetworkUtil.isLinuxPlatform() && this.nettyServerConfig.isUseEpollNativeSelector() && Epoll.isAvailable();
    }

    protected void initServerBootstrap(ServerBootstrap serverBootstrap) {
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupSelector).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)false).childOption(ChannelOption.TCP_NODELAY, (Object)true).localAddress((SocketAddress)new InetSocketAddress(this.nettyServerConfig.getBindAddress(), this.nettyServerConfig.getListenPort()))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                NettyRemotingServer.this.configChannel(ch);
            }
        });
        this.addCustomConfig(serverBootstrap);
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), (ThreadFactory)new ThreadFactoryImpl("NettyServerCodecThread_"));
        this.initServerBootstrap(this.serverBootstrap);
        try {
            ChannelFuture sync = this.serverBootstrap.bind().sync();
            InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
            if (0 == this.nettyServerConfig.getListenPort()) {
                this.nettyServerConfig.setListenPort(addr.getPort());
            }
            log.info("RemotingServer started, listening {}:{}", (Object)this.nettyServerConfig.getBindAddress(), (Object)this.nettyServerConfig.getListenPort());
            this.remotingServerTable.put(this.nettyServerConfig.getListenPort(), this);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to bind to %s:%d", this.nettyServerConfig.getBindAddress(), this.nettyServerConfig.getListenPort()), e);
        }
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
        TimerTask timerScanResponseTable = new TimerTask(){

            public void run(Timeout timeout) {
                try {
                    NettyRemotingServer.this.scanResponseTable();
                }
                catch (Throwable e) {
                    log.error("scanResponseTable exception", e);
                }
                finally {
                    NettyRemotingServer.this.timer.newTimeout((TimerTask)this, 1000L, TimeUnit.MILLISECONDS);
                }
            }
        };
        this.timer.newTimeout(timerScanResponseTable, 3000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this.printRemotingCodeDistribution();
            }
            catch (Throwable e) {
                TRAFFIC_LOGGER.error("NettyRemotingServer print remoting code distribution exception", e);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    protected ChannelPipeline configChannel(SocketChannel ch) {
        return ch.pipeline().addLast((EventExecutorGroup)(this.nettyServerConfig.isServerNettyWorkerGroupEnable() ? this.defaultEventExecutorGroup : null), HANDSHAKE_HANDLER_NAME, (ChannelHandler)new HandshakeHandler()).addLast((EventExecutorGroup)(this.nettyServerConfig.isServerNettyWorkerGroupEnable() ? this.defaultEventExecutorGroup : null), new ChannelHandler[]{this.encoder, new NettyDecoder(), this.distributionHandler, new IdleStateHandler(0, 0, this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), this.connectionManageHandler, this.serverHandler});
    }

    private void addCustomConfig(ServerBootstrap childHandler) {
        if (this.nettyServerConfig.getServerSocketSndBufSize() > 0) {
            log.info("server set SO_SNDBUF to {}", (Object)this.nettyServerConfig.getServerSocketSndBufSize());
            childHandler.childOption(ChannelOption.SO_SNDBUF, (Object)this.nettyServerConfig.getServerSocketSndBufSize());
        }
        if (this.nettyServerConfig.getServerSocketRcvBufSize() > 0) {
            log.info("server set SO_RCVBUF to {}", (Object)this.nettyServerConfig.getServerSocketRcvBufSize());
            childHandler.childOption(ChannelOption.SO_RCVBUF, (Object)this.nettyServerConfig.getServerSocketRcvBufSize());
        }
        if (this.nettyServerConfig.getWriteBufferLowWaterMark() > 0 && this.nettyServerConfig.getWriteBufferHighWaterMark() > 0) {
            log.info("server set netty WRITE_BUFFER_WATER_MARK to {},{}", (Object)this.nettyServerConfig.getWriteBufferLowWaterMark(), (Object)this.nettyServerConfig.getWriteBufferHighWaterMark());
            childHandler.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.nettyServerConfig.getWriteBufferLowWaterMark(), this.nettyServerConfig.getWriteBufferHighWaterMark()));
        }
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            childHandler.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.nettyServerConfig.isEnableShutdownGracefully() && this.isShuttingDown.compareAndSet(false, true)) {
                Thread.sleep(Duration.ofSeconds(this.nettyServerConfig.getShutdownWaitTimeSeconds()).toMillis());
            }
            this.timer.stop();
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupSelector.shutdownGracefully();
            this.nettyEventExecutor.shutdown();
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
        this.defaultRequestProcessorPair = new Pair((Object)processor, (Object)executor);
    }

    @Override
    public int localListenPort() {
        return this.nettyServerConfig.getListenPort();
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int requestCode) {
        return (Pair)this.processorTable.get(requestCode);
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getDefaultProcessorPair() {
        return this.defaultRequestProcessorPair;
    }

    @Override
    public RemotingServer newRemotingServer(int port) {
        SubRemotingServer remotingServer = new SubRemotingServer(port, this.nettyServerConfig.getServerOnewaySemaphoreValue(), this.nettyServerConfig.getServerAsyncSemaphoreValue());
        NettyRemotingAbstract existingServer = this.remotingServerTable.putIfAbsent(port, remotingServer);
        if (existingServer != null) {
            throw new RuntimeException("The port " + port + " already in use by another RemotingServer");
        }
        return remotingServer;
    }

    @Override
    public void removeRemotingServer(int port) {
        this.remotingServerTable.remove(port);
    }

    @Override
    public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSyncImpl(channel, request, timeoutMillis);
    }

    @Override
    public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeOnewayImpl(channel, request, timeoutMillis);
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    private void printRemotingCodeDistribution() {
        if (this.distributionHandler != null) {
            String outBoundSnapshotString;
            String inBoundSnapshotString = this.distributionHandler.getInBoundSnapshotString();
            if (inBoundSnapshotString != null) {
                TRAFFIC_LOGGER.info("Port: {}, RequestCode Distribution: {}", (Object)this.nettyServerConfig.getListenPort(), (Object)inBoundSnapshotString);
            }
            if ((outBoundSnapshotString = this.distributionHandler.getOutBoundSnapshotString()) != null) {
                TRAFFIC_LOGGER.info("Port: {}, ResponseCode Distribution: {}", (Object)this.nettyServerConfig.getListenPort(), (Object)outBoundSnapshotString);
            }
        }
    }

    public DefaultEventExecutorGroup getDefaultEventExecutorGroup() {
        return this.defaultEventExecutorGroup;
    }

    public NettyEncoder getEncoder() {
        return this.encoder;
    }

    public NettyConnectManageHandler getConnectionManageHandler() {
        return this.connectionManageHandler;
    }

    public NettyServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public RemotingCodeDistributionHandler getDistributionHandler() {
        return this.distributionHandler;
    }

    protected void handleHAProxyTLV(HAProxyTLV tlv, Channel channel) {
        byte[] valueBytes = ByteBufUtil.getBytes((ByteBuf)tlv.content());
        if (!BinaryUtil.isAscii((byte[])valueBytes)) {
            return;
        }
        AttributeKey<String> key = AttributeKeys.valueOf("proxy_protocol_tlv_0x" + String.format("%02x", tlv.typeByteValue()));
        RemotingHelper.setPropertyToAttr(channel, key, new String(valueBytes, CharsetUtil.UTF_8));
    }

    public class HAProxyMessageHandler
    extends ChannelInboundHandlerAdapter {
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HAProxyMessage) {
                this.handleWithMessage((HAProxyMessage)msg, ctx.channel());
            } else {
                super.channelRead(ctx, msg);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private void handleWithMessage(HAProxyMessage msg, Channel channel) {
            try {
                if (StringUtils.isNotBlank((CharSequence)msg.sourceAddress())) {
                    RemotingHelper.setPropertyToAttr(channel, AttributeKeys.PROXY_PROTOCOL_ADDR, msg.sourceAddress());
                }
                if (msg.sourcePort() > 0) {
                    RemotingHelper.setPropertyToAttr(channel, AttributeKeys.PROXY_PROTOCOL_PORT, String.valueOf(msg.sourcePort()));
                }
                if (StringUtils.isNotBlank((CharSequence)msg.destinationAddress())) {
                    RemotingHelper.setPropertyToAttr(channel, AttributeKeys.PROXY_PROTOCOL_SERVER_ADDR, msg.destinationAddress());
                }
                if (msg.destinationPort() > 0) {
                    RemotingHelper.setPropertyToAttr(channel, AttributeKeys.PROXY_PROTOCOL_SERVER_PORT, String.valueOf(msg.destinationPort()));
                }
                if (CollectionUtils.isNotEmpty((Collection)msg.tlvs())) {
                    msg.tlvs().forEach(tlv -> NettyRemotingServer.this.handleHAProxyTLV((HAProxyTLV)tlv, channel));
                }
            }
            finally {
                msg.release();
            }
        }
    }

    class SubRemotingServer
    extends NettyRemotingAbstract
    implements RemotingServer {
        private volatile int listenPort;
        private volatile Channel serverChannel;

        SubRemotingServer(int port, int permitsOnway, int permitsAsync) {
            super(permitsOnway, permitsAsync);
            this.listenPort = port;
        }

        @Override
        public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
            ExecutorService executorThis = executor;
            if (null == executor) {
                executorThis = NettyRemotingServer.this.publicExecutor;
            }
            Pair pair = new Pair((Object)processor, (Object)executorThis);
            this.processorTable.put(requestCode, pair);
        }

        @Override
        public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
            this.defaultRequestProcessorPair = new Pair((Object)processor, (Object)executor);
        }

        @Override
        public int localListenPort() {
            return this.listenPort;
        }

        @Override
        public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int requestCode) {
            return (Pair)this.processorTable.get(requestCode);
        }

        @Override
        public Pair<NettyRequestProcessor, ExecutorService> getDefaultProcessorPair() {
            return this.defaultRequestProcessorPair;
        }

        @Override
        public RemotingServer newRemotingServer(int port) {
            throw new UnsupportedOperationException("The SubRemotingServer of NettyRemotingServer doesn't support new nested RemotingServer");
        }

        @Override
        public void removeRemotingServer(int port) {
            throw new UnsupportedOperationException("The SubRemotingServer of NettyRemotingServer doesn't support remove nested RemotingServer");
        }

        @Override
        public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
            return this.invokeSyncImpl(channel, request, timeoutMillis);
        }

        @Override
        public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
            this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
        }

        @Override
        public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
            this.invokeOnewayImpl(channel, request, timeoutMillis);
        }

        @Override
        public void start() {
            try {
                if (this.listenPort < 0) {
                    this.listenPort = 0;
                }
                this.serverChannel = NettyRemotingServer.this.serverBootstrap.bind(this.listenPort).sync().channel();
                if (0 == this.listenPort) {
                    InetSocketAddress addr = (InetSocketAddress)this.serverChannel.localAddress();
                    this.listenPort = addr.getPort();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("this.subRemotingServer.serverBootstrap.bind().sync() InterruptedException", e);
            }
        }

        @Override
        public void shutdown() {
            this.isShuttingDown.set(true);
            if (this.serverChannel != null) {
                try {
                    this.serverChannel.close().await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public ChannelEventListener getChannelEventListener() {
            return NettyRemotingServer.this.getChannelEventListener();
        }

        @Override
        public ExecutorService getCallbackExecutor() {
            return NettyRemotingServer.this.getCallbackExecutor();
        }
    }

    @ChannelHandler.Sharable
    public class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelRegistered {}", (Object)remoteAddress);
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelUnregistered, the channel[{}]", (Object)remoteAddress);
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelActive, the channel[{}]", (Object)remoteAddress);
            super.channelActive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress, ctx.channel()));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info("NETTY SERVER PIPELINE: channelInactive, the channel[{}]", (Object)remoteAddress);
            super.channelInactive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress, ctx.channel()));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn("NETTY SERVER PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                RemotingHelper.closeChannel(ctx.channel());
                if (NettyRemotingServer.this.channelEventListener != null) {
                    NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress, ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn("NETTY SERVER PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY SERVER PIPELINE: exceptionCaught exception.", cause);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress, ctx.channel()));
            }
            RemotingHelper.closeChannel(ctx.channel());
        }
    }

    @ChannelHandler.Sharable
    public class NettyServerHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) {
            int localPort = RemotingHelper.parseSocketAddressPort(ctx.channel().localAddress());
            NettyRemotingAbstract remotingAbstract = (NettyRemotingAbstract)NettyRemotingServer.this.remotingServerTable.get(localPort);
            if (localPort != -1 && remotingAbstract != null) {
                remotingAbstract.processMessageReceived(ctx, msg);
                return;
            }
            RemotingHelper.closeChannel(ctx.channel());
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            if (channel.isWritable()) {
                if (!channel.config().isAutoRead()) {
                    channel.config().setAutoRead(true);
                    log.info("Channel[{}] turns writable, bytes to buffer before changing channel to un-writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeUnwritable());
                }
            } else {
                channel.config().setAutoRead(false);
                log.warn("Channel[{}] auto-read is disabled, bytes to drain before it turns writable: {}", (Object)RemotingHelper.parseChannelRemoteAddr(channel), (Object)channel.bytesBeforeWritable());
            }
            super.channelWritabilityChanged(ctx);
        }
    }

    @ChannelHandler.Sharable
    public class TlsModeHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final TlsMode tlsMode;
        private static final byte HANDSHAKE_MAGIC_CODE = 22;

        TlsModeHandler(TlsMode tlsMode) {
            this.tlsMode = tlsMode;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            byte b = msg.getByte(msg.readerIndex());
            if (b == 22) {
                switch (this.tlsMode) {
                    case DISABLED: {
                        ctx.close();
                        log.warn("Clients intend to establish an SSL connection while this server is running in SSL disabled mode");
                        throw new UnsupportedOperationException("The NettyRemotingServer in SSL disabled mode doesn't support ssl client");
                    }
                    case PERMISSIVE: 
                    case ENFORCING: {
                        if (null != NettyRemotingServer.this.sslContext) {
                            ctx.pipeline().addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.TLS_MODE_HANDLER, NettyRemotingServer.TLS_HANDLER_NAME, (ChannelHandler)NettyRemotingServer.this.sslContext.newHandler(ctx.channel().alloc())).addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.TLS_HANDLER_NAME, NettyRemotingServer.FILE_REGION_ENCODER_NAME, (ChannelHandler)new FileRegionEncoder());
                            log.info("Handlers prepended to channel pipeline to establish SSL connection");
                            break;
                        }
                        ctx.close();
                        log.error("Trying to establish an SSL connection but SslContext is null");
                        break;
                    }
                    default: {
                        log.warn("Unknown TLS mode");
                        break;
                    }
                }
            } else if (this.tlsMode == TlsMode.ENFORCING) {
                ctx.close();
                log.warn("Clients intend to establish an insecure connection while this server is running in SSL enforcing mode");
            }
            try {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            catch (NoSuchElementException e) {
                log.error("Error while removing TlsModeHandler", (Throwable)e);
            }
            ctx.fireChannelRead((Object)msg.retain());
        }
    }

    public class HandshakeHandler
    extends ByteToMessageDecoder {
        protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
            try {
                ProtocolDetectionResult detectionResult = HAProxyMessageDecoder.detectProtocol((ByteBuf)byteBuf);
                if (detectionResult.state() == ProtocolDetectionState.NEEDS_MORE_DATA) {
                    return;
                }
                if (detectionResult.state() == ProtocolDetectionState.DETECTED) {
                    ctx.pipeline().addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, ctx.name(), NettyRemotingServer.HA_PROXY_DECODER, (ChannelHandler)new HAProxyMessageDecoder()).addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.HA_PROXY_DECODER, NettyRemotingServer.HA_PROXY_HANDLER, (ChannelHandler)new HAProxyMessageHandler()).addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, NettyRemotingServer.HA_PROXY_HANDLER, NettyRemotingServer.TLS_MODE_HANDLER, (ChannelHandler)NettyRemotingServer.this.tlsModeHandler);
                } else {
                    ctx.pipeline().addAfter((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, ctx.name(), NettyRemotingServer.TLS_MODE_HANDLER, (ChannelHandler)NettyRemotingServer.this.tlsModeHandler);
                }
                try {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
                catch (NoSuchElementException e) {
                    log.error("Error while removing HandshakeHandler", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error("process proxy protocol negotiator failed.", (Throwable)e);
                throw e;
            }
        }
    }
}

