/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import jakarta.jms.JMSException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.util.MessageQueue;

public final class PriorityMessageQueue
implements MessageQueue {
    protected static final AtomicIntegerFieldUpdater<PriorityMessageQueue> STATE_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PriorityMessageQueue.class, "state");
    protected static final int CLOSED = 0;
    protected static final int STOPPED = 1;
    protected static final int RUNNING = 2;
    private volatile int state = 1;
    protected final Object lock = new Object();
    private static final Integer MAX_PRIORITY = 9;
    private final LinkedList<JmsInboundMessageDispatch>[] lists = new LinkedList[MAX_PRIORITY + 1];
    private int size = 0;

    public PriorityMessageQueue() {
        for (int i = 0; i <= MAX_PRIORITY; ++i) {
            this.lists[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(JmsInboundMessageDispatch envelope) {
        Object object = this.lock;
        synchronized (object) {
            this.getList(envelope).addLast(envelope);
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueFirst(JmsInboundMessageDispatch envelope) {
        Object object = this.lock;
        synchronized (object) {
            this.getList(MAX_PRIORITY).addFirst(envelope);
            ++this.size;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JmsInboundMessageDispatch dequeue(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (timeout != 0L && this.isRunning() && this.isEmpty()) {
                if (timeout == -1L) {
                    this.lock.wait();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.lock.wait(timeout);
                timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
            }
            if (!this.isRunning() || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JmsInboundMessageDispatch dequeueNoWait() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning() || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 1, 2)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        if (STATE_FIELD_UPDATER.compareAndSet(this, 2, 1)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        if (STATE_FIELD_UPDATER.getAndSet(this, 0) > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state == 2;
    }

    @Override
    public final boolean isClosed() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.size == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i <= MAX_PRIORITY; ++i) {
                this.lists[i].clear();
            }
            this.size = 0;
        }
    }

    private JmsInboundMessageDispatch removeFirst() {
        if (this.size > 0) {
            for (int i = MAX_PRIORITY.intValue(); i >= 0; --i) {
                LinkedList<JmsInboundMessageDispatch> list = this.lists[i];
                if (list.isEmpty()) continue;
                --this.size;
                return list.removeFirst();
            }
        }
        return null;
    }

    private int getPriority(JmsInboundMessageDispatch envelope) {
        int priority = 4;
        if (envelope.getMessage() != null) {
            try {
                priority = Math.max(envelope.getMessage().getJMSPriority(), 0);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            priority = Math.min(priority, MAX_PRIORITY);
        }
        return priority;
    }

    private LinkedList<JmsInboundMessageDispatch> getList(JmsInboundMessageDispatch envelope) {
        return this.getList(this.getPriority(envelope));
    }

    private LinkedList<JmsInboundMessageDispatch> getList(int priority) {
        return this.lists[priority];
    }
}

