/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.model.BrokerLogger;
import org.apache.qpid.server.model.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerLoggerStatusListener
implements StatusListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerLoggerStatusListener.class);
    private final SystemConfig<?> _systemConfig;
    private final BrokerLogger<?> _brokerLogger;
    private final String _contextFlag;
    private final Set<Class<?>> _errorClasses;

    public BrokerLoggerStatusListener(BrokerLogger<?> brokerLogger, SystemConfig<?> systemConfig, String contextFlag, Class<?> ... errorClass) {
        this._brokerLogger = brokerLogger;
        this._systemConfig = systemConfig;
        this._contextFlag = contextFlag;
        this._errorClasses = errorClass == null ? Collections.emptySet() : Arrays.stream(errorClass).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void addStatusEvent(Status status) {
        Throwable throwable = status.getThrowable();
        if (status.getEffectiveLevel() == 2 && this._errorClasses.stream().anyMatch(errorClass -> errorClass.isInstance(throwable))) {
            if (LOGGER.isDebugEnabled() || LOGGER.isTraceEnabled()) {
                LOGGER.error("Unexpected error whilst trying to store log entry. Log messages could be lost.", throwable);
            } else {
                LOGGER.error("Unexpected error whilst trying to store log entry. Log messages could be lost: {}", (Object)throwable.getMessage());
            }
            if (((Boolean)this._brokerLogger.getContextValue(Boolean.class, this._contextFlag)).booleanValue()) {
                try {
                    this._brokerLogger.stopLogging();
                    this._systemConfig.getEventLogger().message(BrokerMessages.FATAL_ERROR((CharSequence)String.format("Shutting down the broker because context variable '%s' is set and unexpected logging issue occurred: %s", this._contextFlag, throwable.getMessage())));
                }
                finally {
                    this._systemConfig.closeAsync();
                }
            }
        }
    }
}

