/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.filter.Filter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.logging.LogInclusionRule;
import org.apache.qpid.server.logging.logback.CompositeFilter;
import org.apache.qpid.server.logging.logback.LogBackLogInclusionRule;
import org.apache.qpid.server.logging.logback.StartupAppender;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.BrokerLogInclusionRule;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.VirtualHostLogInclusionRule;
import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogger<X extends AbstractLogger<X>>
extends AbstractConfiguredObject<X> {
    private static final Logger ROOT_LOGGER = (Logger)LoggerFactory.getLogger((String)"ROOT");
    private final CompositeFilter _compositeFilter = new CompositeFilter();

    protected AbstractLogger(Map<String, Object> attributes, ConfiguredObject<?> parent) {
        super(parent, attributes);
        this.addChangeListener((ConfigurationChangeListener)new LogInclusionRuleListener());
    }

    protected final void addLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        this._compositeFilter.addLogInclusionRule(logInclusionRule);
    }

    protected final void removeLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        this._compositeFilter.removeLogInclusionRule(logInclusionRule);
    }

    protected void postResolveChildren() {
        super.postResolveChildren();
        LoggerContext loggerContext = ROOT_LOGGER.getLoggerContext();
        Appender<ILoggingEvent> appender = this.createAppenderInstance((Context)loggerContext);
        appender.setName(this.getName());
        appender.setContext((Context)loggerContext);
        for (LogInclusionRule logInclusionRule : this.getLogInclusionRules()) {
            this._compositeFilter.addLogInclusionRule((LogBackLogInclusionRule)logInclusionRule);
        }
        appender.addFilter((Filter)this._compositeFilter);
        ROOT_LOGGER.addAppender(appender);
        appender.start();
        StartupAppender startupAppender = (StartupAppender)ROOT_LOGGER.getAppender(StartupAppender.class.getName());
        if (startupAppender != null) {
            startupAppender.replayAccumulatedEvents(appender);
        }
    }

    protected abstract Appender<ILoggingEvent> createAppenderInstance(Context var1);

    protected abstract Collection<? extends LogInclusionRule> getLogInclusionRules();

    @StateTransition(currentState={State.ERRORED, State.UNINITIALIZED, State.STOPPED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> doActivate() {
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> onDelete() {
        this.stopLogging();
        return super.onDelete();
    }

    public final long getErrorCount() {
        return this._compositeFilter.getErrorCount();
    }

    public final long getWarnCount() {
        return this._compositeFilter.getWarnCount();
    }

    public void stopLogging() {
        Appender<ILoggingEvent> appender = this.getAppender();
        if (appender != null) {
            appender.stop();
            ROOT_LOGGER.detachAppender(appender);
        }
    }

    public void resetStatistics() {
        this._compositeFilter.resetStatistics();
    }

    protected Appender<ILoggingEvent> getAppender() {
        return ROOT_LOGGER.getAppender(this.getName());
    }

    public static Map<String, Collection<String>> getSupportedVirtualHostLoggerChildTypes() {
        return AbstractLogger.getSupportedLoggerChildTypes(VirtualHostLogInclusionRule.class);
    }

    public static Map<String, Collection<String>> getSupportedBrokerLoggerChildTypes() {
        return AbstractLogger.getSupportedLoggerChildTypes(BrokerLogInclusionRule.class);
    }

    private static Map<String, Collection<String>> getSupportedLoggerChildTypes(Class<? extends ConfiguredObject> clazz) {
        return Collections.singletonMap(clazz.getSimpleName(), AbstractLogger.getSupportedLogInclusionRules(clazz));
    }

    private static Collection<String> getSupportedLogInclusionRules(Class<? extends ConfiguredObject> clazz) {
        Iterable registrations = new QpidServiceLoader().instancesOf(ConfiguredObjectRegistration.class);
        HashSet<String> supportedTypes = new HashSet<String>();
        for (ConfiguredObjectRegistration registration : registrations) {
            for (Class typeClass : registration.getConfiguredObjectClasses()) {
                ManagedObject annotation;
                if (!clazz.isAssignableFrom(typeClass) || !(annotation = typeClass.getAnnotation(ManagedObject.class)).creatable() || !annotation.defaultType().equals("") || !LogBackLogInclusionRule.class.isAssignableFrom(typeClass)) continue;
                supportedTypes.add(ConfiguredObjectTypeRegistry.getType((Class)typeClass));
            }
        }
        return Collections.unmodifiableCollection(supportedTypes);
    }

    private class LogInclusionRuleListener
    extends AbstractConfigurationChangeListener {
        private LogInclusionRuleListener() {
        }

        public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof LogBackLogInclusionRule) {
                AbstractLogger.this.addLogInclusionRule((LogBackLogInclusionRule)child);
            }
        }

        public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
            if (child instanceof LogBackLogInclusionRule) {
                AbstractLogger.this.removeLogInclusionRule((LogBackLogInclusionRule)child);
            }
        }
    }
}

