/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.connection.SessionPrincipal;
import org.apache.qpid.server.consumer.ConsumerOption;
import org.apache.qpid.server.consumer.ConsumerTarget;
import org.apache.qpid.server.exchange.DestinationReferrer;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.QueueMessages;
import org.apache.qpid.server.logging.messages.SenderMessages;
import org.apache.qpid.server.logging.subjects.QueueLogSubject;
import org.apache.qpid.server.message.InstanceProperties;
import org.apache.qpid.server.message.MessageContainer;
import org.apache.qpid.server.message.MessageDeletedException;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.message.MessageInfoImpl;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.MessageSender;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.message.RejectType;
import org.apache.qpid.server.message.RoutingResult;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessage;
import org.apache.qpid.server.model.AbstractConfigurationChangeListener;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.Binding;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.CustomRestHeaders;
import org.apache.qpid.server.model.Exchange;
import org.apache.qpid.server.model.ExclusivityPolicy;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.OverflowPolicy;
import org.apache.qpid.server.model.PublishingLink;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.model.QueueNotificationListener;
import org.apache.qpid.server.model.RestContentHeader;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.plugin.MessageFilterFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.protocol.MessageConverterRegistry;
import org.apache.qpid.server.queue.AssignedConsumerMessageGroupManager;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.CopyMessagesTransaction;
import org.apache.qpid.server.queue.CreatingLinkInfo;
import org.apache.qpid.server.queue.DefinedGroupMessageGroupManager;
import org.apache.qpid.server.queue.DeleteMessagesTransaction;
import org.apache.qpid.server.queue.FlowToDiskOverflowPolicyHandler;
import org.apache.qpid.server.queue.MessageContentJsonConverter;
import org.apache.qpid.server.queue.MessageGroupManager;
import org.apache.qpid.server.queue.MessageGroupType;
import org.apache.qpid.server.queue.MessageUnacceptableException;
import org.apache.qpid.server.queue.MoveMessagesTransaction;
import org.apache.qpid.server.queue.NoneOverflowPolicyHandler;
import org.apache.qpid.server.queue.NotificationCheck;
import org.apache.qpid.server.queue.OverflowPolicyHandler;
import org.apache.qpid.server.queue.ProducerFlowControlOverflowPolicyHandler;
import org.apache.qpid.server.queue.QueueConsumer;
import org.apache.qpid.server.queue.QueueConsumerImpl;
import org.apache.qpid.server.queue.QueueConsumerManagerImpl;
import org.apache.qpid.server.queue.QueueContext;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryVisitor;
import org.apache.qpid.server.queue.QueueStatistics;
import org.apache.qpid.server.queue.RejectPolicyHandler;
import org.apache.qpid.server.queue.RingOverflowPolicyHandler;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.session.AMQPSession;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.txn.AsyncAutoCommitTransaction;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.TransactionMonitor;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.Deletable;
import org.apache.qpid.server.util.DeleteDeleteTask;
import org.apache.qpid.server.util.LimitedInputStream;
import org.apache.qpid.server.util.ParameterizedTypes;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.MessageDestinationIsAlternateException;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.apache.qpid.server.virtualhost.UnknownAlternateBindingException;
import org.apache.qpid.server.virtualhost.VirtualHostUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueue<X extends AbstractQueue<X>>
extends AbstractConfiguredObject<X>
implements Queue<X>,
MessageGroupManager.ConsumerResetHelper,
TransactionMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueue.class);
    private static final QueueNotificationListener NULL_NOTIFICATION_LISTENER = (notification, queue, notificationMsg) -> {};
    private static final String UTF8 = StandardCharsets.UTF_8.name();
    private static final Operation PUBLISH_ACTION = Operation.PERFORM_ACTION("publish");
    private static final AtomicIntegerFieldUpdater<AbstractQueue> LIVE_CONSUMERS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractQueue.class, "_liveConsumers");
    private static final int RECOVERING = 1;
    private static final int COMPLETING_RECOVERY = 2;
    private static final int RECOVERED = 3;
    private final QueueManagingVirtualHost<?> _virtualHost;
    private final DeletedChildListener _deletedChildListener = new DeletedChildListener();
    private final QueueConsumerManagerImpl _queueConsumerManager;
    private final AtomicInteger _activeSubscriberCount = new AtomicInteger();
    private final QueueStatistics _queueStatistics = new QueueStatistics();
    private final Set<NotificationCheck> _notificationChecks = Collections.synchronizedSet(EnumSet.noneOf(NotificationCheck.class));
    private final AtomicBoolean _stopped = new AtomicBoolean(false);
    private final AtomicBoolean _deleted = new AtomicBoolean(false);
    private final CompletableFuture<Integer> _deleteQueueDepthFuture = new CompletableFuture();
    private final List<Action<? super X>> _deleteTaskList = new CopyOnWriteArrayList<Action<? super X>>();
    private final LogSubject _logSubject;
    private final CopyOnWriteArrayList<Binding> _bindings = new CopyOnWriteArrayList();
    private final ConcurrentMap<MessageSender, Integer> _linkedSenders = new ConcurrentHashMap<MessageSender, Integer>();
    private final long[] _lastNotificationTimes = new long[NotificationCheck.values().length];
    private final AtomicInteger _recovering = new AtomicInteger(1);
    private final AtomicInteger _enqueuingWhileRecovering = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<EnqueueRequest> _postRecoveryQueue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<String, Callable<MessageFilter>> _defaultFiltersMap = new ConcurrentHashMap<String, Callable<MessageFilter>>();
    private final List<HoldMethod> _holdMethods = new CopyOnWriteArrayList<HoldMethod>();
    private final Set<DestinationReferrer> _referrers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<LocalTransaction> _transactions = ConcurrentHashMap.newKeySet();
    private final LocalTransaction.LocalTransactionListener _localTransactionListener = this._transactions::remove;
    private final AtomicLong _producerCount = new AtomicLong();
    @ManagedAttributeField(beforeSet="preSetAlternateBinding", afterSet="postSetAlternateBinding")
    private AlternateBinding _alternateBinding;
    private volatile QueueConsumer<?, ?> _exclusiveSubscriber;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdMessageSize;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdQueueDepthMessages;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdQueueDepthBytes;
    @ManagedAttributeField(afterSet="updateAlertChecks")
    private long _alertThresholdMessageAge;
    @ManagedAttributeField
    private long _alertRepeatGap;
    @ManagedAttributeField
    private ExclusivityPolicy _exclusive;
    @ManagedAttributeField
    private MessageDurability _messageDurability;
    @ManagedAttributeField
    private Map<String, Map<String, List<String>>> _defaultFilters;
    private Object _exclusiveOwner;
    @ManagedAttributeField
    private boolean _noLocal;
    private Map<String, Object> _arguments;
    @ManagedAttributeField
    private int _maximumDeliveryAttempts;
    private MessageGroupManager _messageGroupManager;
    private QueueNotificationListener _notificationListener = NULL_NOTIFICATION_LISTENER;
    @ManagedAttributeField
    private String _messageGroupKeyOverride;
    @ManagedAttributeField
    private boolean _messageGroupSharedGroups;
    @ManagedAttributeField
    private MessageGroupType _messageGroupType;
    @ManagedAttributeField
    private String _messageGroupDefaultGroup;
    @ManagedAttributeField
    private int _maximumDistinctGroups;
    @ManagedAttributeField(afterSet="queueMessageTtlChanged")
    private long _minimumMessageTtl;
    @ManagedAttributeField(afterSet="queueMessageTtlChanged")
    private long _maximumMessageTtl;
    @ManagedAttributeField
    private boolean _ensureNondestructiveConsumers;
    @ManagedAttributeField
    private volatile boolean _holdOnPublishEnabled;
    @ManagedAttributeField
    private OverflowPolicy _overflowPolicy;
    @ManagedAttributeField
    private long _maximumQueueDepthMessages;
    @ManagedAttributeField
    private long _maximumQueueDepthBytes;
    @ManagedAttributeField
    private CreatingLinkInfo _creatingLinkInfo;
    @ManagedAttributeField
    private Queue.ExpiryPolicy _expiryPolicy;
    @ManagedAttributeField
    private volatile int _maximumLiveConsumers;
    private volatile int _liveConsumers;
    private boolean _closing;
    private Map<String, String> _mimeTypeToFileExtension = Map.of();
    private AdvanceConsumersTask _queueHouseKeepingTask;
    private volatile int _bindingCount;
    private volatile RejectPolicyHandler _rejectPolicyHandler;
    private volatile OverflowPolicyHandler _postEnqueueOverflowPolicyHandler;
    private long _flowToDiskThreshold;
    private volatile MessageDestination _alternateBindingDestination;
    private volatile MessageSource.MessageConversionExceptionHandlingPolicy _messageConversionExceptionHandlingPolicy;
    private static final MessageContainer NO_MESSAGES = new MessageContainer();
    private static final String[] NON_NEGATIVE_NUMBERS = new String[]{"alertRepeatGap", "alertThresholdMessageAge", "alertThresholdMessageSize", "alertThresholdQueueDepthMessages", "alertThresholdQueueDepthBytes", "maximumDeliveryAttempts"};

    protected AbstractQueue(Map<String, Object> attributes, QueueManagingVirtualHost<?> virtualHost) {
        super(virtualHost, attributes);
        this._queueConsumerManager = new QueueConsumerManagerImpl(this);
        this._virtualHost = virtualHost;
        this._logSubject = new QueueLogSubject(this.getName(), this._virtualHost.getName());
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        if (this.isDurable() && (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CONNECTION_CLOSE || this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_SESSION_END)) {
            Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
                this.setAttributes(Map.of("durable", false));
                return null;
            });
        }
        if (!this.isDurable() && this.getMessageDurability() != MessageDurability.NEVER) {
            Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
                this.setAttributes(Map.of("messageDurability", MessageDurability.NEVER));
                return null;
            });
        }
        this.validateOrCreateAlternateBinding(this, true);
        this._recovering.set(3);
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        if (this.getCreatingLinkInfo() != null && !this.isSystemProcess()) {
            throw new IllegalConfigurationException(String.format("Cannot specify creatingLinkInfo for queue '%s'", this.getName()));
        }
    }

    @Override
    public void onValidate() {
        super.onValidate();
        Double flowResumeLimit = this.getContextValue(Double.class, "queue.queueFlowResumeLimit");
        if (flowResumeLimit != null && (flowResumeLimit < 0.0 || flowResumeLimit > 100.0)) {
            throw new IllegalConfigurationException("Flow resume limit value cannot be greater than 100 or lower than 0");
        }
    }

    private Set<SessionPrincipal> getSessionPrincipals() {
        Subject activeSubject = Subject.getSubject(AccessController.getContext());
        return activeSubject == null ? Set.of() : activeSubject.getPrincipals(SessionPrincipal.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void onOpen() {
        AMQPSession<?, ?> session;
        block32: {
            Map<String, Object> attributes;
            block31: {
                super.onOpen();
                attributes = this.getActualAttributes();
                LinkedHashMap<String, Object> arguments = new LinkedHashMap<String, Object>(attributes);
                arguments.put("exclusive", (Object)this._exclusive);
                arguments.put("lifetimePolicy", (Object)this.getLifetimePolicy());
                this._arguments = Collections.synchronizedMap(arguments);
                this._queueHouseKeepingTask = new AdvanceConsumersTask();
                Set<SessionPrincipal> sessionPrincipals = this.getSessionPrincipals();
                if (sessionPrincipals.isEmpty()) {
                    session = null;
                } else {
                    SessionPrincipal sessionPrincipal = sessionPrincipals.iterator().next();
                    session = sessionPrincipal.getSession();
                }
                if (session == null) break block31;
                switch (this._exclusive) {
                    case PRINCIPAL: {
                        this._exclusiveOwner = session.getAMQPConnection().getAuthorizedPrincipal();
                        break block32;
                    }
                    case CONTAINER: {
                        this._exclusiveOwner = session.getAMQPConnection().getRemoteContainerName();
                        break block32;
                    }
                    case CONNECTION: {
                        this._exclusiveOwner = session.getAMQPConnection();
                        this.addExclusivityConstraint(session.getAMQPConnection());
                        break block32;
                    }
                    case SESSION: {
                        this._exclusiveOwner = session;
                        this.addExclusivityConstraint(session);
                        break block32;
                    }
                    case NONE: 
                    case LINK: 
                    case SHARED_SUBSCRIPTION: {
                        break block32;
                    }
                    default: {
                        throw new ServerScopedRuntimeException("Unknown exclusivity policy: " + String.valueOf((Object)this._exclusive) + " this is a coding error inside Qpid");
                    }
                }
            }
            if (this._exclusive == ExclusivityPolicy.PRINCIPAL) {
                if (attributes.get("owner") != null) {
                    GenericPrincipal ownerPrincipal;
                    String owner = String.valueOf(attributes.get("owner"));
                    try {
                        ownerPrincipal = new GenericPrincipal(owner);
                    }
                    catch (IllegalArgumentException e) {
                        ownerPrincipal = new GenericPrincipal(owner + "@('')");
                    }
                    this._exclusiveOwner = new AuthenticatedPrincipal(ownerPrincipal);
                }
            } else if (this._exclusive == ExclusivityPolicy.CONTAINER && attributes.get("owner") != null) {
                this._exclusiveOwner = String.valueOf(attributes.get("owner"));
            }
        }
        if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CONNECTION_CLOSE) {
            if (session == null) throw new IllegalArgumentException("Queues created with a lifetime policy of " + String.valueOf((Object)this.getLifetimePolicy()) + " must be created from a connection.");
            this.addLifetimeConstraint(session.getAMQPConnection());
        } else if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_SESSION_END) {
            if (session == null) throw new IllegalArgumentException("Queues created with a lifetime policy of " + String.valueOf((Object)this.getLifetimePolicy()) + " must be created from a connection.");
            this.addLifetimeConstraint(session);
        } else if (this.getLifetimePolicy() == LifetimePolicy.DELETE_ON_CREATING_LINK_CLOSE) {
            if (this._creatingLinkInfo == null) throw new IllegalArgumentException("Queues created with a lifetime policy of " + String.valueOf((Object)this.getLifetimePolicy()) + " must be created from a AMQP 1.0 link.");
            Object link = this._creatingLinkInfo.isSendingLink() ? this._virtualHost.getSendingLink(this._creatingLinkInfo.getRemoteContainerId(), this._creatingLinkInfo.getLinkName()) : this._virtualHost.getReceivingLink(this._creatingLinkInfo.getRemoteContainerId(), this._creatingLinkInfo.getLinkName());
            this.addLifetimeConstraint((Deletable<? extends Deletable>)link);
        }
        switch (this.getMessageGroupType()) {
            case NONE: {
                this._messageGroupManager = null;
                break;
            }
            case STANDARD: {
                this._messageGroupManager = new AssignedConsumerMessageGroupManager(this.getMessageGroupKeyOverride(), this.getMaximumDistinctGroups());
                break;
            }
            case SHARED_GROUPS: {
                this._messageGroupManager = new DefinedGroupMessageGroupManager(this.getMessageGroupKeyOverride(), this.getMessageGroupDefaultGroup(), this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown messageGroupType type " + String.valueOf((Object)this._messageGroupType));
            }
        }
        this._mimeTypeToFileExtension = this.getContextValue(Map.class, ParameterizedTypes.MAP_OF_STRING_STRING, "qpid.mimeTypeToFileExtension");
        this._messageConversionExceptionHandlingPolicy = this.getContextValue(MessageSource.MessageConversionExceptionHandlingPolicy.class, "qpid.queue.messageConversion.exceptionHandlingPolicy");
        this._flowToDiskThreshold = this.getAncestor(Broker.class).getFlowToDiskThreshold();
        if (this._defaultFilters != null) {
            QpidServiceLoader qpidServiceLoader = new QpidServiceLoader();
            Map<String, MessageFilterFactory> messageFilterFactories = qpidServiceLoader.getInstancesByType(MessageFilterFactory.class);
            for (Map.Entry<String, Map<String, List<String>>> entry : this._defaultFilters.entrySet()) {
                String name = String.valueOf(entry.getKey());
                Map<String, List<String>> filterValue = entry.getValue();
                if (filterValue.size() != 1) throw new IllegalArgumentException("Filter value should be a map with one entry, having the type as key and the value being the filter arguments, not " + String.valueOf(filterValue));
                String filterTypeName = String.valueOf(filterValue.keySet().iterator().next());
                MessageFilterFactory filterFactory = messageFilterFactories.get(filterTypeName);
                if (filterFactory == null) throw new IllegalArgumentException("Unknown filter type " + filterTypeName + ", known types are: " + String.valueOf(messageFilterFactories.keySet()));
                List<String> filterArguments = filterValue.values().iterator().next();
                filterFactory.newInstance(filterArguments);
                this._defaultFiltersMap.put(name, () -> filterFactory.newInstance(filterArguments));
            }
        }
        if (this.isHoldOnPublishEnabled()) {
            this._holdMethods.add((messageReference, evaluationTime) -> messageReference.getMessage().getMessageHeader().getNotValidBefore() >= evaluationTime);
        }
        if (this.getAlternateBinding() != null) {
            String alternateDestination = this.getAlternateBinding().getDestination();
            this._alternateBindingDestination = this.getOpenedMessageDestination(alternateDestination);
            if (this._alternateBindingDestination != null) {
                this._alternateBindingDestination.addReference(this);
            } else {
                LOGGER.warn("Cannot find alternate binding destination '{}' for queue '{}'", (Object)alternateDestination, (Object)this.toString());
            }
        }
        this.createOverflowPolicyHandlers(this._overflowPolicy);
        this.updateAlertChecks();
    }

    private void createOverflowPolicyHandlers(OverflowPolicy overflowPolicy) {
        OverflowPolicyHandler overflowPolicyHandler;
        RejectPolicyHandler rejectPolicyHandler = null;
        switch (overflowPolicy) {
            case RING: {
                overflowPolicyHandler = new RingOverflowPolicyHandler(this, this.getEventLogger());
                break;
            }
            case PRODUCER_FLOW_CONTROL: {
                overflowPolicyHandler = new ProducerFlowControlOverflowPolicyHandler(this, this.getEventLogger());
                break;
            }
            case FLOW_TO_DISK: {
                overflowPolicyHandler = new FlowToDiskOverflowPolicyHandler(this);
                break;
            }
            case NONE: {
                overflowPolicyHandler = new NoneOverflowPolicyHandler();
                break;
            }
            case REJECT: {
                overflowPolicyHandler = new NoneOverflowPolicyHandler();
                rejectPolicyHandler = new RejectPolicyHandler(this);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Overflow policy '%s' is not implemented", overflowPolicy.name()));
            }
        }
        this._rejectPolicyHandler = rejectPolicyHandler;
        this._postEnqueueOverflowPolicyHandler = overflowPolicyHandler;
    }

    private MessageDestination getOpenedMessageDestination(String name) {
        MessageDestination destination = this.getVirtualHost().getSystemDestination(name);
        if (destination == null) {
            destination = this.getVirtualHost().getChildByName(Exchange.class, name);
        }
        if (destination == null) {
            destination = this.getVirtualHost().getChildByName(Queue.class, name);
        }
        return destination;
    }

    private void addLifetimeConstraint(Deletable<? extends Deletable> lifetimeObject) {
        Action<Deletable> deleteQueueTask = object -> Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
            this.delete();
            return null;
        });
        lifetimeObject.addDeleteTask(deleteQueueTask);
        this.addDeleteTask(new DeleteDeleteTask(lifetimeObject, deleteQueueTask));
    }

    private void addExclusivityConstraint(Deletable<? extends Deletable> lifetimeObject) {
        ClearOwnerAction clearOwnerAction = new ClearOwnerAction(lifetimeObject);
        DeleteDeleteTask deleteDeleteTask = new DeleteDeleteTask(lifetimeObject, clearOwnerAction);
        clearOwnerAction.setDeleteTask(deleteDeleteTask);
        lifetimeObject.addDeleteTask(clearOwnerAction);
        this.addDeleteTask(deleteDeleteTask);
    }

    @Override
    public boolean isExclusive() {
        return this._exclusive != ExclusivityPolicy.NONE;
    }

    @Override
    public AlternateBinding getAlternateBinding() {
        return this._alternateBinding;
    }

    public void setAlternateBinding(AlternateBinding alternateBinding) {
        this._alternateBinding = alternateBinding;
    }

    private void postSetAlternateBinding() {
        if (this._alternateBinding != null) {
            this._alternateBindingDestination = this.getOpenedMessageDestination(this._alternateBinding.getDestination());
            if (this._alternateBindingDestination != null) {
                this._alternateBindingDestination.addReference(this);
            }
        }
    }

    private void preSetAlternateBinding() {
        if (this._alternateBindingDestination != null) {
            this._alternateBindingDestination.removeReference(this);
        }
    }

    @Override
    public MessageDestination getAlternateBindingDestination() {
        return this._alternateBindingDestination;
    }

    @Override
    public Map<String, Map<String, List<String>>> getDefaultFilters() {
        return this._defaultFilters;
    }

    @Override
    public final MessageDurability getMessageDurability() {
        return this._messageDurability;
    }

    @Override
    public long getMinimumMessageTtl() {
        return this._minimumMessageTtl;
    }

    @Override
    public long getMaximumMessageTtl() {
        return this._maximumMessageTtl;
    }

    @Override
    public boolean isEnsureNondestructiveConsumers() {
        return this._ensureNondestructiveConsumers;
    }

    @Override
    public boolean isHoldOnPublishEnabled() {
        return this._holdOnPublishEnabled;
    }

    @Override
    public long getMaximumQueueDepthMessages() {
        return this._maximumQueueDepthMessages;
    }

    @Override
    public long getMaximumQueueDepthBytes() {
        return this._maximumQueueDepthBytes;
    }

    @Override
    public Queue.ExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    @Override
    public Collection<String> getAvailableAttributes() {
        return new ArrayList<String>(this._arguments.keySet());
    }

    @Override
    public String getOwner() {
        if (this._exclusiveOwner instanceof String) {
            return (String)this._exclusiveOwner;
        }
        if (this._exclusiveOwner instanceof ConfiguredObject) {
            return ((ConfiguredObject)this._exclusiveOwner).getName();
        }
        if (this._exclusiveOwner instanceof Principal) {
            return ((Principal)this._exclusiveOwner).getName();
        }
        return null;
    }

    @Override
    public CreatingLinkInfo getCreatingLinkInfo() {
        return this._creatingLinkInfo;
    }

    @Override
    public QueueManagingVirtualHost<?> getVirtualHost() {
        return this._virtualHost;
    }

    public <T extends ConsumerTarget<T>> QueueConsumerImpl<T> addConsumer(final T target, final FilterManager filters, final Class<? extends ServerMessage> messageClass, final String consumerName, final EnumSet<ConsumerOption> optionSet, final Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.ConsumerAccessRefused, MessageSource.QueueDeleted {
        try {
            QueueConsumerImpl queueConsumer = (QueueConsumerImpl)this.getTaskExecutor().run(new Task<QueueConsumerImpl<T>, Exception>(){

                @Override
                public QueueConsumerImpl<T> execute() throws Exception {
                    return AbstractQueue.this.addConsumerInternal(target, filters, messageClass, consumerName, optionSet, priority);
                }

                @Override
                public String getObject() {
                    return AbstractQueue.this.toString();
                }

                @Override
                public String getAction() {
                    return "add consumer";
                }

                @Override
                public String getArguments() {
                    return "target=" + String.valueOf(target) + ", consumerName=" + consumerName + ", optionSet=" + String.valueOf(optionSet);
                }
            });
            target.consumerAdded(queueConsumer);
            if (this.isEmpty() || queueConsumer.isNonLive()) {
                target.noMessagesAvailable();
            }
            target.updateNotifyWorkDesired();
            target.notifyWork();
            return queueConsumer;
        }
        catch (RuntimeException | MessageSource.ConsumerAccessRefused | MessageSource.ExistingConsumerPreventsExclusive | MessageSource.ExistingExclusiveConsumer | MessageSource.QueueDeleted e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerScopedRuntimeException(e);
        }
    }

    private <T extends ConsumerTarget<T>> QueueConsumerImpl<T> addConsumerInternal(T target, FilterManager filters, Class<? extends ServerMessage> messageClass, String consumerName, EnumSet<ConsumerOption> optionSet, Integer priority) throws MessageSource.ExistingExclusiveConsumer, MessageSource.ConsumerAccessRefused, MessageSource.ExistingConsumerPreventsExclusive, MessageSource.QueueDeleted {
        if (this.isDeleted()) {
            throw new MessageSource.QueueDeleted();
        }
        if (this.hasExclusiveConsumer()) {
            throw new MessageSource.ExistingExclusiveConsumer();
        }
        Object exclusiveOwner = this._exclusiveOwner;
        final AMQPSession<?, T> session = target.getSession();
        switch (this._exclusive) {
            case CONNECTION: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = session.getAMQPConnection();
                    this.addExclusivityConstraint(session.getAMQPConnection());
                    break;
                }
                if (exclusiveOwner == session.getAMQPConnection()) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case SESSION: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = session;
                    this.addExclusivityConstraint(session);
                    break;
                }
                if (exclusiveOwner == session) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case LINK: {
                if (this.getConsumerCount() == 0) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case PRINCIPAL: {
                Principal currentAuthorizedPrincipal = session.getAMQPConnection().getAuthorizedPrincipal();
                if (exclusiveOwner == null) {
                    exclusiveOwner = currentAuthorizedPrincipal;
                    break;
                }
                if (Objects.equals(((Principal)exclusiveOwner).getName(), currentAuthorizedPrincipal.getName())) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case CONTAINER: {
                if (exclusiveOwner == null) {
                    exclusiveOwner = session.getAMQPConnection().getRemoteContainerName();
                    break;
                }
                if (exclusiveOwner.equals(session.getAMQPConnection().getRemoteContainerName())) break;
                throw new MessageSource.ConsumerAccessRefused();
            }
            case SHARED_SUBSCRIPTION: {
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new ServerScopedRuntimeException("Unknown exclusivity policy " + String.valueOf((Object)this._exclusive));
            }
        }
        boolean exclusive = optionSet.contains((Object)ConsumerOption.EXCLUSIVE);
        boolean isTransient = optionSet.contains((Object)ConsumerOption.TRANSIENT);
        if (this._noLocal && !optionSet.contains((Object)ConsumerOption.NO_LOCAL)) {
            optionSet = EnumSet.copyOf(optionSet);
            optionSet.add(ConsumerOption.NO_LOCAL);
        }
        if (exclusive && this.getConsumerCount() != 0) {
            throw new MessageSource.ExistingConsumerPreventsExclusive();
        }
        if (!this._defaultFiltersMap.isEmpty()) {
            if (filters == null) {
                filters = new FilterManager();
            }
            for (Map.Entry filter : this._defaultFiltersMap.entrySet()) {
                MessageFilter f;
                if (filters.hasFilter((String)filter.getKey())) continue;
                try {
                    f = (MessageFilter)((Callable)filter.getValue()).call();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ServerScopedRuntimeException(e);
                }
                filters.add((String)filter.getKey(), f);
            }
        }
        if (this._ensureNondestructiveConsumers) {
            optionSet = EnumSet.copyOf(optionSet);
            optionSet.removeAll(EnumSet.of(ConsumerOption.SEES_REQUEUES, ConsumerOption.ACQUIRES));
        }
        final QueueConsumerImpl consumer = new QueueConsumerImpl(this, target, consumerName, filters, messageClass, optionSet, priority);
        this._exclusiveOwner = exclusiveOwner;
        if (exclusive && !isTransient) {
            this._exclusiveSubscriber = consumer;
        }
        QueueContext queueContext = filters == null || !filters.startAtTail() ? new QueueContext(this.getEntries().getHead()) : new QueueContext(this.getEntries().getTail());
        consumer.setQueueContext(queueContext);
        if (this._maximumLiveConsumers > 0 && !this.incrementNumberOfLiveConsumersIfApplicable()) {
            consumer.setNonLive(true);
        }
        this._queueConsumerManager.addConsumer(consumer);
        if (consumer.isNotifyWorkDesired()) {
            this._activeSubscriberCount.incrementAndGet();
        }
        this.childAdded(consumer);
        consumer.addChangeListener(this._deletedChildListener);
        session.consumerAdded(consumer);
        this.addChangeListener(new AbstractConfigurationChangeListener(){

            @Override
            public void childRemoved(ConfiguredObject<?> object, ConfiguredObject<?> child) {
                if (child.equals(consumer)) {
                    session.consumerRemoved(consumer);
                    AbstractQueue.this.removeChangeListener(this);
                }
            }
        });
        return consumer;
    }

    @Override
    protected CompletableFuture<Void> beforeClose() {
        this._closing = true;
        return super.beforeClose();
    }

    @Override
    public void close() {
        this._producerCount.set(0L);
        super.close();
    }

    <T extends ConsumerTarget<T>> void unregisterConsumer(QueueConsumerImpl<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer argument is null");
        }
        boolean removed = this._queueConsumerManager.removeConsumer(consumer);
        if (removed) {
            consumer.closeAsync();
            this.clearExclusiveSubscriber();
            consumer.setQueueContext(null);
            if (this._exclusive == ExclusivityPolicy.LINK) {
                this._exclusiveOwner = null;
            }
            if (this._messageGroupManager != null) {
                this.resetSubPointersForGroups(consumer);
            }
            if (this._maximumLiveConsumers > 0 && !consumer.isNonLive()) {
                this.decrementNumberOfLiveConsumersIfApplicable();
                consumer.setNonLive(true);
                this.assignNextLiveConsumerIfApplicable();
            }
            if (!(consumer.isTransient() || this.getLifetimePolicy() != LifetimePolicy.DELETE_ON_NO_OUTBOUND_LINKS && this.getLifetimePolicy() != LifetimePolicy.DELETE_ON_NO_LINKS || this.getConsumerCount() != 0 || consumer.isDurable() && this._closing)) {
                LOGGER.debug("Auto-deleting queue: {}", (Object)this);
                Subject.doAs(this.getSubjectWithAddedSystemRights(), () -> {
                    this.delete();
                    return null;
                });
                consumer.queueDeleted();
            }
        }
    }

    private boolean incrementNumberOfLiveConsumersIfApplicable() {
        int maximumLiveConsumers = this._maximumLiveConsumers;
        boolean added = false;
        int liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
        while (liveConsumers < maximumLiveConsumers) {
            if (LIVE_CONSUMERS_UPDATER.compareAndSet(this, liveConsumers, liveConsumers + 1)) {
                added = true;
                break;
            }
            liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
        }
        return added;
    }

    private boolean decrementNumberOfLiveConsumersIfApplicable() {
        boolean updated = false;
        int liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
        while (liveConsumers > 0) {
            if (LIVE_CONSUMERS_UPDATER.compareAndSet(this, liveConsumers, liveConsumers - 1)) {
                updated = true;
                break;
            }
            liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
        }
        return updated;
    }

    private void assignNextLiveConsumerIfApplicable() {
        int maximumLiveConsumers = this._maximumLiveConsumers;
        int liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
        Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getAllIterator();
        while (consumerIterator.hasNext() && liveConsumers < maximumLiveConsumers) {
            QueueConsumerImpl otherConsumer = (QueueConsumerImpl)consumerIterator.next();
            if (otherConsumer != null && otherConsumer.isNonLive() && LIVE_CONSUMERS_UPDATER.compareAndSet(this, liveConsumers, liveConsumers + 1)) {
                otherConsumer.setNonLive(false);
                otherConsumer.setNotifyWorkDesired(true);
                break;
            }
            liveConsumers = LIVE_CONSUMERS_UPDATER.get(this);
            maximumLiveConsumers = this._maximumLiveConsumers;
        }
    }

    @Override
    public Collection<QueueConsumer<?, ?>> getConsumers() {
        return this.getConsumersImpl();
    }

    private Collection<QueueConsumer<?, ?>> getConsumersImpl() {
        ArrayList result = new ArrayList();
        this._queueConsumerManager.getAllIterator().forEachRemaining(result::add);
        return result;
    }

    public void resetSubPointersForGroups(QueueConsumer<?, ?> consumer) {
        QueueEntry entry = this._messageGroupManager.findEarliestAssignedAvailableEntry(consumer);
        this._messageGroupManager.clearAssignments(consumer);
        if (entry != null) {
            this.resetSubPointersForGroups(entry);
        }
    }

    @Override
    public Collection<PublishingLink> getPublishingLinks() {
        ArrayList<PublishingLink> links = new ArrayList<PublishingLink>();
        for (MessageSender sender : this._linkedSenders.keySet()) {
            Collection<? extends PublishingLink> linksForDestination = sender.getPublishingLinks(this);
            links.addAll(linksForDestination);
        }
        return links;
    }

    @Override
    public int getBindingCount() {
        return this._bindingCount;
    }

    @Override
    public long getProducerCount() {
        return this._producerCount.get();
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
        QueueEntry entry;
        if (this._recovering.get() != 3) {
            boolean addedToRecoveryQueue;
            this._enqueuingWhileRecovering.incrementAndGet();
            try {
                addedToRecoveryQueue = this._recovering.get() == 1;
                if (addedToRecoveryQueue) {
                    this._postRecoveryQueue.add(new EnqueueRequest(message, action, enqueueRecord));
                }
            }
            finally {
                this._enqueuingWhileRecovering.decrementAndGet();
            }
            if (!addedToRecoveryQueue) {
                while (this._recovering.get() != 3) {
                    Thread.yield();
                }
                entry = this.doEnqueue(message, action, enqueueRecord);
            } else {
                entry = null;
            }
        } else {
            entry = this.doEnqueue(message, action, enqueueRecord);
        }
        StoredMessage storedMessage = message.getStoredMessage();
        if ((this._virtualHost.isOverTargetSize() || QpidByteBuffer.getAllocatedDirectMemorySize() > this._flowToDiskThreshold) && storedMessage.getInMemorySize() > 0L) {
            if (message.checkValid()) {
                storedMessage.flowToDisk();
            } else if (entry != null) {
                this.malformedEntry(entry);
            } else {
                LOGGER.debug("Malformed message '{}' enqueued into '{}'", (Object)message, (Object)this.getName());
            }
        }
    }

    @Override
    public final void recover(ServerMessage message, MessageEnqueueRecord enqueueRecord) {
        this.doEnqueue(message, null, enqueueRecord);
    }

    @Override
    public final void completeRecovery() {
        if (this._recovering.compareAndSet(1, 2)) {
            while (this._enqueuingWhileRecovering.get() != 0) {
                Thread.yield();
            }
            this.enqueueFromPostRecoveryQueue();
            this._recovering.set(3);
        }
    }

    private void enqueueFromPostRecoveryQueue() {
        while (!this._postRecoveryQueue.isEmpty()) {
            EnqueueRequest request = this._postRecoveryQueue.poll();
            MessageReference<?> messageReference = request.getMessage();
            this.doEnqueue((ServerMessage)messageReference.getMessage(), request.getAction(), request.getEnqueueRecord());
            messageReference.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueueEntry doEnqueue(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
        QueueEntry entry = this.getEntries().add(message, enqueueRecord);
        this.updateExpiration(entry);
        try {
            if (entry.isAvailable()) {
                this.checkConsumersNotAheadOfDelivery(entry);
                this.notifyConsumers(entry);
            }
            this.checkForNotificationOnNewMessage(entry.getMessage());
        }
        finally {
            RejectPolicyHandler rejectPolicyHandler;
            if (action != null) {
                action.performAction(entry);
            }
            if ((rejectPolicyHandler = this._rejectPolicyHandler) != null) {
                rejectPolicyHandler.postEnqueue(entry);
            }
            this._postEnqueueOverflowPolicyHandler.checkOverflow(entry);
        }
        return entry;
    }

    private void updateExpiration(QueueEntry entry) {
        long expiration = this.calculateExpiration(entry.getMessage());
        if (expiration > 0L) {
            entry.setExpiration(expiration);
        }
    }

    private long calculateExpiration(ServerMessage message) {
        long calculatedExpiration;
        long expiration = message.getExpiration();
        long arrivalTime = message.getArrivalTime();
        if (this._minimumMessageTtl != 0L && expiration != 0L && (calculatedExpiration = this.calculateExpiration(arrivalTime, this._minimumMessageTtl)) > expiration) {
            expiration = calculatedExpiration;
        }
        if (this._maximumMessageTtl != 0L) {
            calculatedExpiration = this.calculateExpiration(arrivalTime, this._maximumMessageTtl);
            if (expiration == 0L || expiration > calculatedExpiration) {
                expiration = calculatedExpiration;
            }
        }
        return expiration;
    }

    private long calculateExpiration(long arrivalTime, long ttl) {
        long sum;
        try {
            sum = Math.addExact(arrivalTime == 0L ? System.currentTimeMillis() : arrivalTime, ttl);
        }
        catch (ArithmeticException e) {
            sum = Long.MAX_VALUE;
        }
        return sum;
    }

    private boolean assign(QueueConsumer<?, ?> sub, QueueEntry entry) {
        if (this._messageGroupManager == null) {
            return entry.acquire(sub);
        }
        return this._messageGroupManager.acceptMessage(sub, entry);
    }

    private boolean mightAssign(QueueConsumer sub, QueueEntry entry) {
        return this._messageGroupManager == null || !sub.acquires() || this._messageGroupManager.mightAssign(entry, sub);
    }

    protected void checkConsumersNotAheadOfDelivery(QueueEntry entry) {
    }

    @Override
    public long getTotalDequeuedMessages() {
        return this._queueStatistics.getDequeueCount();
    }

    @Override
    public long getTotalEnqueuedMessages() {
        return this._queueStatistics.getEnqueueCount();
    }

    @Override
    public void resetStatistics() {
        this._queueStatistics.reset();
        this.getConsumers().forEach(Consumer::resetStatistics);
    }

    private void setLastSeenEntry(QueueConsumer<?, ?> sub, QueueEntry entry) {
        QueueContext subContext = sub.getQueueContext();
        if (subContext != null) {
            QueueEntry releasedEntry = subContext.getReleasedEntry();
            QueueContext._lastSeenUpdater.set(subContext, entry);
            if (releasedEntry == entry) {
                QueueContext._releasedUpdater.compareAndSet(subContext, releasedEntry, null);
            }
        }
    }

    private void updateSubRequeueEntry(QueueConsumer<?, ?> sub, QueueEntry entry) {
        QueueContext subContext = sub.getQueueContext();
        if (subContext != null) {
            QueueEntry oldEntry;
            while ((oldEntry = subContext.getReleasedEntry()) == null || oldEntry.compareTo(entry) > 0) {
                if (!QueueContext._releasedUpdater.compareAndSet(subContext, oldEntry, entry)) continue;
                this.notifyConsumer(sub);
                break;
            }
        }
    }

    @Override
    public void resetSubPointersForGroups(QueueEntry entry) {
        this.resetSubPointers(entry, true);
    }

    @Override
    public void requeue(QueueEntry entry) {
        this.resetSubPointers(entry, false);
    }

    private void resetSubPointers(QueueEntry entry, boolean ignoreAvailable) {
        Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getAllIterator();
        while (consumerIterator.hasNext() && (ignoreAvailable || entry.isAvailable())) {
            QueueConsumer<?, ?> sub = consumerIterator.next();
            if (!sub.seesRequeues()) continue;
            this.updateSubRequeueEntry(sub, entry);
        }
    }

    @Override
    public int getConsumerCount() {
        return this._queueConsumerManager.getAllSize();
    }

    @Override
    public int getConsumerCountWithCredit() {
        return this._activeSubscriberCount.get();
    }

    @Override
    public boolean isUnused() {
        return this.getConsumerCount() == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.getQueueDepthMessages() == 0;
    }

    @Override
    public int getQueueDepthMessages() {
        return this._queueStatistics.getQueueCount();
    }

    @Override
    public long getQueueDepthBytes() {
        return this._queueStatistics.getQueueSize();
    }

    @Override
    public long getAvailableBytes() {
        return this._queueStatistics.getAvailableSize();
    }

    @Override
    public int getAvailableMessages() {
        return this._queueStatistics.getAvailableCount();
    }

    @Override
    public long getAvailableBytesHighWatermark() {
        return this._queueStatistics.getAvailableSizeHwm();
    }

    @Override
    public int getAvailableMessagesHighWatermark() {
        return this._queueStatistics.getAvailableCountHwm();
    }

    @Override
    public long getQueueDepthBytesHighWatermark() {
        return this._queueStatistics.getQueueSizeHwm();
    }

    @Override
    public int getQueueDepthMessagesHighWatermark() {
        return this._queueStatistics.getQueueCountHwm();
    }

    @Override
    public long getOldestMessageArrivalTime() {
        long oldestMessageArrivalTime = -1L;
        while (oldestMessageArrivalTime == -1L) {
            QueueEntry entry;
            QueueEntryList entries = this.getEntries();
            QueueEntry queueEntry = entry = entries == null ? null : entries.getOldestEntry();
            if (entry != null) {
                ServerMessage message = entry.getMessage();
                if (message == null) continue;
                try (MessageReference reference = message.newReference();){
                    oldestMessageArrivalTime = reference.getMessage().getArrivalTime();
                }
                catch (MessageDeletedException messageDeletedException) {}
                continue;
            }
            oldestMessageArrivalTime = 0L;
        }
        return oldestMessageArrivalTime;
    }

    @Override
    public long getOldestMessageAge() {
        long oldestMessageArrivalTime = this.getOldestMessageArrivalTime();
        return oldestMessageArrivalTime == 0L ? 0L : System.currentTimeMillis() - oldestMessageArrivalTime;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted.get();
    }

    @Override
    public int getMaximumLiveConsumers() {
        return this._maximumLiveConsumers;
    }

    boolean wouldExpire(ServerMessage message) {
        long expiration = this.calculateExpiration(message);
        return expiration != 0L && expiration <= System.currentTimeMillis();
    }

    @Override
    public List<QueueEntry> getMessagesOnTheQueue() {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node == null || node.isDeleted()) continue;
            entryList.add(node);
        }
        return entryList;
    }

    @Override
    public QueueEntryIterator queueEntryIterator() {
        return this.getEntries().iterator();
    }

    @Override
    public int compareTo(X o) {
        return this.getName().compareTo(((AbstractConfiguredObject)o).getName());
    }

    private boolean hasExclusiveConsumer() {
        return this._exclusiveSubscriber != null;
    }

    private void clearExclusiveSubscriber() {
        this._exclusiveSubscriber = null;
    }

    abstract QueueEntryList getEntries();

    final QueueStatistics getQueueStatistics() {
        return this._queueStatistics;
    }

    protected final QueueConsumerManagerImpl getQueueConsumerManager() {
        return this._queueConsumerManager;
    }

    public EventLogger getEventLogger() {
        return this._virtualHost.getEventLogger();
    }

    @Override
    public QueueEntry getMessageOnTheQueue(final long messageId) {
        List<QueueEntry> entries = this.getMessagesOnTheQueue(new QueueEntryFilter(){
            private boolean _complete;

            @Override
            public boolean accept(QueueEntry entry) {
                this._complete = entry.getMessage().getMessageNumber() == messageId;
                return this._complete;
            }

            @Override
            public boolean filterComplete() {
                return this._complete;
            }
        });
        return entries.isEmpty() ? null : entries.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<QueueEntry> getMessagesOnTheQueue(QueueEntryFilter filter) {
        ArrayList<QueueEntry> entryList = new ArrayList<QueueEntry>();
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance() && !filter.filterComplete()) {
            QueueEntry node = queueListIterator.getNode();
            MessageReference reference = node.newMessageReference();
            if (reference == null) continue;
            try {
                if (node.isDeleted() || !filter.accept(node)) continue;
                entryList.add(node);
            }
            finally {
                reference.release();
            }
        }
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(QueueEntryVisitor visitor) {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            MessageReference reference = node.newMessageReference();
            if (reference == null) continue;
            try {
                if (node.isDeleted() || !reference.getMessage().checkValid() || !visitor.visit(node)) continue;
                break;
            }
            finally {
                reference.release();
            }
        }
    }

    @Override
    public long clearQueue() {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        long count = 0L;
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
        while (queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            boolean acquired = node.acquireOrSteal(new DequeueEntryTask(node, null));
            if (!acquired) continue;
            this.dequeueEntry(node, txn);
            ++count;
        }
        txn.commit();
        this.logOperation(String.format("clearQueue : %s: %d", this.getName(), count));
        return count;
    }

    private void dequeueEntry(QueueEntry node) {
        AsyncAutoCommitTransaction txn = new AsyncAutoCommitTransaction(this.getVirtualHost().getMessageStore(), (future, action) -> action.postCommit());
        this.dequeueEntry(node, txn);
    }

    private void dequeueEntry(final QueueEntry node, ServerTransaction txn) {
        txn.dequeue(node.getEnqueueRecord(), new ServerTransaction.Action(){

            @Override
            public void postCommit() {
                node.delete();
            }

            @Override
            public void onRollback() {
            }
        });
    }

    @Override
    public void deleteEntry(QueueEntry entry) {
        this.deleteEntry(entry, null);
    }

    private void deleteEntry(QueueEntry entry, Runnable postDequeueTask) {
        boolean acquiredForDequeueing = entry.acquireOrSteal(new DequeueEntryTask(entry, postDequeueTask));
        if (acquiredForDequeueing) {
            LOGGER.debug("Dequeuing node {}", (Object)entry);
            this.dequeueEntry(entry);
            if (postDequeueTask != null) {
                postDequeueTask.run();
            }
        }
    }

    private void routeToAlternate(QueueEntry entry, Runnable postRouteTask, Predicate<BaseQueue> predicate) {
        boolean acquiredForDequeueing = entry.acquireOrSteal(() -> {
            LOGGER.debug("routing stolen node {} to alternate", (Object)entry);
            entry.routeToAlternate(null, null, predicate);
            if (postRouteTask != null) {
                postRouteTask.run();
            }
        });
        if (acquiredForDequeueing) {
            LOGGER.debug("routing node {} to alternate", (Object)entry);
            entry.routeToAlternate(null, null, predicate);
            if (postRouteTask != null) {
                postRouteTask.run();
            }
        }
    }

    @Override
    public void addDeleteTask(Action<? super X> task) {
        this._deleteTaskList.add(task);
    }

    @Override
    public void removeDeleteTask(Action<? super X> task) {
        this._deleteTaskList.remove(task);
    }

    @Override
    public int deleteAndReturnCount() {
        return this.doSync(this.deleteAndReturnCountAsync());
    }

    @Override
    public CompletableFuture<Integer> deleteAndReturnCountAsync() {
        return this.deleteAsync().thenApplyAsync(v -> this._deleteQueueDepthFuture.join(), (Executor)this.getTaskExecutor());
    }

    private CompletableFuture<Integer> performDelete() {
        if (this._deleted.compareAndSet(false, true)) {
            if (this.getState() == State.UNINITIALIZED) {
                this.preSetAlternateBinding();
                this._deleteQueueDepthFuture.complete(0);
            } else if (this._transactions.isEmpty()) {
                this.doDelete();
            } else {
                this.deleteAfterCompletionOfDischargingTransactions();
            }
        }
        return this._deleteQueueDepthFuture;
    }

    private void doDelete() {
        try {
            int queueDepthMessages = this.getQueueDepthMessages();
            for (MessageSender sender : this._linkedSenders.keySet()) {
                sender.destinationRemoved(this);
            }
            Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getAllIterator();
            while (consumerIterator.hasNext()) {
                QueueConsumer<?, ?> consumer = consumerIterator.next();
                if (consumer == null) continue;
                consumer.queueDeleted();
            }
            List<QueueEntry> entries = this.getMessagesOnTheQueue(new AcquireAllQueueEntryFilter());
            this.routeToAlternate(entries);
            this.preSetAlternateBinding();
            this._alternateBinding = null;
            this._stopped.set(true);
            this._queueHouseKeepingTask.cancel();
            this.performQueueDeleteTasks();
            this._deleteQueueDepthFuture.complete(queueDepthMessages);
            this._transactions.clear();
        }
        catch (Throwable e) {
            this._deleteQueueDepthFuture.completeExceptionally(e);
        }
    }

    private void deleteAfterCompletionOfDischargingTransactions() {
        List dischargingTxs = this._transactions.stream().filter(t -> !t.isDischarged() && !t.isRollbackOnly() && !t.setRollbackOnly()).map(t -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            LocalTransaction.LocalTransactionListener listener = tx -> future.complete(null);
            t.addTransactionListener(listener);
            if (t.isRollbackOnly() || t.isDischarged()) {
                future.complete(null);
                t.removeTransactionListener(listener);
            }
            return future;
        }).collect(Collectors.toList());
        if (dischargingTxs.isEmpty()) {
            this.doDelete();
        } else {
            CompletionStage completionStage = CompletableFuture.allOf((CompletableFuture[])dischargingTxs.toArray(CompletableFuture[]::new)).whenComplete((result, error) -> {
                if (error != null) {
                    this._deleteQueueDepthFuture.completeExceptionally((Throwable)error);
                } else {
                    this.doDelete();
                }
            });
        }
    }

    private void routeToAlternate(List<QueueEntry> entries) {
        LocalTransaction txn = new LocalTransaction(this.getVirtualHost().getMessageStore());
        for (QueueEntry entry : entries) {
            int requeues = entry.routeToAlternate(null, txn, null);
            if (requeues != 0) continue;
        }
        txn.commit();
    }

    private void performQueueDeleteTasks() {
        for (Action<X> task : this._deleteTaskList) {
            task.performAction(this);
        }
        this._deleteTaskList.clear();
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        this._stopped.set(true);
        this._closing = false;
        this._queueHouseKeepingTask.cancel();
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void checkCapacity() {
        this._postEnqueueOverflowPolicyHandler.checkOverflow(null);
    }

    void notifyConsumers(QueueEntry entry) {
        QueueConsumer<?, ?> consumer;
        Iterator<QueueConsumer<?, ?>> nonAcquiringIterator = this._queueConsumerManager.getNonAcquiringIterator();
        while (nonAcquiringIterator.hasNext()) {
            QueueConsumer<?, ?> consumer2 = nonAcquiringIterator.next();
            if (!consumer2.hasInterest(entry)) continue;
            this.notifyConsumer(consumer2);
        }
        Iterator<QueueConsumer<?, ?>> interestedIterator = this._queueConsumerManager.getInterestedIterator();
        while (entry.isAvailable() && interestedIterator.hasNext() && (!(consumer = interestedIterator.next()).hasInterest(entry) || !this.notifyConsumer(consumer) && this.noHigherPriorityWithCredit(consumer, entry))) {
        }
    }

    void notifyOtherConsumers(QueueConsumer<?, ?> excludedConsumer) {
        QueueConsumer<?, ?> consumer;
        Iterator<QueueConsumer<?, ?>> interestedIterator = this._queueConsumerManager.getInterestedIterator();
        while (this.hasAvailableMessages() && interestedIterator.hasNext() && (excludedConsumer == (consumer = interestedIterator.next()) || !this.notifyConsumer(consumer))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageContainer deliverSingleMessage(QueueConsumer<?, ?> consumer) {
        boolean queueEmpty = false;
        MessageContainer messageContainer = null;
        this._queueConsumerManager.setNotified(consumer, false);
        try {
            if (!consumer.isSuspended()) {
                messageContainer = consumer.isNonLive() ? NO_MESSAGES : this.attemptDelivery(consumer);
                if (messageContainer.getMessageInstance() == null) {
                    if (consumer.acquires() && this.hasAvailableMessages()) {
                        this.notifyOtherConsumers(consumer);
                    }
                    consumer.noMessagesAvailable();
                    messageContainer = null;
                } else {
                    this._queueConsumerManager.setNotified(consumer, true);
                }
            } else {
                this.getNextAvailableEntry(consumer);
            }
        }
        finally {
            consumer.flushBatched();
        }
        return messageContainer;
    }

    private boolean hasAvailableMessages() {
        return this._queueStatistics.getAvailableCount() != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private MessageContainer attemptDelivery(QueueConsumer<?, ?> sub) {
        QueueEntry node = this.getNextAvailableEntry(sub);
        boolean subActive = sub.isActive() && !sub.isSuspended() && !sub.isNonLive();
        if (node == null) return NO_MESSAGES;
        if (!subActive) return NO_MESSAGES;
        if (sub.getPriority() != Integer.MAX_VALUE) {
            if (!this.noHigherPriorityWithCredit(sub, node)) return NO_MESSAGES;
        }
        if (this._virtualHost.getState() != State.ACTIVE) {
            throw new ConnectionScopedRuntimeException("Delivery halted owing to virtualhost state " + String.valueOf((Object)this._virtualHost.getState()));
        }
        if (!node.isAvailable()) return NO_MESSAGES;
        if (!this.mightAssign(sub, node)) return NO_MESSAGES;
        if (!sub.allocateCredit(node)) {
            sub.awaitCredit(node);
            return NO_MESSAGES;
        }
        MessageReference messageReference = null;
        if (sub.acquires() && !this.assign(sub, node) || !sub.acquires() && (messageReference = node.newMessageReference()) == null) {
            sub.restoreCredit(node);
            return NO_MESSAGES;
        }
        this.setLastSeenEntry(sub, node);
        return new MessageContainer(node, messageReference);
    }

    private boolean noHigherPriorityWithCredit(QueueConsumer<?, ?> sub, QueueEntry queueEntry) {
        QueueConsumer<?, ?> consumer;
        Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getAllIterator();
        while (consumerIterator.hasNext() && (consumer = consumerIterator.next()).getPriority() > sub.getPriority()) {
            if (!consumer.isNotifyWorkDesired() || !consumer.acquires() || !consumer.hasInterest(queueEntry) || this.getNextAvailableEntry(consumer) == null) continue;
            return false;
        }
        return true;
    }

    private QueueEntry getNextAvailableEntry(QueueConsumer<?, ?> sub) {
        QueueContext context = sub.getQueueContext();
        if (context != null) {
            QueueEntry lastSeen = context.getLastSeenEntry();
            QueueEntry releasedNode = context.getReleasedEntry();
            QueueEntry node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this.getEntries().next(lastSeen);
            boolean expired = false;
            while (!(node == null || node.isAvailable() && !(expired = node.expired()) && sub.hasInterest(node) && this.mightAssign(sub, node))) {
                if (expired) {
                    expired = false;
                    this.expireEntry(node);
                }
                if (QueueContext._lastSeenUpdater.compareAndSet(context, lastSeen, node)) {
                    QueueContext._releasedUpdater.compareAndSet(context, releasedNode, null);
                }
                lastSeen = context.getLastSeenEntry();
                releasedNode = context.getReleasedEntry();
                node = releasedNode != null && lastSeen.compareTo(releasedNode) >= 0 ? releasedNode : this.getEntries().next(lastSeen);
            }
            return node;
        }
        return null;
    }

    @Override
    public boolean isEntryAheadOfConsumer(QueueEntry entry, QueueConsumer<?, ?> sub) {
        QueueContext context = sub.getQueueContext();
        if (context != null) {
            QueueEntry releasedNode = context.getReleasedEntry();
            return releasedNode != null && releasedNode.compareTo(entry) < 0;
        }
        return false;
    }

    @Override
    public void checkMessageStatus() {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        HashSet<NotificationCheck> perMessageChecks = new HashSet<NotificationCheck>();
        HashSet<NotificationCheck> queueLevelChecks = new HashSet<NotificationCheck>();
        for (NotificationCheck check : this.getNotificationChecks()) {
            if (check.isMessageSpecific()) {
                perMessageChecks.add(check);
                continue;
            }
            queueLevelChecks.add(check);
        }
        QueueNotificationListener listener = this._notificationListener;
        long currentTime = System.currentTimeMillis();
        long thresholdTime = currentTime - this.getAlertRepeatGap();
        while (!this._stopped.get() && queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node.isDeleted()) continue;
            if (node.expired()) {
                this.expireEntry(node);
                continue;
            }
            node.checkHeld(currentTime);
            ServerMessage msg = node.getMessage();
            if (msg == null) continue;
            try {
                MessageReference messageReference = msg.newReference();
                try {
                    if (!msg.checkValid()) {
                        this.malformedEntry(node);
                        continue;
                    }
                    for (NotificationCheck check : perMessageChecks) {
                        this.checkForNotification(msg, listener, currentTime, thresholdTime, check);
                    }
                }
                finally {
                    if (messageReference == null) continue;
                    messageReference.close();
                }
            }
            catch (MessageDeletedException messageDeletedException) {}
        }
        for (NotificationCheck check : queueLevelChecks) {
            this.checkForNotification(null, listener, currentTime, thresholdTime, check);
        }
    }

    private void expireEntry(QueueEntry node) {
        Queue.ExpiryPolicy expiryPolicy = this.getExpiryPolicy();
        long sizeWithHeader = node.getSizeWithHeader();
        switch (expiryPolicy) {
            case DELETE: {
                this.deleteEntry(node, () -> this._queueStatistics.addToExpired(sizeWithHeader));
                break;
            }
            case ROUTE_TO_ALTERNATE: {
                this.routeToAlternate(node, () -> this._queueStatistics.addToExpired(sizeWithHeader), q -> !(q instanceof AbstractQueue) || !((AbstractQueue)q).wouldExpire(node.getMessage()));
                break;
            }
            default: {
                throw new ServerScopedRuntimeException("Unknown expiry policy: " + String.valueOf((Object)expiryPolicy) + " this is a coding error inside Qpid");
            }
        }
    }

    private void malformedEntry(QueueEntry node) {
        this.deleteEntry(node, () -> {
            this._queueStatistics.addToMalformed(node.getSizeWithHeader());
            this.logMalformedMessage(node);
        });
    }

    private void logMalformedMessage(QueueEntry node) {
        EventLogger eventLogger = this.getEventLogger();
        ServerMessage message = node.getMessage();
        StringBuilder messageId = new StringBuilder();
        messageId.append(message.getMessageNumber());
        String id = message.getMessageHeader().getMessageId();
        if (id != null) {
            messageId.append('/').append(id);
        }
        eventLogger.message(this.getLogSubject(), QueueMessages.MALFORMED_MESSAGE(messageId.toString(), "DELETE"));
    }

    @Override
    public boolean checkValid(QueueEntry queueEntry) {
        ServerMessage message = queueEntry.getMessage();
        boolean isValid = true;
        try (MessageReference ref = message.newReference();){
            isValid = message.checkValid();
        }
        catch (MessageDeletedException messageDeletedException) {
            // empty catch block
        }
        return isValid;
    }

    @Override
    public long getTotalMalformedBytes() {
        return this._queueStatistics.getMalformedSize();
    }

    @Override
    public long getTotalMalformedMessages() {
        return this._queueStatistics.getMalformedCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reallocateMessages() {
        QueueEntryIterator queueListIterator = this.getEntries().iterator();
        while (!this._stopped.get() && queueListIterator.advance()) {
            QueueEntry node = queueListIterator.getNode();
            if (node.isDeleted() || node.expired()) continue;
            try {
                ServerMessage message = node.getMessage();
                MessageReference messageReference = message.newReference();
                try {
                    if (!message.checkValid()) {
                        this.malformedEntry(node);
                        continue;
                    }
                    message.getStoredMessage().reallocate();
                }
                finally {
                    messageReference.release();
                }
            }
            catch (MessageDeletedException messageDeletedException) {}
        }
    }

    private boolean consumerHasAvailableMessages(QueueConsumer consumer) {
        QueueEntry queueEntry;
        return !consumer.acquires() || (queueEntry = this.getNextAvailableEntry(consumer)) != null && this.noHigherPriorityWithCredit(consumer, queueEntry);
    }

    void setNotifyWorkDesired(QueueConsumer consumer, boolean desired) {
        block3: {
            if (!this._queueConsumerManager.setInterest(consumer, desired)) break block3;
            if (desired) {
                this._activeSubscriberCount.incrementAndGet();
                this.notifyConsumer(consumer);
            } else {
                QueueConsumer<?, ?> queueConsumer;
                this._activeSubscriberCount.decrementAndGet();
                Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getInterestedIterator();
                int highestNotifiedPriority = this._queueConsumerManager.getHighestNotifiedPriority();
                while (consumerIterator.hasNext() && (queueConsumer = consumerIterator.next()).getPriority() >= highestNotifiedPriority && !this.notifyConsumer(queueConsumer)) {
                }
            }
        }
    }

    private boolean notifyConsumer(QueueConsumer<?, ?> consumer) {
        if (this.consumerHasAvailableMessages(consumer) && this._queueConsumerManager.setNotified(consumer, true)) {
            consumer.notifyWork();
            return true;
        }
        return false;
    }

    @Override
    public long getAlertRepeatGap() {
        return this._alertRepeatGap;
    }

    @Override
    public long getAlertThresholdMessageAge() {
        return this._alertThresholdMessageAge;
    }

    @Override
    public long getAlertThresholdQueueDepthMessages() {
        return this._alertThresholdQueueDepthMessages;
    }

    private void updateAlertChecks() {
        this.updateNotificationCheck(this.getAlertThresholdQueueDepthMessages(), NotificationCheck.MESSAGE_COUNT_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdQueueDepthBytes(), NotificationCheck.QUEUE_DEPTH_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdMessageAge(), NotificationCheck.MESSAGE_AGE_ALERT);
        this.updateNotificationCheck(this.getAlertThresholdMessageSize(), NotificationCheck.MESSAGE_SIZE_ALERT);
    }

    private void updateNotificationCheck(long checkValue, NotificationCheck notificationCheck) {
        if (checkValue == 0L) {
            this._notificationChecks.remove((Object)notificationCheck);
        } else {
            this._notificationChecks.add(notificationCheck);
        }
    }

    @Override
    public long getAlertThresholdQueueDepthBytes() {
        return this._alertThresholdQueueDepthBytes;
    }

    @Override
    public long getAlertThresholdMessageSize() {
        return this._alertThresholdMessageSize;
    }

    @Override
    public Set<NotificationCheck> getNotificationChecks() {
        return this._notificationChecks;
    }

    @Override
    public long getTotalEnqueuedBytes() {
        return this._queueStatistics.getEnqueueSize();
    }

    @Override
    public long getTotalDequeuedBytes() {
        return this._queueStatistics.getDequeueSize();
    }

    @Override
    public long getPersistentEnqueuedBytes() {
        return this._queueStatistics.getPersistentEnqueueSize();
    }

    @Override
    public long getPersistentDequeuedBytes() {
        return this._queueStatistics.getPersistentDequeueSize();
    }

    @Override
    public long getPersistentEnqueuedMessages() {
        return this._queueStatistics.getPersistentEnqueueCount();
    }

    @Override
    public long getPersistentDequeuedMessages() {
        return this._queueStatistics.getPersistentDequeueCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isHeld(QueueEntry queueEntry, long evaluationTime) {
        if (this._holdMethods.isEmpty()) return false;
        ServerMessage message = queueEntry.getMessage();
        try {
            MessageReference ref = message.newReference();
            try {
                for (HoldMethod method : this._holdMethods) {
                    if (!method.isHeld(ref, evaluationTime)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                ref.release();
            }
        }
        catch (MessageDeletedException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public long getUnacknowledgedMessages() {
        return this._queueStatistics.getUnackedCount();
    }

    @Override
    public long getUnacknowledgedBytes() {
        return this._queueStatistics.getUnackedSize();
    }

    @Override
    public int getMaximumDeliveryAttempts() {
        return this._maximumDeliveryAttempts;
    }

    @Override
    public long getTotalExpiredBytes() {
        return this._queueStatistics.getExpiredSize();
    }

    @Override
    public long getTotalExpiredMessages() {
        return this._queueStatistics.getExpiredCount();
    }

    private void checkForNotification(ServerMessage<?> msg, QueueNotificationListener listener, long currentTime, long thresholdTime, NotificationCheck check) {
        if ((check.isMessageSpecific() || this._lastNotificationTimes[check.ordinal()] < thresholdTime) && check.notifyIfNecessary(msg, this, listener)) {
            this._lastNotificationTimes[check.ordinal()] = currentTime;
        }
    }

    private void checkForNotificationOnNewMessage(ServerMessage<?> msg) {
        Set<NotificationCheck> notificationChecks = this.getNotificationChecks();
        QueueNotificationListener listener = this._notificationListener;
        if (!notificationChecks.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            long thresholdTime = currentTime - this.getAlertRepeatGap();
            for (NotificationCheck check : notificationChecks) {
                if (!check.isCheckOnMessageArrival()) continue;
                this.checkForNotification(msg, listener, currentTime, thresholdTime, check);
            }
        }
    }

    @Override
    public void setNotificationListener(QueueNotificationListener listener) {
        this._notificationListener = listener == null ? NULL_NOTIFICATION_LISTENER : listener;
    }

    @Override
    public <M extends ServerMessage<? extends StorableMessageMetaData>> RoutingResult<M> route(M message, String routingAddress, InstanceProperties instanceProperties) {
        if (this._virtualHost.getState() != State.ACTIVE) {
            throw new VirtualHostUnavailableException(this._virtualHost);
        }
        RoutingResult<M> result = new RoutingResult<M>(message);
        if (!message.isResourceAcceptable(this)) {
            result.addRejectReason(this, RejectType.PRECONDITION_FAILED, String.format("Not accepted by queue '%s'", this.getName()));
        } else if (message.isReferenced(this)) {
            result.addRejectReason(this, RejectType.ALREADY_ENQUEUED, String.format("Already enqueued on queue '%s'", this.getName()));
        } else {
            try {
                RejectPolicyHandler rejectPolicyHandler = this._rejectPolicyHandler;
                if (rejectPolicyHandler != null) {
                    rejectPolicyHandler.checkReject(message);
                }
                result.addQueue(this);
            }
            catch (MessageUnacceptableException e) {
                result.addRejectReason(this, RejectType.LIMIT_EXCEEDED, e.getMessage());
            }
        }
        return result;
    }

    @Override
    public boolean verifySessionAccess(AMQPSession<?, ?> session) {
        return switch (this._exclusive) {
            case ExclusivityPolicy.NONE -> true;
            case ExclusivityPolicy.SESSION -> this._exclusiveOwner == null || this._exclusiveOwner == session;
            case ExclusivityPolicy.CONNECTION -> this._exclusiveOwner == null || this._exclusiveOwner == session.getAMQPConnection();
            case ExclusivityPolicy.PRINCIPAL -> this._exclusiveOwner == null || Objects.equals(((Principal)this._exclusiveOwner).getName(), session.getAMQPConnection().getAuthorizedPrincipal().getName());
            case ExclusivityPolicy.CONTAINER -> this._exclusiveOwner == null || this._exclusiveOwner.equals(session.getAMQPConnection().getRemoteContainerName());
            case ExclusivityPolicy.LINK -> this._exclusiveSubscriber == null || this._exclusiveSubscriber.getSession() == session;
            default -> throw new ServerScopedRuntimeException("Unknown exclusivity policy " + String.valueOf((Object)this._exclusive));
        };
    }

    private void updateExclusivityPolicy(ExclusivityPolicy desiredPolicy) throws MessageSource.ExistingConsumerPreventsExclusive {
        if (desiredPolicy == null) {
            desiredPolicy = ExclusivityPolicy.NONE;
        }
        if (desiredPolicy != this._exclusive) {
            switch (desiredPolicy) {
                case NONE: {
                    this._exclusiveOwner = null;
                    break;
                }
                case PRINCIPAL: {
                    this.switchToPrincipalExclusivity();
                    break;
                }
                case CONTAINER: {
                    this.switchToContainerExclusivity();
                    break;
                }
                case CONNECTION: {
                    this.switchToConnectionExclusivity();
                    break;
                }
                case SESSION: {
                    this.switchToSessionExclusivity();
                    break;
                }
                case LINK: {
                    this.switchToLinkExclusivity();
                }
            }
            this._exclusive = desiredPolicy;
        }
    }

    private void switchToLinkExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this.getConsumerCount()) {
            case 1: {
                Iterator<QueueConsumer<?, ?>> consumerIterator = this._queueConsumerManager.getAllIterator();
                if (consumerIterator.hasNext()) {
                    this._exclusiveSubscriber = consumerIterator.next();
                }
            }
            case 0: {
                this._exclusiveOwner = null;
                break;
            }
            default: {
                throw new MessageSource.ExistingConsumerPreventsExclusive();
            }
        }
    }

    private void switchToSessionExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case CONTAINER: 
            case CONNECTION: 
            case NONE: {
                Session session = null;
                Iterator<QueueConsumer<?, ?>> queueConsumerIterator = this._queueConsumerManager.getAllIterator();
                while (queueConsumerIterator.hasNext()) {
                    QueueConsumer<?, ?> c = queueConsumerIterator.next();
                    if (session == null) {
                        session = c.getSession();
                        continue;
                    }
                    if (session.equals(c.getSession())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = session;
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSession().getAMQPConnection();
            }
        }
    }

    private void switchToConnectionExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case CONTAINER: 
            case NONE: {
                AMQPConnection<?> con = null;
                Iterator<QueueConsumer<?, ?>> queueConsumerIterator = this._queueConsumerManager.getAllIterator();
                while (queueConsumerIterator.hasNext()) {
                    QueueConsumer<?, ?> c = queueConsumerIterator.next();
                    if (con == null) {
                        con = c.getSession().getAMQPConnection();
                        continue;
                    }
                    if (con.equals(c.getSession().getAMQPConnection())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = con;
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPSession)this._exclusiveOwner).getAMQPConnection();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSession().getAMQPConnection();
            }
        }
    }

    private void switchToContainerExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case PRINCIPAL: 
            case NONE: {
                String containerID = null;
                Iterator<QueueConsumer<?, ?>> queueConsumerIterator = this._queueConsumerManager.getAllIterator();
                while (queueConsumerIterator.hasNext()) {
                    QueueConsumer<?, ?> c = queueConsumerIterator.next();
                    if (containerID == null) {
                        containerID = c.getSession().getAMQPConnection().getRemoteContainerName();
                        continue;
                    }
                    if (containerID.equals(c.getSession().getAMQPConnection().getRemoteContainerName())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = containerID;
                break;
            }
            case CONNECTION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPConnection)this._exclusiveOwner).getRemoteContainerName();
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPSession)this._exclusiveOwner).getAMQPConnection().getRemoteContainerName();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSession().getAMQPConnection().getRemoteContainerName();
            }
        }
    }

    private void switchToPrincipalExclusivity() throws MessageSource.ExistingConsumerPreventsExclusive {
        switch (this._exclusive) {
            case CONTAINER: 
            case NONE: {
                Principal principal = null;
                Iterator<QueueConsumer<?, ?>> queueConsumerIterator = this._queueConsumerManager.getAllIterator();
                while (queueConsumerIterator.hasNext()) {
                    QueueConsumer<?, ?> c = queueConsumerIterator.next();
                    if (principal == null) {
                        principal = c.getSession().getAMQPConnection().getAuthorizedPrincipal();
                        continue;
                    }
                    if (Objects.equals(principal.getName(), c.getSession().getAMQPConnection().getAuthorizedPrincipal().getName())) continue;
                    throw new MessageSource.ExistingConsumerPreventsExclusive();
                }
                this._exclusiveOwner = principal;
                break;
            }
            case CONNECTION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPConnection)this._exclusiveOwner).getAuthorizedPrincipal();
                break;
            }
            case SESSION: {
                this._exclusiveOwner = this._exclusiveOwner == null ? null : ((AMQPSession)this._exclusiveOwner).getAMQPConnection().getAuthorizedPrincipal();
                break;
            }
            case LINK: {
                this._exclusiveOwner = this._exclusiveSubscriber == null ? null : this._exclusiveSubscriber.getSession().getAMQPConnection().getAuthorizedPrincipal();
            }
        }
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    private CompletableFuture<Void> activate() {
        this._virtualHost.scheduleHouseKeepingTask(this._virtualHost.getHousekeepingCheckPeriod(), this._queueHouseKeepingTask);
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected CompletableFuture<Void> onDelete() {
        return this.performDelete().thenApplyAsync(i -> null, (Executor)this.getTaskExecutor());
    }

    @Override
    public ExclusivityPolicy getExclusive() {
        return this._exclusive;
    }

    @Override
    public OverflowPolicy getOverflowPolicy() {
        return this._overflowPolicy;
    }

    @Override
    public boolean isNoLocal() {
        return this._noLocal;
    }

    @Override
    public String getMessageGroupKeyOverride() {
        return this._messageGroupKeyOverride;
    }

    @Override
    public MessageGroupType getMessageGroupType() {
        return this._messageGroupType;
    }

    @Override
    public String getMessageGroupDefaultGroup() {
        return this._messageGroupDefaultGroup;
    }

    @Override
    public int getMaximumDistinctGroups() {
        return this._maximumDistinctGroups;
    }

    @Override
    public boolean isQueueFlowStopped() {
        if (this._postEnqueueOverflowPolicyHandler instanceof ProducerFlowControlOverflowPolicyHandler) {
            return ((ProducerFlowControlOverflowPolicyHandler)this._postEnqueueOverflowPolicyHandler).isQueueFlowStopped();
        }
        return false;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Consumer.class) {
            if (this._queueConsumerManager == null) {
                return Set.of();
            }
            ArrayList result = new ArrayList();
            this._queueConsumerManager.getAllIterator().forEachRemaining(result::add);
            return result;
        }
        return super.getChildren(clazz);
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        OverflowPolicy existingOverflowPolicy = this.getOverflowPolicy();
        ExclusivityPolicy existingExclusivePolicy = this.getExclusive();
        super.changeAttributes(attributes);
        if (attributes.containsKey("overflowPolicy") && existingOverflowPolicy != this._overflowPolicy) {
            if (existingOverflowPolicy == OverflowPolicy.REJECT) {
                this._rejectPolicyHandler = null;
            }
            this.createOverflowPolicyHandlers(this._overflowPolicy);
            this._postEnqueueOverflowPolicyHandler.checkOverflow(null);
        }
        if (attributes.containsKey("exclusive") && existingExclusivePolicy != this._exclusive) {
            ExclusivityPolicy newPolicy = this._exclusive;
            try {
                this._exclusive = existingExclusivePolicy;
                this.updateExclusivityPolicy(newPolicy);
            }
            catch (MessageSource.ExistingConsumerPreventsExclusive existingConsumerPreventsExclusive) {
                throw new IllegalArgumentException("Unable to set exclusivity policy to " + String.valueOf((Object)newPolicy) + " as an existing combinations of consumers prevents this");
            }
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        Queue queue = (Queue)proxyForValidation;
        for (String attrName : NON_NEGATIVE_NUMBERS) {
            Object value;
            if (!changedAttributes.contains(attrName) || (value = queue.getAttribute(attrName)) instanceof Number && ((Number)value).longValue() >= 0L) continue;
            throw new IllegalConfigurationException("Only positive integer value can be specified for the attribute " + attrName);
        }
        if (changedAttributes.contains("alternateBinding")) {
            this.validateOrCreateAlternateBinding(queue, false);
        }
        if (changedAttributes.contains("desiredState") && proxyForValidation.getDesiredState() == State.DELETED && this.hasReferrers()) {
            throw new MessageDestinationIsAlternateException(this.getName());
        }
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._virtualHost;
    }

    @Override
    public void authorisePublish(SecurityToken token, Map<String, Object> arguments) throws AccessControlException {
        this.authorise(token, PUBLISH_ACTION, arguments);
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(QueueMessages.OPERATION(operation));
    }

    @Override
    public List<Long> moveMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        MoveMessagesTransaction transaction = new MoveMessagesTransaction(this, messageIds, destination, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        this.logOperation(String.format("moveMessages : %s: %s: %d", this.getName(), destination.getName(), transaction.getModifiedMessageIds().size()));
        return transaction.getModifiedMessageIds();
    }

    @Override
    public List<Long> copyMessages(Queue<?> destination, List<Long> messageIds, String selector, int limit) {
        CopyMessagesTransaction transaction = new CopyMessagesTransaction(this, messageIds, destination, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        this.logOperation(String.format("copyMessages : %s: %s: %d", this.getName(), destination.getName(), transaction.getModifiedMessageIds().size()));
        return transaction.getModifiedMessageIds();
    }

    @Override
    public List<Long> deleteMessages(List<Long> messageIds, String selector, int limit) {
        DeleteMessagesTransaction transaction = new DeleteMessagesTransaction(this, messageIds, this.parseSelector(selector), limit);
        this._virtualHost.executeTransaction(transaction);
        this.logOperation(String.format("deleteMessages : %s: %d", this.getName(), transaction.getModifiedMessageIds().size()));
        return transaction.getModifiedMessageIds();
    }

    private JMSSelectorFilter parseSelector(String selector) {
        try {
            return selector == null ? null : new JMSSelectorFilter(selector);
        }
        catch (SelectorParsingException | ParseException | TokenMgrError e) {
            throw new IllegalArgumentException("Cannot parse JMS selector \"" + selector + "\"", e);
        }
    }

    @Override
    public Content getMessageContent(long messageId, long limit, boolean returnJson, boolean decompressBeforeLimiting) {
        MessageContentFinder messageFinder = new MessageContentFinder(messageId);
        this.visit(messageFinder);
        if (messageFinder.isFound()) {
            return this.createMessageContent(messageFinder.getMessageReference(), returnJson, limit, decompressBeforeLimiting);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Content createMessageContent(MessageReference<?> messageReference, boolean returnJson, long limit, boolean decompressBeforeLimiting) {
        if (returnJson) {
            Object message = messageReference.getMessage();
            if (message instanceof InternalMessage) {
                return new JsonMessageContent(messageReference, (InternalMessage)message, limit);
            }
            MessageConverter<?, InternalMessage> messageConverter = MessageConverterRegistry.getConverter(message.getClass(), InternalMessage.class);
            if (messageConverter != null && message.checkValid()) {
                InternalMessage convertedMessage = null;
                try {
                    convertedMessage = messageConverter.convert(message, this.getVirtualHost());
                    JsonMessageContent jsonMessageContent = new JsonMessageContent(messageReference, convertedMessage, limit);
                    return jsonMessageContent;
                }
                finally {
                    if (convertedMessage != null) {
                        messageConverter.dispose(convertedMessage);
                    }
                }
            }
            throw new IllegalArgumentException(String.format("Unable to convert message %d on queue '%s' to JSON", message.getMessageNumber(), this.getName()));
        }
        return new MessageContent(messageReference, limit, decompressBeforeLimiting);
    }

    @Override
    public List<MessageInfo> getMessageInfo(int first, int last, boolean includeHeaders) {
        MessageCollector messageCollector = new MessageCollector(first, last, includeHeaders);
        this.visit(messageCollector);
        return messageCollector.getMessages();
    }

    @Override
    public MessageInfo getMessageInfoById(long messageId, boolean includeHeaders) {
        MessageFinder messageFinder = new MessageFinder(messageId, includeHeaders);
        this.visit(messageFinder);
        return messageFinder.getMessageInfo();
    }

    @Override
    public QueueEntry getLeastSignificantOldestEntry() {
        return this.getEntries().getLeastSignificantOldestEntry();
    }

    @Override
    public void removeReference(DestinationReferrer destinationReferrer) {
        this._referrers.remove(destinationReferrer);
    }

    @Override
    public void addReference(DestinationReferrer destinationReferrer) {
        this._referrers.add(destinationReferrer);
    }

    private boolean hasReferrers() {
        return !this._referrers.isEmpty();
    }

    @Override
    public void linkAdded(MessageSender sender, PublishingLink link) {
        Integer oldValue = this._linkedSenders.putIfAbsent(sender, 1);
        if (oldValue != null) {
            this._linkedSenders.put(sender, oldValue + 1);
        }
        if ("link".equals(link.getType())) {
            this._producerCount.incrementAndGet();
            this.getEventLogger().message(SenderMessages.CREATE(link.getName(), link.getDestination()));
        }
        if ("binding".equals(link.getType())) {
            ++this._bindingCount;
        }
    }

    @Override
    public void linkRemoved(MessageSender sender, PublishingLink link) {
        int oldValue = (Integer)this._linkedSenders.remove(sender);
        if (oldValue != 1) {
            this._linkedSenders.put(sender, oldValue - 1);
        }
        if ("link".equals(link.getType())) {
            this._producerCount.decrementAndGet();
            this.getEventLogger().message(SenderMessages.CLOSE(link.getName(), link.getDestination()));
        }
        if ("binding".equals(link.getType())) {
            --this._bindingCount;
        }
    }

    @Override
    public MessageSource.MessageConversionExceptionHandlingPolicy getMessageConversionExceptionHandlingPolicy() {
        return this._messageConversionExceptionHandlingPolicy;
    }

    private void validateOrCreateAlternateBinding(Queue<?> queue, boolean mayCreate) {
        Object value = queue.getAttribute("alternateBinding");
        if (value instanceof AlternateBinding) {
            AlternateBinding alternateBinding = (AlternateBinding)value;
            String destinationName = alternateBinding.getDestination();
            MessageDestination messageDestination = this._virtualHost.getAttainedMessageDestination(destinationName, mayCreate);
            if (messageDestination == null) {
                throw new UnknownAlternateBindingException(destinationName);
            }
            if (messageDestination == this) {
                throw new IllegalConfigurationException(String.format("Cannot create alternate binding for '%s' : Alternate binding destination cannot refer to self.", this.getName()));
            }
            if (this.isDurable() && !messageDestination.isDurable()) {
                throw new IllegalConfigurationException(String.format("Cannot create alternate binding for '%s' : Alternate binding destination '%s' is not durable.", this.getName(), destinationName));
            }
        }
    }

    @Override
    public void registerTransaction(ServerTransaction tx) {
        if (tx instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)tx;
            if (!this.isDeleted()) {
                if (this._transactions.add(localTransaction)) {
                    localTransaction.addTransactionListener(this._localTransactionListener);
                    if (this.isDeleted()) {
                        localTransaction.setRollbackOnly();
                        this.unregisterTransaction(localTransaction);
                    }
                }
            } else {
                localTransaction.setRollbackOnly();
            }
        }
    }

    @Override
    public void unregisterTransaction(ServerTransaction tx) {
        if (tx instanceof LocalTransaction) {
            LocalTransaction localTransaction = (LocalTransaction)tx;
            localTransaction.removeTransactionListener(this._localTransactionListener);
            this._transactions.remove(localTransaction);
        }
    }

    private void queueMessageTtlChanged() {
        if (this.getState() == State.ACTIVE) {
            String taskName = String.format("Queue Housekeeping : %s : TTL Update", this.getName());
            this.getVirtualHost().executeTask(taskName, this::updateQueueEntryExpiration, this.getSystemTaskControllerContext(taskName, this._virtualHost.getPrincipal()));
        }
    }

    private void updateQueueEntryExpiration() {
        QueueEntryList entries = this.getEntries();
        if (entries != null) {
            QueueEntryIterator queueListIterator = entries.iterator();
            while (!this._stopped.get() && queueListIterator.advance()) {
                QueueEntry node = queueListIterator.getNode();
                if (node.isDeleted()) continue;
                ServerMessage msg = node.getMessage();
                if (msg != null) {
                    try (MessageReference messageReference = msg.newReference();){
                        this.updateExpiration(node);
                    }
                    catch (MessageDeletedException messageDeletedException) {
                        // empty catch block
                    }
                }
                if (!node.expired()) continue;
                this.expireEntry(node);
            }
        }
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(this._logSubject, QueueMessages.CREATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    @Override
    protected void logRecovered(Outcome outcome) {
        this.getEventLogger().message(this._logSubject, QueueMessages.OPEN(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this.getEventLogger().message(this._logSubject, QueueMessages.DELETE(this.getName(), String.valueOf((Object)outcome)));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        this.getEventLogger().message(this._logSubject, QueueMessages.UPDATE(this.getName(), String.valueOf((Object)outcome), this.attributesAsString(attributes)));
    }

    private class DeletedChildListener
    extends AbstractConfigurationChangeListener {
        private DeletedChildListener() {
        }

        public void stateChanged(ConfiguredObject object, State oldState, State newState) {
            if (newState == State.DELETED) {
                AbstractQueue.this.childRemoved(object);
            }
        }
    }

    private class AdvanceConsumersTask
    extends HouseKeepingTask {
        AdvanceConsumersTask() {
            super("Queue Housekeeping: " + AbstractQueue.this.getName(), AbstractQueue.this._virtualHost, AbstractQueue.this.getSystemTaskControllerContext("Queue Housekeeping", AbstractQueue.this._virtualHost.getPrincipal()));
        }

        @Override
        public void execute() {
            Iterator<QueueConsumer<?, ?>> consumerIterator = AbstractQueue.this._queueConsumerManager.getAllIterator();
            while (consumerIterator.hasNext() && !AbstractQueue.this.isDeleted()) {
                QueueConsumer<?, ?> sub = consumerIterator.next();
                if (!sub.acquires()) continue;
                AbstractQueue.this.getNextAvailableEntry(sub);
            }
        }
    }

    private static interface HoldMethod {
        public boolean isHeld(MessageReference<?> var1, long var2);
    }

    private class ClearOwnerAction
    implements Action<Deletable> {
        private final Deletable<? extends Deletable> _lifetimeObject;
        private DeleteDeleteTask _deleteTask;

        public ClearOwnerAction(Deletable<? extends Deletable> lifetimeObject) {
            this._lifetimeObject = lifetimeObject;
        }

        @Override
        public void performAction(Deletable object) {
            if (AbstractQueue.this._exclusiveOwner == this._lifetimeObject) {
                AbstractQueue.this._exclusiveOwner = null;
            }
            if (this._deleteTask != null) {
                AbstractQueue.this.removeDeleteTask(this._deleteTask);
            }
        }

        public void setDeleteTask(DeleteDeleteTask deleteTask) {
            this._deleteTask = deleteTask;
        }
    }

    private static class EnqueueRequest {
        private final MessageReference<?> _message;
        private final Action<? super MessageInstance> _action;
        private final MessageEnqueueRecord _enqueueRecord;

        public EnqueueRequest(ServerMessage message, Action<? super MessageInstance> action, MessageEnqueueRecord enqueueRecord) {
            this._enqueueRecord = enqueueRecord;
            this._message = message.newReference();
            this._action = action;
        }

        public MessageReference<?> getMessage() {
            return this._message;
        }

        public Action<? super MessageInstance> getAction() {
            return this._action;
        }

        public MessageEnqueueRecord getEnqueueRecord() {
            return this._enqueueRecord;
        }
    }

    public static interface QueueEntryFilter {
        public boolean accept(QueueEntry var1);

        public boolean filterComplete();
    }

    private final class DequeueEntryTask
    implements Runnable {
        private final QueueEntry _entry;
        private final Runnable _postDequeueTask;

        public DequeueEntryTask(QueueEntry entry, Runnable postDequeueTask) {
            this._entry = entry;
            this._postDequeueTask = postDequeueTask;
        }

        @Override
        public void run() {
            LOGGER.debug("Dequeuing stolen node {}", (Object)this._entry);
            AbstractQueue.this.dequeueEntry(this._entry);
            if (this._postDequeueTask != null) {
                this._postDequeueTask.run();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DequeueEntryTask that = (DequeueEntryTask)o;
            return this._entry == that._entry && Objects.equals(this._postDequeueTask, that._postDequeueTask);
        }

        public int hashCode() {
            return Objects.hash(this._entry, this._postDequeueTask);
        }
    }

    private static class AcquireAllQueueEntryFilter
    implements QueueEntryFilter {
        private AcquireAllQueueEntryFilter() {
        }

        @Override
        public boolean accept(QueueEntry entry) {
            return entry.acquire();
        }

        @Override
        public boolean filterComplete() {
            return false;
        }
    }

    private static class MessageContentFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private boolean _found;
        private MessageReference<?> _messageReference;

        private MessageContentFinder(long messageNumber) {
            this._messageNumber = messageNumber;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                try {
                    this._messageReference = message.newReference();
                    this._found = true;
                    return true;
                }
                catch (MessageDeletedException messageDeletedException) {
                    // empty catch block
                }
            }
            return false;
        }

        MessageReference<?> getMessageReference() {
            return this._messageReference;
        }

        public boolean isFound() {
            return this._found;
        }
    }

    class JsonMessageContent
    extends BaseMessageContent {
        private final InternalMessage _internalMessage;

        JsonMessageContent(MessageReference<?> messageReference, InternalMessage message, long limit) {
            super(messageReference, limit);
            this._internalMessage = message;
        }

        @Override
        public void write(OutputStream outputStream) throws IOException {
            Object messageBody = this._internalMessage.getMessageBody();
            new MessageContentJsonConverter(messageBody, this.isTruncated() ? this._limit : -1L).convertAndWrite(outputStream);
        }

        @Override
        @RestContentHeader(value="Content-Encoding")
        public String getContentEncoding() {
            return "identity";
        }

        @Override
        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return "application/json";
        }
    }

    class MessageContent
    extends BaseMessageContent {
        private boolean _decompressBeforeLimiting;

        MessageContent(MessageReference<?> messageReference, long limit, boolean decompressBeforeLimiting) {
            super(messageReference, limit);
            if (decompressBeforeLimiting) {
                String contentEncoding = this.getContentEncoding();
                if ("gzip".equals(contentEncoding)) {
                    this._decompressBeforeLimiting = true;
                } else if (contentEncoding != null && !"".equals(contentEncoding) && !"identity".equals(contentEncoding)) {
                    throw new IllegalArgumentException(String.format("Requested decompression of message with unknown compression '%s'", contentEncoding));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream outputStream) throws IOException {
            Object message = this._messageReference.getMessage();
            int length = (int)(this._limit == -1L || this._decompressBeforeLimiting ? message.getSize() : this._limit);
            try (QpidByteBuffer content = message.getContent(0, length);){
                InputStream inputStream = content.asInputStream();
                if (this._limit != -1L && this._decompressBeforeLimiting) {
                    inputStream = new GZIPInputStream(inputStream);
                    inputStream = new LimitedInputStream(inputStream, this._limit);
                    outputStream = new GZIPOutputStream(outputStream, true);
                }
                try {
                    inputStream.transferTo(outputStream);
                }
                finally {
                    inputStream.close();
                    outputStream.close();
                }
            }
        }
    }

    private class MessageCollector
    implements QueueEntryVisitor {
        private final int _first;
        private final int _last;
        private int _position = -1;
        private final List<MessageInfo> _messages = new MessageRangeList();
        private final boolean _includeHeaders;

        private MessageCollector(int first, int last, boolean includeHeaders) {
            this._first = first;
            this._last = last;
            this._includeHeaders = includeHeaders;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ++this._position;
            if (!(this._first != -1 && this._position < this._first || this._last != -1 && this._position > this._last)) {
                this._messages.add(new MessageInfoImpl(entry, this._includeHeaders));
            }
            return this._last != -1 && this._position > this._last;
        }

        public List<MessageInfo> getMessages() {
            return this._messages;
        }

        private class MessageRangeList
        extends ArrayList<MessageInfo>
        implements CustomRestHeaders {
            private MessageRangeList() {
            }

            @RestContentHeader(value="Content-Range")
            public String getContentRange() {
                String min = this.isEmpty() ? "0" : String.valueOf(MessageCollector.this._first);
                String max = this.isEmpty() ? "0" : String.valueOf(MessageCollector.this._first + this.size() - 1);
                return min + "-" + max + "/" + AbstractQueue.this.getQueueDepthMessages();
            }
        }
    }

    private static class MessageFinder
    implements QueueEntryVisitor {
        private final long _messageNumber;
        private final boolean _includeHeaders;
        private MessageInfo _messageInfo;

        private MessageFinder(long messageNumber, boolean includeHeaders) {
            this._messageNumber = messageNumber;
            this._includeHeaders = includeHeaders;
        }

        @Override
        public boolean visit(QueueEntry entry) {
            ServerMessage message = entry.getMessage();
            if (message != null && this._messageNumber == message.getMessageNumber()) {
                this._messageInfo = new MessageInfoImpl(entry, this._includeHeaders);
                return true;
            }
            return false;
        }

        public MessageInfo getMessageInfo() {
            return this._messageInfo;
        }
    }

    abstract class BaseMessageContent
    implements Content,
    CustomRestHeaders {
        public static final int UNLIMITED = -1;
        protected final MessageReference<?> _messageReference;
        protected final long _limit;
        private final boolean _truncated;

        BaseMessageContent(MessageReference<?> messageReference, long limit) {
            this._messageReference = messageReference;
            this._limit = limit;
            this._truncated = limit >= 0L && this._messageReference.getMessage().getSize() > limit;
        }

        @Override
        public final void release() {
            this._messageReference.release();
        }

        protected boolean isTruncated() {
            return this._truncated;
        }

        @RestContentHeader(value="X-Content-Truncated")
        public String getContentTruncated() {
            return String.valueOf(this.isTruncated());
        }

        @RestContentHeader(value="Content-Type")
        public String getContentType() {
            return this._messageReference.getMessage().getMessageHeader().getMimeType();
        }

        @RestContentHeader(value="Content-Encoding")
        public String getContentEncoding() {
            return this._messageReference.getMessage().getMessageHeader().getEncoding();
        }

        @RestContentHeader(value="Content-Disposition")
        public String getContentDisposition() {
            try {
                String queueName = AbstractQueue.this.getName();
                String asciiQueueName = queueName.replaceAll("[^\\x20-\\x7E]", "?").replace('\\', '?').replaceAll("%[0-9a-fA-F]{2}", "?");
                long messageNumber = this._messageReference.getMessage().getMessageNumber();
                String filenameExtension = AbstractQueue.this._mimeTypeToFileExtension.get(this.getContentType());
                filenameExtension = filenameExtension == null ? "" : filenameExtension;
                String disposition = String.format("attachment; filename=\"%s_msg%09d%s\"; filename*=\"UTF-8''%s_msg%09d%s\"", asciiQueueName, messageNumber, filenameExtension, URLEncoder.encode(queueName, UTF8), messageNumber, filenameExtension);
                return disposition;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("JVM does not support UTF8", e);
            }
        }
    }
}

