/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.server.bytebuffer.BufferPool;
import org.apache.qpid.server.bytebuffer.ByteBufferRef;
import org.apache.qpid.server.bytebuffer.MultiQpidByteBuffer;
import org.apache.qpid.server.bytebuffer.NonPooledByteBufferRef;
import org.apache.qpid.server.bytebuffer.PooledByteBufferRef;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBufferOutputStream;
import org.apache.qpid.server.bytebuffer.SingleQpidByteBuffer;

final class QpidByteBufferFactory {
    private static final ByteBuffer[] EMPTY_BYTE_BUFFER_ARRAY = new ByteBuffer[0];
    private static final QpidByteBuffer EMPTY_QPID_BYTE_BUFFER = QpidByteBuffer.wrap(new byte[0]);
    private static final ThreadLocal<SingleQpidByteBuffer> _cachedBuffer = new ThreadLocal();
    private static volatile boolean _isPoolInitialized;
    private static volatile BufferPool _bufferPool;
    private static volatile int _pooledBufferSize;
    private static volatile double _sparsityFraction;
    private static volatile ByteBuffer _zeroed;

    QpidByteBufferFactory() {
    }

    static QpidByteBuffer allocate(boolean direct, int size) {
        return direct ? QpidByteBufferFactory.allocateDirect(size) : QpidByteBufferFactory.allocate(size);
    }

    static QpidByteBuffer allocate(int size) {
        return new SingleQpidByteBuffer(new NonPooledByteBufferRef(ByteBuffer.allocate(size)));
    }

    static QpidByteBuffer allocateDirect(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot allocate QpidByteBufferFragment with size " + size + " which is negative.");
        }
        if (_isPoolInitialized) {
            if (size <= _pooledBufferSize) {
                return QpidByteBufferFactory.allocateDirectSingle(size);
            }
            ArrayList<SingleQpidByteBuffer> fragments = new ArrayList<SingleQpidByteBuffer>();
            int allocatedSize = 0;
            while (size - allocatedSize >= _pooledBufferSize) {
                fragments.add(QpidByteBufferFactory.allocateDirectSingle(_pooledBufferSize));
                allocatedSize += _pooledBufferSize;
            }
            if (allocatedSize != size) {
                fragments.add(QpidByteBufferFactory.allocateDirectSingle(size - allocatedSize));
            }
            return new MultiQpidByteBuffer(fragments);
        }
        return QpidByteBufferFactory.allocate(size);
    }

    static QpidByteBuffer asQpidByteBuffer(InputStream stream) throws IOException {
        SingleQpidByteBuffer fragment;
        ArrayList<SingleQpidByteBuffer> fragments = new ArrayList<SingleQpidByteBuffer>();
        int pooledBufferSize = QpidByteBufferFactory.getPooledBufferSize();
        byte[] transferBuf = new byte[pooledBufferSize];
        int readFragment = 0;
        int read = stream.read(transferBuf, readFragment, pooledBufferSize - readFragment);
        while (read > 0) {
            if ((readFragment += read) == pooledBufferSize) {
                fragment = QpidByteBufferFactory.allocateDirectSingle(pooledBufferSize);
                fragment.put(transferBuf, 0, pooledBufferSize);
                fragment.flip();
                fragments.add(fragment);
                readFragment = 0;
            }
            read = stream.read(transferBuf, readFragment, pooledBufferSize - readFragment);
        }
        if (readFragment != 0) {
            fragment = QpidByteBufferFactory.allocateDirectSingle(readFragment);
            fragment.put(transferBuf, 0, readFragment);
            fragment.flip();
            fragments.add(fragment);
        }
        return QpidByteBufferFactory.createQpidByteBuffer(fragments);
    }

    private static QpidByteBuffer asQpidByteBuffer(byte[] data, int offset, int length) {
        QpidByteBuffer qpidByteBuffer;
        QpidByteBufferOutputStream outputStream = new QpidByteBufferOutputStream(true, QpidByteBuffer.getPooledBufferSize());
        try {
            outputStream.write(data, offset, length);
            qpidByteBuffer = outputStream.fetchAccumulatedBuffer();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected Error converting array to QpidByteBuffers", e);
            }
        }
        outputStream.close();
        return qpidByteBuffer;
    }

    private static ByteBuffer[] getUnderlyingBuffers(QpidByteBuffer buffer) {
        if (buffer instanceof SingleQpidByteBuffer) {
            return new ByteBuffer[]{((SingleQpidByteBuffer)buffer).getUnderlyingBuffer()};
        }
        if (buffer instanceof MultiQpidByteBuffer) {
            return ((MultiQpidByteBuffer)buffer).getUnderlyingBuffers();
        }
        throw new IllegalStateException("Unknown Buffer Implementation");
    }

    static SSLEngineResult encryptSSL(SSLEngine engine, Collection<QpidByteBuffer> buffers, QpidByteBuffer dest) throws SSLException {
        if (dest instanceof SingleQpidByteBuffer) {
            ByteBuffer[] src;
            SingleQpidByteBuffer dst = (SingleQpidByteBuffer)dest;
            if (buffers.isEmpty()) {
                src = EMPTY_BYTE_BUFFER_ARRAY;
            } else {
                LinkedList buffers_ = new LinkedList();
                for (QpidByteBuffer buffer : buffers) {
                    Collections.addAll(buffers_, QpidByteBufferFactory.getUnderlyingBuffers(buffer));
                }
                src = buffers_.toArray(new ByteBuffer[buffers_.size()]);
            }
            return engine.wrap(src, dst.getUnderlyingBuffer());
        }
        throw new IllegalStateException("Expected a single fragment output buffer");
    }

    static SSLEngineResult decryptSSL(SSLEngine engine, QpidByteBuffer src, QpidByteBuffer dst) throws SSLException {
        if (src instanceof SingleQpidByteBuffer) {
            ByteBuffer underlying = ((SingleQpidByteBuffer)src).getUnderlyingBuffer();
            if (dst instanceof SingleQpidByteBuffer) {
                return engine.unwrap(underlying, ((SingleQpidByteBuffer)dst).getUnderlyingBuffer());
            }
            if (dst instanceof MultiQpidByteBuffer) {
                return engine.unwrap(underlying, ((MultiQpidByteBuffer)dst).getUnderlyingBuffers());
            }
            throw new IllegalStateException("unknown QBB implementation");
        }
        throw new IllegalStateException("Source QBB can only be single byte buffer");
    }

    static QpidByteBuffer inflate(QpidByteBuffer compressedBuffer) throws IOException {
        if (compressedBuffer == null) {
            throw new IllegalArgumentException("compressedBuffer cannot be null");
        }
        boolean isDirect = compressedBuffer.isDirect();
        int bufferSize = isDirect && _pooledBufferSize > 0 ? _pooledBufferSize : 65536;
        ArrayList<QpidByteBuffer> uncompressedBuffers = new ArrayList<QpidByteBuffer>();
        try {
            QpidByteBuffer qpidByteBuffer;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream(compressedBuffer.asInputStream());){
                int read;
                byte[] buf = new byte[bufferSize];
                while ((read = gzipInputStream.read(buf)) != -1) {
                    uncompressedBuffers.add(QpidByteBufferFactory.asQpidByteBuffer(buf, 0, read));
                }
                qpidByteBuffer = QpidByteBufferFactory.concatenate(uncompressedBuffers);
            }
            return qpidByteBuffer;
        }
        finally {
            uncompressedBuffers.forEach(QpidByteBuffer::dispose);
        }
    }

    /*
     * Exception decompiling
     */
    static QpidByteBuffer deflate(QpidByteBuffer uncompressedBuffer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static long write(GatheringByteChannel channel, Collection<QpidByteBuffer> qpidByteBuffers) throws IOException {
        ArrayList byteBuffers = new ArrayList();
        for (QpidByteBuffer qpidByteBuffer : qpidByteBuffers) {
            Collections.addAll(byteBuffers, QpidByteBufferFactory.getUnderlyingBuffers(qpidByteBuffer));
        }
        return channel.write(byteBuffers.toArray(new ByteBuffer[byteBuffers.size()]));
    }

    static QpidByteBuffer wrap(ByteBuffer wrap) {
        return new SingleQpidByteBuffer(new NonPooledByteBufferRef(wrap));
    }

    static QpidByteBuffer wrap(byte[] data) {
        return QpidByteBufferFactory.wrap(ByteBuffer.wrap(data));
    }

    static QpidByteBuffer wrap(byte[] data, int offset, int length) {
        return QpidByteBufferFactory.wrap(ByteBuffer.wrap(data, offset, length));
    }

    static void initialisePool(int bufferSize, int maxPoolSize, double sparsityFraction) {
        if (_isPoolInitialized && (bufferSize != _pooledBufferSize || maxPoolSize != _bufferPool.getMaxSize() || sparsityFraction != _sparsityFraction)) {
            String errorMessage = String.format("QpidByteBuffer pool has already been initialised with bufferSize=%d, maxPoolSize=%d, and sparsityFraction=%f.Re-initialisation with different bufferSize=%d and maxPoolSize=%d is not allowed.", _pooledBufferSize, _bufferPool.getMaxSize(), _sparsityFraction, bufferSize, maxPoolSize);
            throw new IllegalStateException(errorMessage);
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Negative or zero bufferSize illegal : " + bufferSize);
        }
        _bufferPool = new BufferPool(maxPoolSize);
        _pooledBufferSize = bufferSize;
        _zeroed = ByteBuffer.allocateDirect(_pooledBufferSize);
        _sparsityFraction = sparsityFraction;
        _isPoolInitialized = true;
    }

    static void deinitialisePool() {
        if (_isPoolInitialized) {
            SingleQpidByteBuffer singleQpidByteBuffer = _cachedBuffer.get();
            if (singleQpidByteBuffer != null) {
                singleQpidByteBuffer.dispose();
                _cachedBuffer.remove();
            }
            _bufferPool = null;
            _pooledBufferSize = -1;
            _isPoolInitialized = false;
            _sparsityFraction = 1.0;
            _zeroed = null;
        }
    }

    static void returnToPool(ByteBuffer buffer) {
        buffer.clear();
        if (_isPoolInitialized) {
            ByteBuffer duplicate = _zeroed.duplicate();
            duplicate.limit(buffer.capacity());
            buffer.put(duplicate);
            _bufferPool.returnBuffer(buffer);
        }
    }

    static double getSparsityFraction() {
        return _sparsityFraction;
    }

    static int getPooledBufferSize() {
        return _pooledBufferSize;
    }

    static long getAllocatedDirectMemorySize() {
        return (long)_pooledBufferSize * (long)QpidByteBufferFactory.getNumberOfBuffersInUse();
    }

    static int getNumberOfBuffersInUse() {
        return PooledByteBufferRef.getActiveBufferCount();
    }

    static int getNumberOfBuffersInPool() {
        return _bufferPool.size();
    }

    static long getPooledBufferDisposalCounter() {
        return PooledByteBufferRef.getDisposalCounter();
    }

    static QpidByteBuffer reallocateIfNecessary(QpidByteBuffer data) {
        if (data != null && data.isDirect() && data.isSparse()) {
            QpidByteBuffer newBuf = QpidByteBufferFactory.allocateDirect(data.remaining());
            newBuf.put(data);
            newBuf.flip();
            data.dispose();
            return newBuf;
        }
        return data;
    }

    static QpidByteBuffer concatenate(List<QpidByteBuffer> buffers) {
        ArrayList<SingleQpidByteBuffer> fragments = new ArrayList<SingleQpidByteBuffer>(buffers.size());
        for (QpidByteBuffer buffer : buffers) {
            if (buffer instanceof SingleQpidByteBuffer) {
                if (!buffer.hasRemaining()) continue;
                fragments.add((SingleQpidByteBuffer)buffer.slice());
                continue;
            }
            if (buffer instanceof MultiQpidByteBuffer) {
                for (SingleQpidByteBuffer fragment : ((MultiQpidByteBuffer)buffer).getFragments()) {
                    if (!fragment.hasRemaining()) continue;
                    fragments.add(fragment.slice());
                }
                continue;
            }
            throw new IllegalStateException("unknown QBB implementation");
        }
        return QpidByteBufferFactory.createQpidByteBuffer(fragments);
    }

    static QpidByteBuffer createQpidByteBuffer(List<SingleQpidByteBuffer> fragments) {
        if (fragments.size() == 0) {
            return QpidByteBufferFactory.emptyQpidByteBuffer();
        }
        if (fragments.size() == 1) {
            return fragments.get(0);
        }
        return new MultiQpidByteBuffer(fragments);
    }

    static QpidByteBuffer concatenate(QpidByteBuffer ... buffers) {
        return QpidByteBufferFactory.concatenate(Arrays.asList(buffers));
    }

    static QpidByteBuffer emptyQpidByteBuffer() {
        return EMPTY_QPID_BYTE_BUFFER.duplicate();
    }

    static ThreadFactory createQpidByteBufferTrackingThreadFactory(ThreadFactory factory) {
        return r -> factory.newThread(() -> {
            try {
                r.run();
            }
            finally {
                SingleQpidByteBuffer cachedThreadLocalBuffer = _cachedBuffer.get();
                if (cachedThreadLocalBuffer != null) {
                    cachedThreadLocalBuffer.dispose();
                    _cachedBuffer.remove();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static SingleQpidByteBuffer allocateDirectSingle(int size) {
        void var1_5;
        if (size < 0) {
            throw new IllegalArgumentException("Cannot allocate SingleQpidByteBuffer with size " + size + " which is negative.");
        }
        if (_isPoolInitialized && _pooledBufferSize >= size) {
            if (_pooledBufferSize == size) {
                ByteBuffer buf = _bufferPool.getBuffer();
                if (buf == null) {
                    buf = ByteBuffer.allocateDirect(size);
                }
                PooledByteBufferRef pooledByteBufferRef = new PooledByteBufferRef(buf);
                return new SingleQpidByteBuffer((ByteBufferRef)var1_5);
            }
            SingleQpidByteBuffer buf = _cachedBuffer.get();
            if (buf == null || buf.remaining() < size) {
                if (buf != null) {
                    buf.dispose();
                }
                buf = QpidByteBufferFactory.allocateDirectSingle(_pooledBufferSize);
                _cachedBuffer.set(buf);
            }
            SingleQpidByteBuffer rVal = buf.view(0, size);
            buf.position(buf.position() + size);
            return rVal;
        }
        NonPooledByteBufferRef nonPooledByteBufferRef = new NonPooledByteBufferRef(ByteBuffer.allocateDirect(size));
        return new SingleQpidByteBuffer((ByteBufferRef)var1_5);
    }
}

