/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import java.util.Arrays;
import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQFrameDecodingException;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.apache.qpid.server.protocol.v0_8.FieldTable;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ClientMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class ConnectionStartBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 10;
    private final short _versionMajor;
    private final short _versionMinor;
    private final FieldTable _serverProperties;
    private final byte[] _mechanisms;
    private final byte[] _locales;

    public ConnectionStartBody(short versionMajor, short versionMinor, FieldTable serverProperties, byte[] mechanisms, byte[] locales) {
        this._versionMajor = versionMajor;
        this._versionMinor = versionMinor;
        this._serverProperties = serverProperties;
        this._mechanisms = mechanisms;
        this._locales = locales;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final short getVersionMajor() {
        return this._versionMajor;
    }

    public final short getVersionMinor() {
        return this._versionMinor;
    }

    public final FieldTable getServerProperties() {
        return this._serverProperties;
    }

    public final byte[] getMechanisms() {
        return this._mechanisms;
    }

    public final byte[] getLocales() {
        return this._locales;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._serverProperties);
        size += this.getSizeOf(this._mechanisms);
        return size += this.getSizeOf(this._locales);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedByte(buffer, this._versionMajor);
        this.writeUnsignedByte(buffer, this._versionMinor);
        this.writeFieldTable(buffer, this._serverProperties);
        this.writeBytes(buffer, this._mechanisms);
        this.writeBytes(buffer, this._locales);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionStart(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartBodyImpl: ");
        buf.append("versionMajor=");
        buf.append(this.getVersionMajor());
        buf.append(", ");
        buf.append("versionMinor=");
        buf.append(this.getVersionMinor());
        buf.append(", ");
        buf.append("serverProperties=");
        buf.append(this.getServerProperties());
        buf.append(", ");
        buf.append("mechanisms=");
        buf.append(this.getMechanisms() == null ? "null" : Arrays.toString(this.getMechanisms()));
        buf.append(", ");
        buf.append("locales=");
        buf.append(this.getLocales() == null ? "null" : Arrays.toString(this.getLocales()));
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer in, ClientMethodProcessor dispatcher) throws AMQFrameDecodingException {
        short versionMajor = in.getUnsignedByte();
        short versionMinor = in.getUnsignedByte();
        FieldTable serverProperties = EncodingUtils.readFieldTable(in);
        byte[] mechanisms = EncodingUtils.readBytes(in);
        byte[] locales = EncodingUtils.readBytes(in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionStart(versionMajor, versionMinor, FieldTable.convertToDecodedFieldTable(serverProperties), mechanisms, locales);
        }
        if (serverProperties != null) {
            serverProperties.dispose();
        }
    }
}

