/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import lombok.Generated;

public class PolicyHierarchyValue<T> {
    private static final AtomicReferenceFieldUpdater<PolicyHierarchyValue, Object> VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PolicyHierarchyValue.class, Object.class, "value");
    private volatile T brokerValue;
    private volatile T namespaceValue;
    private volatile T topicValue;
    private volatile T topicGlobalValue;
    private volatile T value;

    public void updateBrokerValue(T brokerValue) {
        this.brokerValue = brokerValue;
        this.updateValue();
    }

    public void updateNamespaceValue(T namespaceValue) {
        this.namespaceValue = namespaceValue;
        this.updateValue();
    }

    @Deprecated
    public void updateTopicValue(T topicValue) {
        this.updateTopicValue(topicValue, false);
    }

    public void updateTopicValue(T topicValue, boolean isGlobalPolicy) {
        if (isGlobalPolicy) {
            this.topicGlobalValue = topicValue;
        } else {
            this.topicValue = topicValue;
        }
        this.updateValue();
    }

    private void updateValue() {
        VALUE_UPDATER.updateAndGet(this, preValue -> {
            if (this.topicValue != null) {
                return this.topicValue;
            }
            if (this.topicGlobalValue != null) {
                return this.topicGlobalValue;
            }
            if (this.namespaceValue != null) {
                return this.namespaceValue;
            }
            return this.brokerValue;
        });
    }

    public T get() {
        return this.value;
    }

    @Generated
    public T getBrokerValue() {
        return this.brokerValue;
    }

    @Generated
    public T getNamespaceValue() {
        return this.namespaceValue;
    }

    @Generated
    public T getTopicValue() {
        return this.topicValue;
    }

    @Generated
    public T getTopicGlobalValue() {
        return this.topicGlobalValue;
    }
}

