/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.schema;

import java.nio.ByteBuffer;

public class SchemaIdUtil {
    public static final byte MAGIC_BYTE_VALUE = -1;
    public static final byte MAGIC_BYTE_KEY_VALUE = -2;

    public static byte[] addMagicHeader(byte[] data, boolean isKeyValue) {
        if (data == null || data.length == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + data.length);
        buffer.put(isKeyValue ? (byte)-2 : -1);
        buffer.put(data);
        return buffer.array();
    }

    public static byte[] removeMagicHeader(byte[] schemaId) {
        if (schemaId == null || schemaId.length == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(schemaId);
        byte magicByte = buffer.get();
        if (magicByte != -1 && magicByte != -2) {
            return schemaId;
        }
        byte[] id = new byte[buffer.remaining()];
        buffer.get(id);
        return id;
    }
}

