/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.session;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.cli.api.SessionException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class GetVariable
extends AbstractCommand<StringResult> {
    public GetVariable() {
        super("get", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the value of the given variable in the session.";
    }

    @Override
    public StringResult execute(CommandLine commandLine) throws CommandException {
        String[] args = commandLine.getArgs();
        if (args == null || args.length != 1 || StringUtils.isBlank((CharSequence)args[0])) {
            throw new CommandException("Incorrect number of arguments, should be: <var>");
        }
        Session session = this.getContext().getSession();
        try {
            String value = session.get(args[0]);
            if (value == null) {
                return new StringResult("", this.getContext().isInteractive());
            }
            return new StringResult(value, this.getContext().isInteractive());
        }
        catch (SessionException se) {
            throw new CommandException(se.getMessage(), se);
        }
    }
}

