/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal.concurrent;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.maven.lifecycle.internal.concurrent.BuildPlan;
import org.apache.maven.lifecycle.internal.concurrent.BuildStep;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BuildPlanLogger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void writePlan(BuildPlan plan) {
        if (this.logger.isDebugEnabled()) {
            this.writePlan(arg_0 -> ((Logger)this.logger).debug(arg_0), plan);
        }
    }

    public void writePlan(BuildPlan plan, MavenProject project) {
        if (this.logger.isDebugEnabled()) {
            this.writePlan(arg_0 -> ((Logger)this.logger).debug(arg_0), plan, project);
        }
    }

    public void writePlan(Consumer<String> writer, BuildPlan plan) {
        plan.projects().forEach(project -> this.writePlan(writer, plan, (MavenProject)project));
    }

    public void writePlan(Consumer<String> writer, BuildPlan plan, MavenProject project) {
        writer.accept("=== PROJECT BUILD PLAN ================================================");
        writer.accept("Project:                     " + this.getKey(project));
        writer.accept("Repositories (dependencies): " + String.valueOf(project.getRemoteProjectRepositories()));
        writer.accept("Repositories (plugins):      " + String.valueOf(project.getRemotePluginRepositories()));
        Optional<BuildStep> planStep = plan.step(project, "$plan$");
        if (planStep.isPresent() && planStep.get().status.get() == 1) {
            writer.accept("Build plan will be lazily computed");
        } else {
            plan.steps(project).filter(step -> step.phase != null && step.executions().findAny().isPresent()).sorted(Comparator.comparingInt(plan.sortedNodes()::indexOf)).forEach(step -> {
                writer.accept("\t-----------------------------------------------------------------------");
                writer.accept("\tPhase:         " + step.name);
                if (!step.predecessors.isEmpty()) {
                    writer.accept("\tPredecessors:  " + this.nonEmptyPredecessors((BuildStep)step).map(n -> this.phase(project, (BuildStep)n, plan.duplicateIds())).collect(Collectors.joining(", ")));
                }
                step.mojos.values().stream().flatMap(m -> m.values().stream()).forEach(mojo -> this.mojo(writer, (MojoExecution)mojo));
            });
        }
        writer.accept("=======================================================================");
    }

    protected Stream<BuildStep> nonEmptyPredecessors(BuildStep step) {
        HashSet<BuildStep> preds = new HashSet<BuildStep>();
        this.nonEmptyPredecessors(step, preds, new HashSet<BuildStep>());
        return preds.stream();
    }

    private void nonEmptyPredecessors(BuildStep step, Set<BuildStep> preds, Set<BuildStep> visited) {
        if (visited.add(step)) {
            step.predecessors.forEach(ch -> {
                if (ch.executions().findAny().isPresent()) {
                    preds.add((BuildStep)ch);
                } else {
                    this.nonEmptyPredecessors((BuildStep)ch, preds, visited);
                }
            });
        }
    }

    protected String phase(MavenProject currentProject, BuildStep step, Set<String> duplicateIds) {
        if (step.project == currentProject) {
            return step.name;
        }
        String artifactId = step.project.getArtifactId();
        if (duplicateIds.contains(artifactId)) {
            return step.name + "(" + step.project.getGroupId() + ":" + artifactId + ")";
        }
        return step.name + "(:" + artifactId + ")";
    }

    protected void mojo(Consumer<String> writer, MojoExecution mojoExecution) {
        String mojoExecId = mojoExecution.getGroupId() + ":" + mojoExecution.getArtifactId() + ":" + mojoExecution.getVersion() + ":" + mojoExecution.getGoal() + " (" + mojoExecution.getExecutionId() + ")";
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                writer.accept("\t--- init fork of " + fork.getKey() + " for " + mojoExecId + " ---");
                for (MojoExecution forkedExecution : fork.getValue()) {
                    this.mojo(writer, forkedExecution);
                }
                writer.accept("\t--- exit fork of " + fork.getKey() + " for " + mojoExecId + " ---");
            }
        }
        writer.accept("\t\t-----------------------------------------------------------------------");
        if (mojoExecution.getMojoDescriptor().isAggregator()) {
            writer.accept("\t\tAggregator goal:        " + mojoExecId);
        } else {
            writer.accept("\t\tGoal:                   " + mojoExecId);
        }
        if (mojoExecution.getConfiguration() != null) {
            writer.accept("\t\tConfiguration:          " + String.valueOf(mojoExecution.getConfiguration()));
        }
        if (mojoExecution.getMojoDescriptor().getDependencyCollectionRequired() != null) {
            writer.accept("\t\tDependencies (collect): " + mojoExecution.getMojoDescriptor().getDependencyCollectionRequired());
        }
        if (mojoExecution.getMojoDescriptor().getDependencyResolutionRequired() != null) {
            writer.accept("\t\tDependencies (resolve): " + mojoExecution.getMojoDescriptor().getDependencyResolutionRequired());
        }
    }

    protected String getKey(MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion();
    }
}

